ORCA/M Asm65816 2.1.0

0001 0AF3              **********************************************************************
0002 0AF3              *
0003 0AF3              * NewCalls.asm
0004 0AF3              *
0005 0AF3              * Copyright (C) 1986-1993 Apple Computer, Inc.
0006 0AF3              * All rights reserved
0007 0AF3              *
0008 0AF3              * Original Code
0009 0AF3              * by Dan Oliver
0010 0AF3              *
0011 0AF3              **********************************************************************
0012 0AF3              *
0013 0AF3              * Contains:
0014 0AF3              *
0015 0AF3              *                   GetAuxWindInfo      ;added 19-Jan-91 Dave Lyons
0016 0AF3              *                   DoModalWindow       ;...
0017 0AF3              *                   MWGetCtlPart
0018 0AF3              *                   MWSetMenuProc
0019 0AF3              *                   MWStdDrawProc
0020 0AF3              *                   MWSetUpEditMenu
0021 0AF3              *                   FindCursorCtl
0022 0AF3              *                   ResizeInfoBar       ;added 5-Mar-91 DAL
0023 0AF3              *                   HandleDiskInsert    ;added 12-Mar-91 DAL
0024 0AF3              *
0025 0AF3              **********************************************************************
0026 0AF3
0027 0AF3              **********************************************************************
0028 0AF3              *
0029 0AF3              * Change History
0030 0AF3              *
0031 0AF3              * 21-Sep-90         Dave Lyons
0032 0AF3              *
0033 0AF3              * Fixed returned carry status on ErrorWindow.
0034 0AF3              * Changed hard-coded memory IDs from $1001 to $400E.
0035 0AF3              * Saved a few bytes here and there (all marked).
0036 0AF3              *
0037 0AF3              * 14-Nov-90         Dave Lyons
0038 0AF3              *
0039 0AF3              * Working on AlertWindow.  TS3 will use this version.
0040 0AF3              *
0041 0AF3              * (done) Bit 3 of flags = ignore icon width in rectangle computation
0042 0AF3              * (We draw the icon -after- the text now, to support bit 3.)
0043 0AF3              * Doesn't hang if you have a "^" in your alert text.
0044 0AF3              *
0045 0AF3              * 10-Dec-90         Dave Lyons
0046 0AF3              *
0047 0AF3              * Added check of xxBounds+x2 before PPToPort code, in case we don't
0048 0AF3              * have an icon to draw (discovered by Bill Mitchell/Mensch).
0049 0AF3              *
0050 0AF3              * 19-Jan-91         Dave Lyons
0051 0AF3              *
0052 0AF3              * Adding new call GetAuxWindInfo.
0053 0AF3              *
0054 0AF3              * Adding new calls DoModalWindow, MWGetCtlPart, MWSetMenuProc,
0055 0AF3              * MWStdDrawProc, MWSetUpEditMenu, FindCursorCtl.
0056 0AF3              *
0057 0AF3              * 22-Jan-91         Dave Lyons
0058 0AF3              *
0059 0AF3              * Finished adding the modal window calls.
0060 0AF3              *
0061 0AF3              * 14-Feb-91         Dave Lyons
0062 0AF3              *
0063 0AF3              * Bit 31 of the DoModalWindow event hook now translates Apple-period
0064 0AF3              * into Escape for you.
0065 0AF3              *
0066 0AF3              * 15-Feb-91         Dave Lyons
0067 0AF3              *
0068 0AF3              * DoModalWindow calls SysBeep2(4) if you click in the wrong window.
0069 0AF3              * Removed special handling for zero-length text scraps, since these
0070 0AF3              * no longer cause Line Edit to trash memory.
0071 0AF3              *
0072 0AF3              * 17-Feb-91         Dave Lyons
0073 0AF3              *
0074 0AF3              * DoModalWindow now calls GetNextEvent with even mask $0FFF, not $FFFF.
0075 0AF3              * We don't fetch any application events.
0076 0AF3              *
0077 0AF3              * 28-Feb-91         Dave Lyons
0078 0AF3              *
0079 0AF3              * When GetAuxWindInfo expanded its handle, the calculated size was too
0080 0AF3              * low by 4 bytes, so it was trashing 4 bytes of memory.
0081 0AF3              *
0082 0AF3              * 3-Mar-91          Dave Lyons
0083 0AF3              *
0084 0AF3              * Fixed GetAuxWindInfo again; I was really trashing 8 bytes before, and
0085 0AF3              * 4 after the previous fix.  Now it's 0.
0086 0AF3              *
0087 0AF3              * 4-Mar-91          Dave Lyons
0088 0AF3              *
0089 0AF3              * AlertWindow now has an update routine!
0090 0AF3              *
0091 0AF3              * 7-Mar-91          Dave Lyons
0092 0AF3              *
0093 0AF3              * Make AlertWindow beep when you click outside the window.
0094 0AF3              *
0095 0AF3              * 9-Mar-91          Dave Lyons
0096 0AF3              *
0097 0AF3              * Made ErrorWindow call SysBeep2($CExx) for error numbers $00xx.
0098 0AF3              * Adding alertSoundBit ($0010) to AlertWindow; calls SysBeep2
0099 0AF3              * $C05x, except for icon #1 (custom) and #5 (Disk).
0100 0AF3              *
0101 0AF3              * Stop and Note (icons #2 and #4) use sound even if you don't set
0102 0AF3              * the bit asking it to.
0103 0AF3              *
0104 0AF3              * 11-Mar-91         Dave Lyons
0105 0AF3              *
0106 0AF3              * AlertWindow has key equivalents now.  Default button gets Return,
0107 0AF3              * "Cancel" button gets ESC, Apple-period equals ESC, and all other
0108 0AF3              * buttons get the upper- and lower-case versions of their title's
0109 0AF3              * first letter.  There is no checking for conflicts yet.
0110 0AF3              *
0111 0AF3              * 12-Mar-91         Dave Lyons
0112 0AF3              *
0113 0AF3              * AlertWindow disk-swap icon gives SysBeep2($C030) instead of $C056
0114 0AF3              * now, if the alertSound bit is on.
0115 0AF3              *
0116 0AF3              * 13-Mar-91         Dave Lyons
0117 0AF3              *
0118 0AF3              * Made ErrorWindow with an error >$FF call SysBeep2($CEFF).
0119 0AF3              * Implemented AlertWindow flag bit $0020, alertSpacingBit.  If you
0120 0AF3              * set this, your up-to-three buttons get allocated from right to
0121 0AF3              * left, in lower-right, left-of-lower-right, and way-left order.
0122 0AF3              *
0123 0AF3              * If any button has the same first letter as another button, it
0124 0AF3              * doesn't get a key equivalent.  (Unless it's default or Cancel,
0125 0AF3              * in which case it gets Return or Apple-period/Esc as usual.)
0126 0AF3              *
0127 0AF3              * AlertWindow with the disk-swap icon always calls SysBeep2($C030).
0128 0AF3              *
0129 0AF3              * 15-Mar-91         Dave Lyons
0130 0AF3              *
0131 0AF3              * For a *default* Cancel button, Return and Esc and Apple-period
0132 0AF3              * all work for the key equivalent.
0133 0AF3              *
0134 0AF3              * 26-Mar-91         Dave Lyons
0135 0AF3              *
0136 0AF3              * AlertWindow flag bit 7 ($0080) makes it call ReleaseResource(3)
0137 0AF3              * instead of ReleaseResource(-1), so if you locked your resource
0138 0AF3              * it will stay in memory.
0139 0AF3              *
0140 0AF3              * Leading blanks are now tolerated when computing AlertWindow key
0141 0AF3              * equivalents.
0142 0AF3              *
0143 0AF3              * 27-Mar-91         Dave Lyons
0144 0AF3              *
0145 0AF3              * AlertWindow window positions are now forced to be at even X
0146 0AF3              * positions (so that icon dithering comes out right in 640 mode).
0147 0AF3              *
0148 0AF3              * 1-Apr-91          Dave Lyons
0149 0AF3              *
0150 0AF3              * AlertWindow masks off System Window bit from TaskMaster so that
0151 0AF3              * clicking in a System window beeps.  Also getting a wInDrag beeps
0152 0AF3              * (this can happen if you used WindowGlobal to leave a window
0153 0AF3              * hilited!).
0154 0AF3              *
0155 0AF3              * 2-Apr-91          Dave Lyons
0156 0AF3              *
0157 0AF3              * Oops, PollForInsertions wasn't conditioning the carry flag after
0158 0AF3              * calling ScanDevices.
0159 0AF3              *
0160 0AF3              * 7-Apr-91          Dave Lyons
0161 0AF3              *
0162 0AF3              * AlertWindow bit $0100 forces a disk-insert scan even if there's no
0163 0AF3              * disk-swap icon.
0164 0AF3              *
0165 0AF3              * 8-Apr-91          Dave Lyons
0166 0AF3              *
0167 0AF3              * Dang, the 7-Apr addition made it usually display no icon.  Fixed.
0168 0AF3              *
0169 0AF3              * 12..13-Apr-91     Dave Lyons
0170 0AF3              *
0171 0AF3              * Adding new call HandleDiskInsert.
0172 0AF3              *
0173 0AF3              * 14-Apr-91         Dave Lyons
0174 0AF3              *
0175 0AF3              * Tweaks to HandleDiskInsert (cursor handling).
0176 0AF3              *
0177 0AF3              * 18-Apr-91         Dave Lyons
0178 0AF3              *
0179 0AF3              * Made DoModalWindow zero out the MWGetCtlPart value so that we return
0180 0AF3              * part code zero if no TrackControl was performed (for example, when
0181 0AF3              * a keypress activates a control with a key equivalent).
0182 0AF3              *
0183 0AF3              * After attempting to eject a disk, I now record its *current* status
0184 0AF3              * rather than always recording it offline if the DControl Eject gave
0185 0AF3              * me no error.
0186 0AF3              *
0187 0AF3              * 21-Apr-91         Dave Lyons
0188 0AF3              *
0189 0AF3              * More work on the HandleDiskInsert rename dialog.
0190 0AF3              *
0191 0AF3              * Make DoModalWindow update the thing before allowing SysBeep2
0192 0AF3              * to trigger.
0193 0AF3              *
0194 0AF3              * 23-Apr-91         Dave Lyons
0195 0AF3              *
0196 0AF3              * Add flag bit to HandleDiskInsert to simulate a duplicate-disk
0197 0AF3              * error, for use by the Finder.
0198 0AF3              *
0199 0AF3              * Fix the above DoModalWindow fix to not be bothered by another
0200 0AF3              * window's deactivate event.
0201 0AF3              *
0202 0AF3              * 30-Apr-91         Dave Lyons
0203 0AF3              *
0204 0AF3              * When DoModalWindow calls MWSetMenuProc to get the menu proc, it was
0205 0AF3              * passing NIL; now it passes $FFFFFFFF.
0206 0AF3              *
0207 0AF3              * 8-May-91          Dave Lyons
0208 0AF3              *
0209 0AF3              * Fixed major AlertWindow problem where having the separator character
0210 0AF3              * in a substitution string would fry.  Now I compile the text once,
0211 0AF3              * search for a character that does not appear anywhere, and use that
0212 0AF3              * for the separator character.
0213 0AF3              *
0214 0AF3              * 9-May-91          Dave Lyons
0215 0AF3              *
0216 0AF3              * Increased HandleDiskInsert Volume pCount to 8 so Volume will return
0217 0AF3              * fileSysID/etc even if a dup-vol error comes back.  So now the right
0218 0AF3              * number of characters are allowed in the rename-disk edit line.
0219 0AF3              *
0220 0AF3              * 20-May-91         Dave Lyons
0221 0AF3              *
0222 0AF3              * DoModalWindow--new flag bit mwWantActivate must be set for DoModalWindow
0223 0AF3              * to return activate/deactivate events.  Otherwise it just eats them for
0224 0AF3              * speed.  On activate/deactivate, no longer redraws $87FFxxxx controls.
0225 0AF3              *
0226 0AF3              * In HandleDiskInsert SetDevStatus, we don't do anything unless
0227 0AF3              * fDoDeviceScan or fUpdateDevStatus is set in the flags.
0228 0AF3              *
0229 0AF3              * HandleDiskInsert RenameVolume gives the user another chance to rename
0230 0AF3              * the thing if an error occurs.
0231 0AF3              *
0232 0AF3              * 21-May-91         Dave Lyons
0233 0AF3              *
0234 0AF3              * HandleDiskInsert:  Dim the Rename button when there's no new name
0235 0AF3              * entered.
0236 0AF3              *
0237 0AF3              * 10-Jun-91         Dave Lyons
0238 0AF3              *
0239 0AF3              * HandleDiskInsert now calls InitCursor when you hit the Rename
0240 0AF3              * button.
0241 0AF3              *
0242 0AF3              * FindCursorCtl now ignores invisible controls.
0243 0AF3              *
0244 0AF3              * 27-Jun-91         Dave Lyons
0245 0AF3              *
0246 0AF3              * Fixed AlertWindow to beep if you click in a window's info bar,
0247 0AF3              * grow box, zoom box, or close box.
0248 0AF3              *
0249 0AF3              * 8-Jul-91          Dave Lyons
0250 0AF3              *
0251 0AF3              * HandleDiskInsert calls SysBeep2($4033 = sbBadDisk + sbDefer) when
0252 0AF3              * it detects an I/O error or an unrecognized file system.
0253 0AF3              *
0254 0AF3              * 5-Aug-91          Dave Lyons
0255 0AF3              *
0256 0AF3              * AlertWindow bit $0200 means there is are four bytes of custom icon
0257 0AF3              * data, which are an rIcon resource ID.  The icon must be available
0258 0AF3              * in memory, or online--it must not cause another AlertWindow to pop
0259 0AF3              * up because the OS wants a disk!
0260 0AF3              *
0261 0AF3              * 16-Sep-91         Dave Lyons
0262 0AF3              *
0263 0AF3              * AlertWindow disk-swap icon no longer calls LoadResource at AlertWindow
0264 0AF3              * time; instead, we load it at WindStartUp.  This way we do not try a
0265 0AF3              * reentrant call to LoadResource if LoadResource causes the OS to prompt
0266 0AF3              * for a disk!
0267 0AF3              *
0268 0AF3              * Added missing LDX #$FFFF on releasing rAlertString resource if bit
0269 0AF3              * $0080 is clear.  Was not releasing resources reliably.
0270 0AF3              *
0271 0AF3              * 4-Oct-91          Dave Lyons
0272 0AF3              *
0273 0AF3              * HandleDiskInsert--tabbing to a new control returns the handle and id
0274 0AF3              * of the new control, not the old one.
0275 0AF3              *
0276 0AF3              * AlertWindow--sets Font Flags to $0004 so you can have 16-color text
0277 0AF3              * in 640-mode if you want.
0278 0AF3              *
0279 0AF3              * 10-Oct-91         Dave Lyons
0280 0AF3              *
0281 0AF3              * HandleDiskInsert special-cases error $0021 (bad control code) from
0282 0AF3              * a Format to a 3.5 drive, to put up the special ErrorWindow(99)
0283 0AF3              * explaining that the user tried to format 800K as 1400K or vice versa.
0284 0AF3              *
0285 0AF3              * HandleDiskInsert ignores Apple tape drives unless fCheckTapeDrives
0286 0AF3              * is set (flags $0200).
0287 0AF3              *
0288 0AF3              * ErrorWindow always uses cool button positions.
0289 0AF3              *
0290 0AF3              * 24-Oct-91         Dave Lyons
0291 0AF3              *
0292 0AF3              * HandleDiskInsert has logic to check for never-writeable devices
0293 0AF3              * and read-only file systems, when handling a duplicate-name volume.
0294 0AF3              * There are two new dialogs (rAlertString $07FF0E01 and $07FF0E02 in
0295 0AF3              * Sys.Resources) for these cases.
0296 0AF3              *
0297 0AF3              * 27-Oct-91         Dave Lyons
0298 0AF3              *
0299 0AF3              * HandleDiskInsert special-cases AppleShare (can never rename an
0300 0AF3              * AppleShare volume).
0301 0AF3              *
0302 0AF3              * DoModalWindow invalidates static text control on activates *if*
0303 0AF3              * the control's fTextCanDim bit is set.
0304 0AF3              *
0305 0AF3              * 30-Oct-91         Dave Lyons
0306 0AF3              *
0307 0AF3              * The can't-rename dialogs now force an arrow cursor (was already
0308 0AF3              * being restored).
0309 0AF3              *
0310 0AF3              * AlertWindow calls WindowGlobal($FFFE) right after creating the
0311 0AF3              * window, instead of when the window gets closed.  This way we don't
0312 0AF3              * lose the activate event for window behind the alert.
0313 0AF3              *
0314 0AF3              * 5-Nov-91          Dave Lyons
0315 0AF3              *
0316 0AF3              * AlertWindow now unlocks the rAlertString resource handle before
0317 0AF3              * releasing it (for dispose, doesn't matter; for the alertNoDispose
0318 0AF3              * bit, this leaves the handle unlocked!).
0319 0AF3              *
0320 0AF3              * AlertWindow disables key translation during the call, unless there
0321 0AF3              * are buttons with high-ASCII equivalents.
0322 0AF3              *
0323 0AF3              * 13-Nov-91         Dave Lyons
0324 0AF3              *
0325 0AF3              * FindCursorCtl--removed special casing for TE controls.
0326 0AF3              *
0327 0AF3              * 14-Nov-91         Dave Lyons
0328 0AF3              *
0329 0AF3              * HandleDiskInsert--for error $5A, put up a disk-damaged dialog and
0330 0AF3              * let them eject/initialize (was ignoring error $5A).
0331 0AF3              *
0332 0AF3              * 21-Nov-91         Dave Lyons
0333 0AF3              *
0334 0AF3              * HandleDiskInsert polling was doing DInfo pcount=8, which caused
0335 0AF3              * device access.  Now uses pcount=3 (like it did a couple months
0336 0AF3              * ago) when just checking status.
0337 0AF3              *
0338 0AF3              * 320-mode rename dialog now works (has separate window/ctl templates).
0339 0AF3              *
0340 0AF3              * 22-Nov-91         Dave Lyons
0341 0AF3              *
0342 0AF3              * HandleDiskInsert rename dialog must draw icon manually instead of
0343 0AF3              * using an icon button control, since the defproc cannot be guaranteed
0344 0AF3              * to be loaded.
0345 0AF3              *
0346 0AF3              * HandlediskInsert rename AlertWindow calls now set the fAlertNoDispose
0347 0AF3              * bit.
0348 0AF3              *
0349 0AF3              * AlertWindow no longer unlocks rAlertString resources that are marked
0350 0AF3              * locked in their resource attributes.
0351 0AF3              *
0352 0AF3              * 2-Dec-91          Dave Lyons
0353 0AF3              *
0354 0AF3              * HandleDiskInsert calls GetFileInfo after a successful Volume call,
0355 0AF3              * because the HFS FST can detect a damaged disk during GetFileInfo.
0356 0AF3              *
0357 0AF3              * 3-Dec-91          Dave Lyons
0358 0AF3              *
0359 0AF3              * AlertWindow is using a lot of stack space, largely thanks to TaskMaster
0360 0AF3              * and DrawControls.  When GS/OS calls us, the stack is near $BFFF; there
0361 0AF3              * are 2 pages or less of stack available, so we're hosing GS/OS direct page
0362 0AF3              * when it overruns.
0363 0AF3              *
0364 0AF3              * The fix:  after our direct page stuff set up, we switch to a new 6-page
0365 0AF3              * stack segment (size = ExtraStackSize).  If we can't allocate a separate
0366 0AF3              * stack, we don't call ScanDevices.
0367 0AF3              *
0368 0AF3              * On closing alert, AlertWindow now flushes keyDown events only if it
0369 0AF3              * was scanning for disk insertions.
0370 0AF3              *
0371 0AF3              * 5-Dec-91          Dave Lyons
0372 0AF3              *
0373 0AF3              * When HandleDiskInsert renames a disk, it sets the TrustMe bit in the
0374 0AF3              * new 3rd parameter, so that the OS does not do RenamePathname, rename
0375 0AF3              * VCRs/FCRs, or change its record of the boot volume name.
0376 0AF3              *
0377 0AF3              * 6-Dec-91          Dave Lyons
0378 0AF3              *
0379 0AF3              * AlertWindow now uses correct key equivalents for Cancel button even
0380 0AF3              * when it is padded with leading blanks, or when Cancel is capitalized
0381 0AF3              * in a nonstandard way.
0382 0AF3              *
0383 0AF3              * 9-Dec-91          Dave Lyons
0384 0AF3              *
0385 0AF3              * HandleDiskInsert:  Add new flag bit, hdiUnreadable ($0100), that
0386 0AF3              * makes me skip the Volume call and assume the device is unreadable
0387 0AF3              * (that Volume would return error $27).
0388 0AF3              *
0389 0AF3              * 10-Dec-91         Dave Lyons
0390 0AF3              *
0391 0AF3              * HandleDiskInsert NewWindow2 for the rename-this-disk window is
0392 0AF3              * now by Pointer instead of Resource, so that NewWindow2 does not
0393 0AF3              * detach my handy pre-loaded resource!
0394 0AF3              *
0395 0AF3              * After HandleDiskInsert calls ErrorWindow, it calls LoadResource
0396 0AF3              * to re-lock the rErrorString $07FF0096 and -7 handles, so they
0397 0AF3              * can't get purged.
0398 0AF3              *
0399 0AF3              * 17-Dec-91         Dave Lyons
0400 0AF3              *
0401 0AF3              * AlertWindow now sets system preferences to prompt for disk,
0402 0AF3              * no Cancel button.  (Caller is typically not checking for an
0403 0AF3              * error, and it's dangerous to let them act on the result-space
0404 0AF3              * garbage as a user choice.)
0405 0AF3              *
0406 0AF3              * Added alertFullColorBit ($0400); AlertWindow only does the
0407 0AF3              * SetFontFlags(4) if this bit is set, for compatibility.
0408 0AF3              *
0409 0AF3              * 8-Jan-92          Dave Lyons
0410 0AF3              *
0411 0AF3              * HandleDiskInsert now does a SendRequest(systemSaysEjecting) when
0412 0AF3              * it ejects a disk.  This way EasyMount can avoid doing a bogus open
0413 0AF3              * on a duplicate volume that was mounted and then ejected.
0414 0AF3              *
0415 0AF3              * 16-Jan-92         Dave Lyons
0416 0AF3              *
0417 0AF3              * Optimizations in AlertWindow:  Killed 10 bytes of dead storage,
0418 0AF3              * and a dozen or two bytes of redundant code (noted by Yvan Koenig).
0419 0AF3              * Made the AlertWindow "Cancel" check more easily localizable (cost
0420 0AF3              * ten bytes).
0421 0AF3              *
0422 0AF3              * 17-Jan-92         Dave Lyons
0423 0AF3              *
0424 0AF3              * Make AlertWindow SetKeyTranslation calls *not* affect Battery RAM
0425 0AF3              * (key translation was getting permanently turned off if you rebooted
0426 0AF3              * during an AlertWindow, like the "Restart" dialog).
0427 0AF3              *
0428 0AF3              * 31-Jan-92         Dave Lyons
0429 0AF3              *
0430 0AF3              * HandleDiskInsert never handles an Apple Tape Drive (it just returns
0431 0AF3              * no error, without making a Volume call).
0432 0AF3              *
0433 0AF3              * HandleDiskInsert now treats a still-online disk as an insert if
0434 0AF3              * there is a disk-switched condition returned from DStatus.
0435 0AF3              *
0436 0AF3              **********************************************************************
0437 0AF3              *
0438 0AF3              * BEGIN 6.0.1
0439 0AF3              *
0440 0AF3              * 6-Mar-92          Dave Lyons
0441 0AF3              *
0442 0AF3              * Added new UpdateWindow call.
0443 0AF3              *
0444 0AF3              * 19-Jun-92         Dave Lyons
0445 0AF3              *
0446 0AF3              * Added flags word parameter to UpdateWindow.  DoModalWindow and
0447 0AF3              * AlertWindow updated to pass flags.  DoModalWindow sets bit 31 of
0448 0AF3              * the default wContDraw.
0449 0AF3              *
0450 0AF3              * AlertWindow now uses UpdateWindow to update other people'sl windows,
0451 0AF3              * if those windows are smart enough (wContDraw bit 31 set).
0452 0AF3              *
0453 0AF3              * 10-Jul-92         Dave Lyons
0454 0AF3              *
0455 0AF3              * Bits 31-24 of the updateProc to HandleDiskInsert are now honored
0456 0AF3              * even if the rest of the pointer is NIL.  This way you can flag your
0457 0AF3              * window as not needing GS/OS for its update. -- Also, we never
0458 0AF3              * replace a window's existing wContDraw procedure, if it has one
0459 0AF3              * (we give it a wContDraw on the first call if it doesn't have one).
0460 0AF3              *
0461 0AF3              * 28-Oct-92         Dave Lyons
0462 0AF3              *
0463 0AF3              * HandleDiskInsert now treats error $51 (directory damaged) like error
0464 0AF3              * $5A (damaged bitmap).  Puts up "This disk is damaged and can't be
0465 0AF3              * used.  Eject/Initialize".
0466 0AF3              *
0467 0AF3              * 30-Nov-92         Dave Lyons
0468 0AF3              *
0469 0AF3              * Added "jsr setValues" after LECut, LEPaste, TECut, TEPaste, so that
0470 0AF3              * DoModalWindow returns the control IDs when the user changes the
0471 0AF3              * an editable control's contents by cutting or pasting.
0472 0AF3              *
0473 0AF3              * 19-Feb-93         Dave Lyons
0474 0AF3              *
0475 0AF3              * Changed the HandleDiskInsert duplicate-disk dialog to use a Note
0476 0AF3              * icon instead of a 3.5" disk icon (since it happens for many kinds
0477 0AF3              * of disks that look nothing like the icon).
0478 0AF3              *
0479 0AF3              * 21-Mar-93         Dave Lyons
0480 0AF3              *
0481 0AF3              * DoModalWindow handles an Update event with mwUpdateAll clear by
0482 0AF3              * calling UpdateWindow with flags of $0000 for the dialog window,
0483 0AF3              * but $8000 for other windows--so the other windows update only if
0484 0AF3              * it's safe for them to background-update.  If the mwUpdateAll bit
0485 0AF3              * is set, it always passes flags of $0000.
0486 0AF3              *
0487 0AF3              * Cleaned out a bunch of crusty comments & dead code from AlertWindow.
0488 0AF3              *
0489 0AF3              * 23-Mar-93         Dave Lyons
0490 0AF3              *
0491 0AF3              * Changed UpdateWindow to return an error for a background update
0492 0AF3              * of a System window, since System windows should alwyas get updated
0493 0AF3              * from inside SystemEvent.  (Some people, like ModalDialog, are calling
0494 0AF3              * GetNextEvent and ingoring the return flag that says "you should not
0495 0AF3              * handle this, it's already taken care of by SystemEvent".)
0496 0AF3              *
0497 0AF3              * Changed DoModalWindow so it doesn't invalidate controls on an
0498 0AF3              * activate if the window's fCtlTie bit is set, saying that the control
0499 0AF3              * states are independent of the window state.
0500 0AF3              *
0501 0AF3              * 5-Apr-93          Dave Lyons (for 6.0.1d17)
0502 0AF3              *
0503 0AF3              * On a DoModalWindow background update, zero out code so we will blink
0504 0AF3              * insertion points even if we never handling pending updates behind our
0505 0AF3              * dialog.
0506 0AF3              *
0507 0AF3              **********************************************************************
0508 0AF3                       Blanks off 
0509 0AF3                       String asis 
0510 0AF3
0511 0AF3                       print push 
0512 0AF3                       print off 
0513 0AF3                       INCLUDE 'ALL.MACROS' 
0514 0AF3                       INCLUDE 'e16.control' 
0515 0AF3                       include 'e16.event'            ;22-Jan-91 DAL
0516 0AF3                       include 'e16.lineedit'         ;22-Jan-91 DAL
0517 0AF3                       include 'e16.locator'          ;8-Jan-92 DAL
0518 0AF3                       include 'WindMgrEquates.asm' 
0519 0AF3
0520 0AF3                       print pop 
0521 0AF3
0522 0AF3              ;===========================================
0523 0AF3              ;          Create an Alert Window.
0524 0AF3              ;===========================================
0525 0AF3              ;
0526 0AF3              ;   IN:    PUSH:WORD - space for result, button number selected.
0527 0AF3              ;          PUSH:WORD - bit 0 = 0 if substitution strings are C type (null or return).
0528 0AF3              ;                      bit 0 = 1 if substitution strings are Pascal type (length byte).
0529 0AF3              ;                      bit 1&2 = 00 if alert string passed is a pointer.
0530 0AF3              ;                      bit 1&2 = 01 if alert string passed is a handle.
0531 0AF3              ;                      bit 1&2 = 11 if alert string passed is a resource ID.
0532 0AF3              ;                      bit 3 = don't adjust text rectangle for icon
0533 0AF3              ;                      bit 4 = do a SysBeep2 call
0534 0AF3              ;                      bit 5 = space buttons unevenly
0535 0AF3              ;                      bit 6 = skip initial disk-insert scan
0536 0AF3              ;                      bit 7 = don't dipose of resource (make it purgeable instead)
0537 0AF3              ;                      bit 8 = scan for disk insertions even without disk-swap icon
0538 0AF3              ;                      bit 9 = custom icon is resource
0539 0AF3              ;                      bit 10 = full color--set FontFlags to $0004
0540 0AF3              ;          PUSH:LONG - pointer to substitution strings.
0541 0AF3              ;          PUSH:LONG - pointer to alert string.
0542 0AF3              ;
0543 0AF3              ;  OUT:    WORD - button number selected.
0544 0AF3              ;
0545 0AF3              ;===========================================
0546 0AF3                       EXPORT AlertWindow 
0547 0AF3              AlertWindow PROC 
0548 0AF3
0549 0AF3                       import FlushKeyEvents,WindowUpdateCount 
0550 0AF3
0551 0AF3              ExtraStackSize equ   $0600              ;added 3-Dec-91 DAL
0552 0AF3
0553 0AF3              alertResourceID equ   1                 ;ID of loaded alert string resource, NIL if none.
0554 0AF3              alertStrgHand equ   alertResourceID+4
0555 0AF3              windRect equ   alertStrgHand+4          ;RECT of window's content.
0556 0AF3              xxLocInfo equ   windRect+8              ;SCB.
0557 0AF3              xxImage  equ   xxLocInfo+2              ;Pointer to pixel image.
0558 0AF3              xxWidth  equ   xxImage+4                ;Width of image.
0559 0AF3              xxBounds equ   xxWidth+2                ;Bounds RECT of image.
0560 0AF3              terminate equ   xxBounds+8
0561 0AF3              separator equ   terminate+2
0562 0AF3              butt1    equ   separator+2
0563 0AF3              butt2    equ   butt1+4
0564 0AF3              butt3    equ   butt2+4
0565 0AF3              handle   equ   butt3+4
0566 0AF3              ptr      equ   handle+4
0567 0AF3              ptr2     equ   ptr+4
0568 0AF3              taskRec  equ   ptr2+4                   ;Task record overlaps work.
0569 0AF3              TheWork  equ   taskRec+exTaskRecSize
0570 0AF3              DoingButtons equ   TheWork+8            ;added 25-Nov-90 DAL
0571 0AF3              diskInsertFlag equ   DoingButtons+2     ;added 7-Mar-91 DAL
0572 0AF3              theNewSeparator equ   diskInsertFlag+2  ;added 8-May-91 DAL
0573 0AF3              oldKeyTranslation equ   theNewSeparator+2  ;added 5-Nov-91 DAL
0574 0AF3              oldStack equ   oldKeyTranslation+2      ;added 3-Dec-91 DAL
0575 0AF3              oldSysPrefs equ   oldStack+2            ;added 17-Dec-91 DAL
0576 0AF3              realDrawIconFlag equ   oldSysPrefs+2
0577 0AF3              alertWind equ   realDrawIconFlag+2
0578 0AF3              saveDpage equ   alertWind+4
0579 0AF3              saveDbank equ   saveDpage+2
0580 0AF3              returnAddr equ   saveDbank+1
0581 0AF3              alertStrg equ   returnAddr+6
0582 0AF3              substrgs equ   alertStrg+4
0583 0AF3              strgType equ   substrgs+4
0584 0AF3              result   equ   strgType+2
0585 0AF3
0586 0AF3              strgTypeBit equ   1
0587 0AF3              alertStrgBit equ   6                    ;bits 1-2
0588 0AF3              alertStrgPtr equ   0                    ;value for bits 1-2
0589 0AF3              alertStrgHandle equ   2                 ;value for bits 1-2
0590 0AF3              alertStrgResource equ   4               ;value for bits 1-2
0591 0AF3              alertRectBit equ   $08                  ;14-Nov-90 DAL: bit 3 = don't subtract icon width from rect
0592 0AF3              alertSoundBit equ   $10                 ;9-Mar-91 DAL: bit 4 = call SysBeep2
0593 0AF3              alertSpacingBit equ   $20               ;13-Mar-91 DAL: bit 5 = space buttons unevenly
0594 0AF3              alertSkipScanBit equ   $40              ;15-Mar-91 DAL: bit 6 = skip initial disk scan
0595 0AF3              alertNoDisposeBit equ   $80             ;26-Mar-91 DAL: bit 7 = don't dispose resource
0596 0AF3              alertDiskScanBit equ   $100             ;7-Apr-91 DAL: bit 8 = default button on disk insert
0597 0AF3              alertIconRsrcBit equ   $200             ;5-Aug-91 DAL: bit 9 = icon is resource, not pointer
0598 0AF3              alertFullColorBit equ   $400            ;17-Dec-91 DAL: bit 10 = set font flags to $0004
0599 0AF3
0600 0AF3              rAlertString equ   $8015
0601 0AF3
0602 0AF3              *** If ROM 3 AlertWindow is calling us, force $0020 flag on (button pos)
0603 0AF3 A3 05                 lda   5,s
0604 0AF5 C9 38 FD              cmp   #$fd38
0605 0AF8 D0 0E                 bne   @notErrorWindow
0606 0AFA A3 04                 lda   4,s
0607 0AFC C9 FE 38              cmp   #$38fe
0608 0AFF D0 07                 bne   @notErrorWindow
0609 0B01 A3 0F                 lda   15,s
0610 0B03 09 20 00              ora   #$0020
0611 0B06 83 0F                 sta   15,s
0612 0B08              @notErrorWindow  
0613 0B08
0614 0B08 22 64 00 E1           jsl   IncBusyFlg
0615 0B0C 8B                    phb                            ;Save caller's data bank pointer
0616 0B0D 0B                    phd                            ;Save caller's direct page pointer
0617 0B0E
0618 0B0E 3B                    tsc                            ;Swtich to direct page in stack
0619 0B0F 38                    sec   
0620 0B10 E9 84 00              sbc   #saveDpage-1
0621 0B13 1B                    tcs   
0622 0B14 5B                    tcd   
0623 0B15
0624 0B15 4B                    phk                            ;Switch data bank to program bank
0625 0B16 AB                    plb   
0626 0B17
0627 0B17              *** Switch to a new, safe stack segment
0628 0B17 A2 00 00              ldx   #0
0629 0B1A DA                    phx   
0630 0B1B DA                    phx                            ;space for new handle
0631 0B1C DA                    phx                            ;size, high word
0632 0B1D F4 00 06              pea   ExtraStackSize           ;size of new stack
0633 0B20 F4 0E 40              pea   $400E                    ;id for new stack handle
0634 0B23 F4 15 C0              pea   $C015                    ;fixed-bank, etc
0635 0B26 DA                    phx   
0636 0B27 DA                    phx   
0637 0B28 A2 02 09 22           _NewHandle 
0638 0B2F 0B                    phd   
0639 0B30 3B                    tsc   
0640 0B31 5B                    tcd   
0641 0B32 A7 03                 lda   [3]
0642 0B34 08                    php   
0643 0B35 69 FF 05              adc   #ExtraStackSize-1        ;carry was clear if we will use this
0644 0B38 28                    plp   
0645 0B39 2B                    pld   
0646 0B3A 7A                    ply   
0647 0B3B 7A                    ply   
0648 0B3C BA                    tsx                            ;stack to restore to
0649 0B3D 90 04                 bcc   @gotSpecial
0650 0B3F 3B                    tsc                            ;don't change stack
0651 0B40 A2 00 00              ldx   #0                       ;don't restore when done
0652 0B43 1B           @gotSpecial tcs   
0653 0B44 86 7B                 stx   <oldStack
0654 0B46
0655 0B46              ;
0656 0B46              ; Preserve key translation
0657 0B46              ;
0658 0B46 48                    pha   
0659 0B47 A2 06 1B 22           _GetKeyTranslation 
0660 0B4E 68                    pla   
0661 0B4F 85 79                 sta   <oldKeyTranslation
0662 0B51
0663 0B51              *** Set system prefs to prompt for disk, no Cancel
0664 0B51 48                    pha                            ;space for old sys prefs word
0665 0B52 F4 01 00              pea   1                        ;pcount
0666 0B55 3B                    tsc   
0667 0B56 1A                    inc   a
0668 0B57 F4 00 00              pea   0
0669 0B5A 48                    pha   
0670 0B5B F4 0F 20              pea   $200F                    ;GetSysPrefsGS
0671 0B5E 22 B0 00 E1           jsl   $e100b0
0672 0B62 68                    pla   
0673 0B63 68                    pla   
0674 0B64 85 7D                 sta   <oldSysPrefs
0675 0B66
0676 0B66 29 FF 1F              and   #$1fff
0677 0B69 09 00 C0              ora   #$c000                   ;prompt for disk, no Cancel
0678 0B6C 48                    pha                            ;new sys prefs word
0679 0B6D F4 01 00              pea   1                        ;pcount
0680 0B70 3B                    tsc   
0681 0B71 1A                    inc   a
0682 0B72 F4 00 00              pea   0
0683 0B75 48                    pha   
0684 0B76 F4 0C 20              pea   $200C                    ;SetSysPrefsGS
0685 0B79 22 B0 00 E1           jsl   $e100b0
0686 0B7D 68                    pla   
0687 0B7E 68                    pla   
0688 0B7F              ;
0689 0B7F              ; --- Load alert string if resource.
0690 0B7F              ;
0691 0B7F 64 01                 stz   <alertResourceID         ;Start with no resource
0692 0B81 64 03                 stz   <alertResourceID+2
0693 0B83
0694 0B83 A5 96                 lda   <strgType                ;Was a resource ID passed?
0695 0B85 29 06 00              and   #alertStrgBit
0696 0B88 F0 3E                 beq   @skip1
0697 0B8A 48                    pha   
0698 0B8B A4 8E                 ldy   <alertStrg               ;Save resource ID
0699 0B8D A6 90                 ldx   <alertStrg+2
0700 0B8F 84 01                 sty   <alertResourceID
0701 0B91 86 03                 stx   <alertResourceID+2
0702 0B93 68                    pla   
0703 0B94 C9 02 00              cmp   #alertStrgHandle
0704 0B97 F0 1A                 beq   @alertHandle
0705 0B99
0706 0B99 48                    pha                            ;Space for result
0707 0B9A 48                    pha   
0708 0B9B F4 15 80              pea   rAlertString             ;Pass resource type of alert string
0709 0B9E DA                    phx                            ;Pass resource ID of alert string
0710 0B9F 5A                    phy   
0711 0BA0 A2 1E 0E 22           _LoadResource 
0712 0BA7 FA                    plx   
0713 0BA8 86 8E                 stx   <alertStrg
0714 0BAA FA                    plx   
0715 0BAB 86 90                 stx   <alertStrg+2
0716 0BAD 90 04                 bcc   @alertHandle
0717 0BAF A8                    tay                            ;Return error code
0718 0BB0 82 04 02              brl   errorExit
0719 0BB3
0720 0BB3 A0 04 00     @alertHandle ldy   #4                   ;Lock alert string
0721 0BB6 B7 8E                 lda   [<alertStrg],y
0722 0BB8 09 00 80              ora   #$8000
0723 0BBB 97 8E                 sta   [<alertStrg],y
0724 0BBD 88                    dey                            ;Dereference the string
0725 0BBE 88                    dey   
0726 0BBF B7 8E                 lda   [<alertStrg],y
0727 0BC1 A8                    tay   
0728 0BC2 A7 8E                 lda   [<alertStrg]
0729 0BC4 85 8E                 sta   <alertStrg
0730 0BC6 84 90                 sty   <alertStrg+2
0731 0BC8              @skip1    
0732 0BC8              ;
0733 0BC8              ; --- Save caller's port -------------------------------------
0734 0BC8              ;
0735 0BC8 48                    pha                            ;Space for result.
0736 0BC9 48                    pha   
0737 0BCA A2 04 1C 22           _GetPort                       ;Leave port on stack.
0738 0BD1
0739 0BD1 48                    pha                            ;Space for result.
0740 0BD2 A2 04 17 22           _GetMasterSCB 
0741 0BD9 68                    pla   
0742 0BDA 85 11                 sta   <xxLocInfo               ;Store current video mode.
0743 0BDC              ;
0744 0BDC              ; --- Turn window highlighting off ---------------------------
0745 0BDC              ;
0746 0BDC A9 01 00              lda   #1                       ;Turn window hiliting off for now.
0747 0BDF 20 72 11              jsr   windowGlobal
0748 0BE2              ;
0749 0BE2              ; --- Allocate a new window parameter table ------------------
0750 0BE2              ;
0751 0BE2 48                    pha                            ;Space for result.
0752 0BE3 48                    pha   
0753 0BE4 F4 00 00              pea   0                        ;Pass number of bytes to allocate.
0754 0BE7 F4 4E 00              pea   p_size
0755 0BEA F4 0E 40              pea   $400e
0756 0BED F4 10 C0              pea   $C010                    ;Pass attributes, fixed, in bank.
0757 0BF0 48                    pha                            ;Pass address (not used).
0758 0BF1 48                    pha   
0759 0BF2 A2 02 09 22           _NewHandle 
0760 0BF9 68                    pla   
0761 0BFA 85 31                 sta   <handle
0762 0BFC 68                    pla   
0763 0BFD 85 33                 sta   <handle+2
0764 0BFF
0765 0BFF 20 8B 17              jsr   derefHand                ;<ptr = (handle)
0766 0C02              ;
0767 0C02              ; ------ Initialize table ------------------------------------
0768 0C02              ;
0769 0C02 A0 4C 00              ldy   #p_size-2                ;Zero the table.
0770 0C05 A9 00 00              lda   #0
0771 0C08 97 35        lop3     sta   [<ptr],y
0772 0C0A 88                    dey   
0773 0C0B 88                    dey   
0774 0C0C 10 FA                 bpl   lop3
0775 0C0E
0776 0C0E A9 4E 00              lda   #p_size                  ;Set p_length field.
0777 0C11 87 35                 sta   [<ptr]
0778 0C13
0779 0C13 A0 02 00              ldy   #p_wFrame
0780 0C16 A9 29 20              lda   #%0010000000101001
0781 0C19 97 35                 sta   [<ptr],y
0782 0C1B
0783 0C1B A0 3A 00              ldy   #p_updateDraw
0784 0C1E A9 C3 18              lda   #UpdateGuts
0785 0C21 97 35                 sta   [<ptr],y
0786 0C23 C8                    iny   
0787 0C24 C8                    iny   
0788 0C25 A9 02 00              lda   #UpdateGuts>>16
0789 0C28 09 00 C0              ora   #$C000                   ;background + no GS/OS
0790 0C2B 97 35                 sta   [<ptr],y
0791 0C2D
0792 0C2D A0 46 00              ldy   #p_behind
0793 0C30 A9 FF FF              lda   #$FFFF
0794 0C33 97 35                 sta   [<ptr],y
0795 0C35 C8                    iny   
0796 0C36 C8                    iny   
0797 0C37 97 35                 sta   [<ptr],y
0798 0C39              ;
0799 0C39              ; --- Get alert window's size and position -------------------
0800 0C39              ;
0801 0C39 20 5E 11              jsr   fetchDigit               ;a = number.
0802 0C3C 3A                    dec   a
0803 0C3D 10 16                 bpl   ok1                      ;Custom size and position?
0804 0C3F              ;
0805 0C3F              ;
0806 0C3F              ; ------ Custom position and size ----------------------------
0807 0C3F              ;
0808 0C3F A2 00 00              ldx   #y1
0809 0C42 A7 8E        lop1     lda   [<alertStrg]
0810 0C44 95 09                 sta   <windRect,x
0811 0C46 20 6B 11              jsr   incStrg                  ;Add one to <alertStrg.
0812 0C49 20 6B 11              jsr   incStrg                  ;Add one to <alertStrg.
0813 0C4C E8                    inx   
0814 0C4D E8                    inx   
0815 0C4E E0 08 00              cpx   #x2+2
0816 0C51 D0 EF                 bne   lop1
0817 0C53 80 43                 bra   done1
0818 0C55              ;
0819 0C55              ;
0820 0C55              ; ------ Default position and size ---------------------------
0821 0C55              ;
0822 0C55 0A           ok1      asl   a                        ;Convert to index.
0823 0C56 AA                    tax   
0824 0C57
0825 0C57 A5 11                 lda   <xxLocInfo               ;320 mode?
0826 0C59 29 80 00              and   #$0080
0827 0C5C D0 05                 bne   use640high
0828 0C5E
0829 0C5E BC 64 19              ldy   heights320,x
0830 0C61 80 03                 bra   ok2
0831 0C63
0832 0C63 BC 76 19     use640high ldy   heights640,x
0833 0C66
0834 0C66 5A           ok2      phy   
0835 0C67 A9 C8 00              lda   #200
0836 0C6A 38                    sec   
0837 0C6B E3 01                 sbc   1,s
0838 0C6D 4A                    lsr   a
0839 0C6E 85 09                 sta   <windRect+y1
0840 0C70 18                    clc   
0841 0C71 63 01                 adc   1,s
0842 0C73 85 0D                 sta   <windRect+y2
0843 0C75 68                    pla   
0844 0C76
0845 0C76 A5 11                 lda   <xxLocInfo               ;320 mode?
0846 0C78 29 80 00              and   #$0080
0847 0C7B D0 08                 bne   use640wide
0848 0C7D
0849 0C7D BC 88 19              ldy   widths320,x
0850 0C80 A9 40 01              lda   #320
0851 0C83 80 06                 bra   store1
0852 0C85
0853 0C85 BC 9A 19     use640wide ldy   widths640,x
0854 0C88 A9 80 02              lda   #640
0855 0C8B 5A           store1   phy   
0856 0C8C 38                    sec   
0857 0C8D E3 01                 sbc   1,s
0858 0C8F 4A                    lsr   a
0859 0C90 85 0B                 sta   <windRect+x1
0860 0C92 18                    clc   
0861 0C93 63 01                 adc   1,s
0862 0C95 85 0F                 sta   <windRect+x2
0863 0C97 68                    pla   
0864 0C98              done1                                   ; rect = new window portRect.
0865 0C98
0866 0C98              *** For icon dithering, put window at even X position
0867 0C98 A5 0B                 lda   <windRect+x1
0868 0C9A 4A                    lsr   a
0869 0C9B 90 04                 bcc   @alreadyEven
0870 0C9D C6 0B                 dec   <windRect+x1
0871 0C9F C6 0F                 dec   <windRect+x2
0872 0CA1              @alreadyEven  
0873 0CA1
0874 0CA1 A0 44 00              ldy   #p_position+x2           ;Move <windRect into parameter table
0875 0CA4 A2 06 00              ldx   #x2
0876 0CA7 B5 09        lop4     lda   <windRect,x
0877 0CA9 97 35                 sta   [<ptr],y
0878 0CAB 88                    dey   
0879 0CAC 88                    dey   
0880 0CAD CA                    dex   
0881 0CAE CA                    dex   
0882 0CAF 10 F6                 bpl   lop4
0883 0CB1              ;
0884 0CB1              ; --- Create the window --------------------------------------
0885 0CB1              ;
0886 0CB1 48                    pha                            ;Space for result
0887 0CB2 48                    pha   
0888 0CB3 D4 37                 pei   <ptr+2                   ;Pass address of parameter block
0889 0CB5 D4 35                 pei   <ptr
0890 0CB7 A2 0E 09 22           _NewWindow 
0891 0CBE
0892 0CBE              *** Turn window hiliting back on right away
0893 0CBE A9 FE FF              lda   #$FFFE                   ;Turn window hiliting back on.
0894 0CC1 20 72 11              jsr   windowGlobal
0895 0CC4
0896 0CC4 A3 01                 lda   1,s                      ;Remember alert window pointer
0897 0CC6 85 81                 sta   <alertWind
0898 0CC8 A3 03                 lda   3,s
0899 0CCA 85 83                 sta   <alertWind+2
0900 0CCC
0901 0CCC A2 04 1B 22           _SetPort                       ;Switch to window's port
0902 0CD3
0903 0CD3              *** Only set Font Flags to $0004 if they ask for it (16-color text)
0904 0CD3 A5 96                 lda   <strgType
0905 0CD5 29 00 04              and   #alertFullColorBit
0906 0CD8 F0 0A                 beq   @skipSFF
0907 0CDA F4 04 00              pea   $0004
0908 0CDD A2 04 98 22           _SetFontFlags 
0909 0CE4              @skipSFF  
0910 0CE4
0911 0CE4 D4 33                 pei   <handle+2                ;Pass handle of new window parameter
0912 0CE6 D4 31                 pei   <handle                  ;table
0913 0CE8 A2 02 10 22           _DisposeHandle 
0914 0CEF
0915 0CEF 20 7D 11              jsr   alertGuts                ;Draw guts of window.
0916 0CF2 20 9F 17              jsr   monitor                  ;Monitor alert.
0917 0CF5 85 98                 sta   <result                  ;Return ID of button pressed.
0918 0CF7
0919 0CF7              ;
0920 0CF7              ; --- Free button controls ------------------------------------
0921 0CF7              ;
0922 0CF7 A2 08 00              ldx   #8
0923 0CFA B5 26        lop2     lda   <butt1+1,x               ;Valid handle?
0924 0CFC F0 12                 beq   next2
0925 0CFE
0926 0CFE DA                    phx   
0927 0CFF
0928 0CFF B5 27                 lda   <butt1+2,x               ;Free handle.
0929 0D01 29 FF 00              and   #$00FF                   ;Clear default button flag.
0930 0D04 48                    pha   
0931 0D05 B5 25                 lda   <butt1,x
0932 0D07 48                    pha   
0933 0D08 A2 02 10 22           _DisposeHandle 
0934 0D0F
0935 0D0F FA                    plx   
0936 0D10
0937 0D10 CA           next2    dex   
0938 0D11 CA                    dex   
0939 0D12 CA                    dex   
0940 0D13 CA                    dex   
0941 0D14 10 E4                 bpl   lop2
0942 0D16
0943 0D16              *
0944 0D16              * dispose of awTextHandle
0945 0D16              *
0946 0D16 AF 47 11 02           lda   >awTextHandle+1
0947 0D1A F0 18                 beq   @skip
0948 0D1C AF 48 11 02           pushlong >awTextHandle 
0949 0D26 A2 02 10 22           _DisposeHandle 
0950 0D2D A9 00 00              lda   #0
0951 0D30 8F 47 11 02           sta   >awTextHandle+1
0952 0D34              @skip     
0953 0D34
0954 0D34              ;
0955 0D34              ; --- Dispose of alert window --------------------------------
0956 0D34              ;
0957 0D34 D4 83                 pei   <alertWind+2
0958 0D36 D4 81                 pei   <alertWind
0959 0D38 A2 0E 0B 22           _CloseWindow 
0960 0D3F
0961 0D3F              *** Don't flush keys if we aren't scanning for disks
0962 0D3F A5 75                 lda   <diskInsertFlag
0963 0D41 F0 03                 beq   @noFlush
0964 0D43 20 4D 2F              jsr   FlushKeyEvents           ;added 4-Oct-91 DAL
0965 0D46              @noFlush  
0966 0D46              ;
0967 0D46              ; --- Clean up stack and return ------------------------------
0968 0D46              ;
0969 0D46 A2 04 1B 22           _SetPort                       ;Restore caller's port.
0970 0D4D
0971 0D4D A5 96                 lda   <strgType                ;Was a resource ID passed?
0972 0D4F 29 06 00              and   #alertStrgBit
0973 0D52 F0 60                 beq   @skip2
0974 0D54 C9 02 00              cmp   #alertStrgHandle
0975 0D57 F0 51                 beq   @alertHandle
0976 0D59
0977 0D59              *** If resource attr = locked, don't unlock it!
0978 0D59 48                    pha                            ;space for result
0979 0D5A F4 15 80              pea   $8015                    ;rAlertString
0980 0D5D D4 03                 pei   <alertResourceID+2
0981 0D5F D4 01                 pei   <alertResourceID
0982 0D61 A2 1E 1B 22           _GetResourceAttr 
0983 0D68 68                    pla   
0984 0D69 30 21                 bmi   @keepLocked
0985 0D6B              *** Unlock the handle before releasing resource
0986 0D6B 48                    pha   
0987 0D6C 48                    pha                            ;space for LoadResource
0988 0D6D F4 15 80              pea   rAlertString
0989 0D70 D4 03                 pei   <alertResourceID+2
0990 0D72 D4 01                 pei   <alertResourceID
0991 0D74 A2 1E 0E 22           _LoadResource 
0992 0D7B B0 0D                 bcs   @ouch
0993 0D7D 0B                    phd   
0994 0D7E 3B                    tsc   
0995 0D7F 5B                    tcd   
0996 0D80 A0 04 00              ldy   #4
0997 0D83 B7 03                 lda   [3],y
0998 0D85 0A                    asl   a
0999 0D86 4A                    lsr   a                        ;clear bit 15
1000 0D87 97 03                 sta   [3],y
1001 0D89 2B                    pld   
1002 0D8A 7A           @ouch    ply   
1003 0D8B 7A                    ply   
1004 0D8C              @keepLocked  
1005 0D8C
1006 0D8C A2 FF FF              ldx   #$ffff                   ;added line 16-Sep-91 DAL, oops
1007 0D8F A5 96                 lda   <strgType
1008 0D91 29 80 00              and   #alertNoDisposeBit
1009 0D94 F0 03                 beq   @likeBefore
1010 0D96 A2 03 00              ldx   #3                       ;purge level 3
1011 0D99 DA           @likeBefore phx   
1012 0D9A F4 15 80              pea   rAlertString             ;Pass resource type of alert string.
1013 0D9D D4 03                 pei   <alertResourceID+2
1014 0D9F D4 01                 pei   <alertResourceID
1015 0DA1 A2 1E 17 22           _ReleaseResource 
1016 0DA8 80 0A                 bra   @skip2
1017 0DAA
1018 0DAA A0 04 00     @alertHandle ldy   #4                   ;Leave alert string handle unlocked.
1019 0DAD B7 01                 lda   [<alertResourceID],y
1020 0DAF 29 FF 7F              and   #$7FFF
1021 0DB2 97 01                 sta   [<alertResourceID],y
1022 0DB4              @skip2    
1023 0DB4
1024 0DB4 A0 00 00              ldy   #0                       ;No error.
1025 0DB7
1026 0DB7              errorExit  
1027 0DB7
1028 0DB7              *** Restore system preferences
1029 0DB7 5A                    phy                            ;preserve error code
1030 0DB8 D4 7D                 pei   <oldSysPrefs             ;previous sys prefs word
1031 0DBA F4 01 00              pea   1                        ;pcount
1032 0DBD 3B                    tsc   
1033 0DBE 1A                    inc   a
1034 0DBF F4 00 00              pea   0
1035 0DC2 48                    pha   
1036 0DC3 F4 0C 20              pea   $200C                    ;SetSysPrefsGS
1037 0DC6 22 B0 00 E1           jsl   $e100b0
1038 0DCA 68                    pla   
1039 0DCB 68                    pla   
1040 0DCC 7A                    ply                            ;restore error code
1041 0DCD
1042 0DCD              *** Restore key translation
1043 0DCD 5A                    phy   
1044 0DCE A5 79                 lda   <oldKeyTranslation
1045 0DD0 20 12 11              jsr   mySetKeyTranslation
1046 0DD3 7A                    ply   
1047 0DD4
1048 0DD4              *** Resume using caller's stack; dispose special stack
1049 0DD4              *** Must preserve Y (error code)
1050 0DD4 BA                    tsx                            ;special stack
1051 0DD5 A5 7B                 lda   <oldStack                ;old stack (0=don't restore)
1052 0DD7 F0 17                 beq   @noSpecialStack
1053 0DD9 1B                    tcs   
1054 0DDA 5A                    phy                            ;preserve error code
1055 0DDB DA                    phx   
1056 0DDC DA                    phx                            ;space for FindHandle
1057 0DDD F4 00 00              pea   0
1058 0DE0 DA                    phx   
1059 0DE1 A2 02 1A 22           _FindHandle 
1060 0DE8 A2 02 10 22           _DisposeHandle 
1061 0DEF 7A                    ply                            ;restore error code
1062 0DF0              @noSpecialStack  
1063 0DF0
1064 0DF0 A5 8C                 lda   <returnAddr+4            ;Move return address down stack.
1065 0DF2 85 96                 sta   <result-2
1066 0DF4 A5 8A                 lda   <returnAddr+2
1067 0DF6 85 94                 sta   <result-4
1068 0DF8 A5 88                 lda   <returnAddr
1069 0DFA 85 92                 sta   <result-6
1070 0DFC
1071 0DFC 3B                    tsc                            ;Free temp direct page.
1072 0DFD 18                    clc   
1073 0DFE 69 84 00              adc   #saveDpage-1
1074 0E01 1B                    tcs   
1075 0E02
1076 0E02 2B                    pld                            ;Restore caller's direct page pointer.
1077 0E03 AB                    plb                            ;Restore caller's data bank pointer.
1078 0E04 68                    pla                            ;Remove input parameter from stack.
1079 0E05 68                    pla   
1080 0E06 68                    pla   
1081 0E07 68                    pla   
1082 0E08 68                    pla   
1083 0E09
1084 0E09 22 68 00 E1           jsl   DecBusyFlg
1085 0E0D 98                    tya                            ;Error code.
1086 0E0E C9 01 00              cmp   #1
1087 0E11 6B                    rtl   
1088 0E12
1089 0E12              *** Set key translation without changing BRAM (Input in A)
1090 0E12 48           mySetKeyTranslation pha                 ;new trans code
1091 0E13 F4 20 00              pea   $0020                    ;vector # for restore SetVector
1092 0E16
1093 0E16 48                    pha   
1094 0E17 48                    pha                            ;space for GetVector
1095 0E18 F4 20 00              pea   $0020
1096 0E1B A2 03 11 22           _GetVector 
1097 0E22
1098 0E22 F4 20 00              pea   $0020
1099 0E25 F4 02 00 F4           pushlong #myRTL 
1100 0E2B A2 03 10 22           _SetVector 
1101 0E32
1102 0E32 A3 07                 lda   7,s
1103 0E34 48                    pha   
1104 0E35 A2 06 1C 22           _SetKeyTranslation 
1105 0E3C
1106 0E3C A2 03 10 22           _SetVector 
1107 0E43 68                    pla                            ;discard kTransID
1108 0E44 60                    rts   
1109 0E45
1110 0E45 6B           myRTL    rtl   
1111 0E46
1112 0E46 00 00 00 00  awTextHandle DC L:0
1113 0E4A 00 00 00 00  awTextPtr DC L:0
1114 0E4E 00 00        awTextLen DC W:0
1115 0E50 00 00 00 00  awTextRect DS B:8
1116 0E58
1117 0E58 00 00 00 00  buttonChars DC W:0,0,0                  ;first character of each button title
1118 0E5E
1119 0E5E              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1120 0E5E              ;          Fetch and convert a ASCII decimal digit.
1121 0E5E              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1122 0E5E              ;
1123 0E5E              ;   IN:    alertStrg = pointer to ASCII decimal digit.
1124 0E5E              ;
1125 0E5E              ;  OUT:    a = digit.
1126 0E5E              ;          alertStrg = advanced to next character.
1127 0E5E              ;
1128 0E5E 20 66 11     fetchDigit jsr   fetchChar
1129 0E61 38                    sec   
1130 0E62 E9 30 00              sbc   #'0'
1131 0E65 60                    rts   
1132 0E66
1133 0E66
1134 0E66              ; = = = = = = = = = = = = = = = = = = = = = = = = =
1135 0E66              ;          Fetch character from string.
1136 0E66              ; = = = = = = = = = = = = = = = = = = = = = = = = =
1137 0E66              ;
1138 0E66              ;   IN:    alertStrg = pointer to string.
1139 0E66              ;
1140 0E66              ;  OUT:    a = first character in string.
1141 0E66              ;          alertStrg = advanced to next character.
1142 0E66              ;
1143 0E66 A7 8E        fetchChar lda   [<alertStrg]
1144 0E68 29 FF 00              and   #$00FF
1145 0E6B
1146 0E6B
1147 0E6B              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1148 0E6B              ;          Add one to <alertStrg pointer.
1149 0E6B              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
1150 0E6B              ;
1151 0E6B E6 8E        incStrg  inc   <alertStrg
1152 0E6D D0 02                 bne   exit110
1153 0E6F E6 90                 inc   <alertStrg+2
1154 0E71 60           exit110  rts   
1155 0E72
1156 0E72
1157 0E72              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1158 0E72              ;          Set Window Manager global flag.
1159 0E72              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1160 0E72              ;
1161 0E72              ;   IN:    a = flag.
1162 0E72              ;
1163 0E72 48           windowGlobal pha                        ;Space for result.
1164 0E73 48                    pha                            ;Turn window hiliting back on.
1165 0E74 A2 0E 56 22           _WindowGlobal 
1166 0E7B 68                    pla                            ;No need for result.
1167 0E7C 60                    rts   
1168 0E7D
1169 0E7D
1170 0E7D              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1171 0E7D              ;          Create and draw contents of alert.
1172 0E7D              ;200= = = = = = = = = = = = = = = = = = = = = = = = =
1173 0E7D              ;
1174 0E7D              ;   IN:    alertStrg = pointer to icon character in string:
1175 0E7D              ;
1176 0E7D              ;                1/Alert text./Button 1/Button 2/Button 3
1177 0E7D              ;
1178 0E7D              ;                Icon numbers:
1179 0E7D              ;                   0 = custom icon, pointer follows.
1180 0E7D              ;                   1 = no icon.
1181 0E7D              ;                   2 = stop
1182 0E7D              ;                   3 = note
1183 0E7D              ;                   4 = caution
1184 0E7D              ;                   5 = disk
1185 0E7D              ;                   6 = disk swap
1186 0E7D              ;                   7-9 = reserved
1187 0E7D              ;
1188 0E7D              alertGuts  
1189 0E7D              ;
1190 0E7D              ; --- Draw icon ----------------------------------------------
1191 0E7D              ;
1192 0E7D 64 1F                 stz   <xxBounds+x2             ;No icon, just in case.
1193 0E7F
1194 0E7F 20 5E 11              jsr   fetchDigit
1195 0E82              *** check for disk-swap icon
1196 0E82 48                    pha   
1197 0E83 A5 96                 lda   <strgType
1198 0E85 29 00 01              and   #alertDiskScanBit
1199 0E88 85 75                 sta   <diskInsertFlag
1200 0E8A 68                    pla   
1201 0E8B C9 06 00              cmp   #6                       ;disk swap icon
1202 0E8E D0 02                 bne   @notDiskSwap
1203 0E90 E6 75                 inc   <diskInsertFlag
1204 0E92              @notDiskSwap  
1205 0E92              ***
1206 0E92 48                    pha   
1207 0E93 C9 02 00              cmp   #2                       ;always do SysBeep2 for Stop alerts
1208 0E96 F0 16                 beq   @someSound
1209 0E98 C9 04 00              cmp   #4                       ;always do SysBeep2 for Caution alerts
1210 0E9B F0 11                 beq   @someSound
1211 0E9D C9 06 00              cmp   #6                       ;always do SysBeep2 for Disk-Swap alerts
1212 0EA0 D0 05                 bne   @notDiskReq
1213 0EA2 A9 30 C0              lda   #$C030                   ;disk-request sound
1214 0EA5 80 17                 bra   @thisSound
1215 0EA7 A5 96        @notDiskReq lda   <strgType
1216 0EA9 29 10 00              and   #alertSoundBit
1217 0EAC F0 18                 beq   @noSound
1218 0EAE A3 01        @someSound lda   1,s
1219 0EB0 C9 01 00              cmp   #1                       ;custom icon--no sound
1220 0EB3 F0 11                 beq   @noSound
1221 0EB5 C9 05 00              cmp   #5                       ;disk icon--no sound
1222 0EB8 F0 0C                 beq   @noSound
1223 0EBA 18                    clc   
1224 0EBB 69 50 C0              adc   #$C050                   ;default to silence, defer till GNE
1225 0EBE 48           @thisSound pha   
1226 0EBF A2 03 38 22           _SysBeep2 
1227 0EC6 68           @noSound pla                            ;retrieve icon number
1228 0EC7              ***
1229 0EC7 64 7F                 stz   realDrawIconFlag         ;8-Mar-91 DAL
1230 0EC9
1231 0EC9 3A                    dec   a                        ;No icon?
1232 0ECA 10 03                 bpl   ok204
1233 0ECC 82 B4 00              brl   skip200
1234 0ECF 3A           ok204    dec   a
1235 0ED0 10 45                 bpl   @ok200                   ;Custom icon?
1236 0ED2
1237 0ED2 A7 8E                 lda   [<alertStrg]             ;Get pointer to image data.
1238 0ED4 85 13                 sta   <xxImage
1239 0ED6 A0 02 00              ldy   #2
1240 0ED9 B7 8E                 lda   [<alertStrg],y
1241 0EDB 85 15                 sta   <xxImage+2
1242 0EDD
1243 0EDD              *** Check for resource-based icon
1244 0EDD A5 96                 lda   <strgType
1245 0EDF 29 00 02              and   #alertIconRsrcBit
1246 0EE2 F0 1B                 beq   @notIconRsrc
1247 0EE4
1248 0EE4 E6 7F                 inc   <realDrawIconFlag
1249 0EE6
1250 0EE6 18                    clc   
1251 0EE7 A5 8E                 lda   <alertStrg
1252 0EE9 69 04 00              adc   #4
1253 0EEC 85 8E                 sta   <alertStrg
1254 0EEE 90 02                 bcc   @1
1255 0EF0 E6 90                 inc   <alertStrg+2
1256 0EF2              @1        
1257 0EF2
1258 0EF2 48                    pha   
1259 0EF3 48                    pha                            ;space for LoadResource
1260 0EF4 F4 01 80              pea   $8001                    ;rIcon
1261 0EF7 D4 15                 pei   <xxImage+2
1262 0EF9 D4 13                 pei   <xxImage
1263 0EFB 64 14                 stz   <xxImage+1
1264 0EFD 80 4B                 bra   @loadIconRsrc
1265 0EFF              @notIconRsrc  
1266 0EFF
1267 0EFF C8                    iny   
1268 0F00 C8                    iny                            ;y is now 4
1269 0F01 B7 8E                 lda   [<alertStrg],y           ;Get width, in bytes.
1270 0F03 AA                    tax   
1271 0F04 C8                    iny   
1272 0F05 C8                    iny   
1273 0F06 B7 8E                 lda   [<alertStrg],y           ;Get height.
1274 0F08 A8                    tay   
1275 0F09
1276 0F09 A5 8E                 lda   <alertStrg               ;Skip over custom icon data.
1277 0F0B 18                    clc   
1278 0F0C 69 08 00              adc   #8
1279 0F0F 85 8E                 sta   <alertStrg
1280 0F11 90 5F                 bcc   store200
1281 0F13 E6 90                 inc   <alertStrg+2
1282 0F15 80 5B                 bra   store200
1283 0F17
1284 0F17              @ok200    
1285 0F17              *
1286 0F17              * We'll do a real DrawIcon from a standard resource-based icon.
1287 0F17              * The icon number MINUS TWO is in A.
1288 0F17              * Set realDrawIconFlag so the draw routine knows this.
1289 0F17              * Set xxImage to point to the icon.
1290 0F17              *
1291 0F17 1A                    inc   a
1292 0F18 1A                    inc   a                        ;got real icon number back
1293 0F19
1294 0F19 E6 7F                 inc   <realDrawIconFlag
1295 0F1B 64 14                 stz   <xxImage+1
1296 0F1D
1297 0F1D              *** added 16-Sep-91 DAL -- check for disk-swap icon, don't use LoadResource
1298 0F1D C9 06 00              cmp   #6
1299 0F20 D0 18                 bne   @notDS
1300 0F22
1301 0F22 AF E5 16 02           lda   >DiskSwap640Hndl+2
1302 0F26 A8                    tay   
1303 0F27 AF E3 16 02           lda   >DiskSwap640Hndl
1304 0F2B A6 10                 ldx   <xxLocInfo-1
1305 0F2D 30 09                 bmi   @ds640
1306 0F2F AF E9 16 02           lda   >DiskSwap320Hndl+2
1307 0F33 A8                    tay   
1308 0F34 AF E7 16 02           lda   >DiskSwap320Hndl
1309 0F38 80 1B        @ds640   bra   @haveIconHandle
1310 0F3A              @notDS    
1311 0F3A              *** end 16-Sep-91
1312 0F3A
1313 0F3A A4 10                 ldy   <xxLocInfo-1
1314 0F3C 30 03                 bmi   @icon640
1315 0F3E 09 00 01              ora   #$0100                   ;icons $07ff01xx are for 320
1316 0F41 48           @icon640 pha   
1317 0F42 48                    pha                            ;space for LoadResource result
1318 0F43 F4 01 80              pea   $8001                    ;rIcon
1319 0F46 F4 FF 07              pea   $07FF
1320 0F49 48                    pha   
1321 0F4A A2 1E 0E 22  @loadIconRsrc _LoadResource 
1322 0F51 68                    pla   
1323 0F52 7A                    ply   
1324 0F53 B0 2E                 bcs   didIconSetup
1325 0F55
1326 0F55 84 15        @haveIconHandle sty   <xxImage+2
1327 0F57 85 13                 sta   <xxImage
1328 0F59 A0 02 00              ldy   #2
1329 0F5C A7 13                 lda   [<xxImage]
1330 0F5E AA                    tax   
1331 0F5F B7 13                 lda   [<xxImage],y
1332 0F61 85 15                 sta   <xxImage+2
1333 0F63 86 13                 stx   <xxImage
1334 0F65              *** get icon height in xxBounds+y2, width in xxBounds+x2
1335 0F65 A0 04 00              ldy   #4                       ;offset to icon height
1336 0F68 B7 13                 lda   [<xxImage],y
1337 0F6A 85 1D                 sta   <xxBounds+y2
1338 0F6C C8                    iny   
1339 0F6D C8                    iny                            ;6=offset to icon width
1340 0F6E B7 13                 lda   [<xxImage],y
1341 0F70 80 06                 bra   commonStoreBounds        ;16-Jan-92 DAL
1342 0F72
1343 0F72 84 1D        store200 sty   <xxBounds+y2
1344 0F74 86 17                 stx   <xxWidth
1345 0F76 8A                    txa                            ;Compute width in pixels.
1346 0F77 0A                    asl   a                        ;2 pixels per byte.
1347 0F78 A6 10        commonStoreBounds ldx   <xxLocInfo-1    ;320 or 640 mode?
1348 0F7A 10 01                 bpl   store202
1349 0F7C 0A                    asl   a                        ;4 pixels per byte.
1350 0F7D 85 1F        store202 sta   <xxBounds+x2
1351 0F7F 64 19                 stz   <xxBounds+y1
1352 0F81 64 1B                 stz   <xxBounds+x1
1353 0F83
1354 0F83              didIconSetup  
1355 0F83
1356 0F83              ;
1357 0F83              ; --- Perform substitution on rest of string.
1358 0F83              ;
1359 0F83 A0 00 00     skip200  ldy   #0                       ;Compute size of rest of alert string.
1360 0F86 E2 20                 sep   #$20
1361 0F88                       LONGA OFF 
1362 0F88 A7 8E                 lda   [<alertStrg]
1363 0F8A C8           @lop200  iny   
1364 0F8B D7 8E                 cmp   [<alertStrg],y
1365 0F8D D0 FB                 bne   @lop200
1366 0F8F C8           @lop201  iny   
1367 0F90 B7 8E                 lda   [<alertStrg],y
1368 0F92 D0 FB                 bne   @lop201
1369 0F94 C2 20                 rep   #$20
1370 0F96                       LONGA ON 
1371 0F96 C8                    iny                            ;Move the zero also.
1372 0F97
1373 0F97              *** Find a suitable separator character
1374 0F97 5A                    phy   
1375 0F98
1376 0F98 48                    pha   
1377 0F99 48                    pha                            ;space for CompileText result
1378 0F9A A5 96                 lda   <strgType
1379 0F9C 29 01 00              and   #strgTypeBit
1380 0F9F 48                    pha   
1381 0FA0 D4 94                 pei   <substrgs+2
1382 0FA2 D4 92                 pei   <substrgs
1383 0FA4 D4 90                 pei   <alertStrg+2
1384 0FA6 D4 8E                 pei   <alertStrg
1385 0FA8 5A                    phy   
1386 0FA9 A2 0E 60 22           _CompileText 
1387 0FB0 20 EB 16              jsr   FindUniqueCharacter      ;input = handle on stack; out=<theNewSeparator
1388 0FB3 A2 02 10 22           _DisposeHandle 
1389 0FBA
1390 0FBA              *** make a safe new copy of the string so we can mess with it
1391 0FBA A3 01                 lda   1,s                      ;copy of size needed
1392 0FBC 48                    pha   
1393 0FBD 48                    pha                            ;space for NewHandle result
1394 0FBE F4 00 00              pea   0
1395 0FC1 48                    pha   
1396 0FC2 F4 0E 40              pea   $400e                    ;memory ID
1397 0FC5 F4 00 C0              pea   $C000                    ;locked and fixed
1398 0FC8 48                    pha   
1399 0FC9 48                    pha                            ;ignored
1400 0FCA A2 02 09 22           _NewHandle 
1401 0FD1 FA                    plx   
1402 0FD2 7A                    ply   
1403 0FD3              ;;;	bcs	@error
1404 0FD3 84 07                 sty   <alertStrgHand+2
1405 0FD5 86 05                 stx   <alertStrgHand
1406 0FD7
1407 0FD7 D4 90                 pei   <alertStrg+2
1408 0FD9 D4 8E                 pei   <alertStrg               ;ptr to old string for BlockMove
1409 0FDB
1410 0FDB A0 02 00              ldy   #2
1411 0FDE B7 05                 lda   [<alertStrgHand],y
1412 0FE0 85 90                 sta   <alertStrg+2
1413 0FE2 A7 05                 lda   [<alertStrgHand]
1414 0FE4 85 8E                 sta   <alertStrg
1415 0FE6
1416 0FE6 D4 90                 pei   <alertStrg+2
1417 0FE8 D4 8E                 pei   <alertStrg
1418 0FEA F4 00 00              pea   0
1419 0FED A3 0B                 lda   1+10,s                   ;size of string (still on stack)
1420 0FEF 48                    pha   
1421 0FF0 A2 02 2B 22           _BlockMove 
1422 0FF7
1423 0FF7              *** replace separator character with unique new separator (<theNewSeparator)
1424 0FF7              *** The first character in <alertStrg is the old separator.
1425 0FF7 A3 01                 lda   1,s
1426 0FF9 A8                    tay   
1427 0FFA 88                    dey   
1428 0FFB E2 20                 sep   #$20
1429 0FFD B7 8E        @replace lda   [<alertStrg],y
1430 0FFF C7 8E                 cmp   [<alertStrg]
1431 1001 D0 04                 bne   @next
1432 1003 A5 77                 lda   <theNewSeparator
1433 1005 97 8E                 sta   [<alertStrg],y
1434 1007 88           @next    dey   
1435 1008 10 F3                 bpl   @replace
1436 100A C2 20                 rep   #$20
1437 100C
1438 100C 7A                    ply                            ;size of string
1439 100D
1440 100D
1441 100D 48                    pha                            ;Space for result.
1442 100E 48                    pha   
1443 100F A5 96                 lda   <strgType                ;Pass substitution string type.
1444 1011 29 01 00              and   #strgTypeBit
1445 1014 48                    pha   
1446 1015 D4 94                 pei   <substrgs+2              ;Pass pointer to substitution strings.
1447 1017 D4 92                 pei   <substrgs
1448 1019 D4 90                 pei   <alertStrg+2             ;Pass pointer to source string.
1449 101B D4 8E                 pei   <alertStrg
1450 101D 5A                    phy                            ;Pass size of alert string.
1451 101E A2 0E 60 22           _CompileText 
1452 1025
1453 1025 D4 07                 pei   <alertStrgHand+2
1454 1027 D4 05                 pei   <alertStrgHand
1455 1029 A2 02 10 22           _DisposeHandle 
1456 1030
1457 1030 68                    pla                            ;Handle of compiled alert string.
1458 1031 85 05                 sta   <alertStrgHand
1459 1033 68                    pla   
1460 1034 85 07                 sta   <alertStrgHand+2
1461 1036
1462 1036 A0 04 00              ldy   #4
1463 1039 B7 05                 lda   [<alertStrgHand],y
1464 103B 09 00 80              ora   #$8000
1465 103E 97 05                 sta   [<alertStrgHand],y
1466 1040 88                    dey   
1467 1041 88                    dey   
1468 1042 B7 05                 lda   [<alertStrgHand],y
1469 1044 85 90                 sta   <alertStrg+2
1470 1046 A7 05                 lda   [<alertStrgHand]
1471 1048 85 8E                 sta   <alertStrg
1472 104A
1473 104A              ;
1474 104A              ; --- Get separation character -------------------------------
1475 104A              ;
1476 104A 20 66 11              jsr   fetchChar
1477 104D 85 23                 sta   <separator               ;Text terminator.
1478 104F 85 21                 sta   <terminate               ;Alert string terminator.
1479 1051
1480 1051              ;
1481 1051              ; --- Compile text string ------------------------------------
1482 1051              ;
1483 1051 64 73                 stz   <DoingButtons            ;added 25-Nov-90 DAL
1484 1053 A9 E9 03              lda   #MaxString               ;Maximum number of characters.
1485 1056 20 30 17              jsr   compileStrg
1486 1059 A6 6B                 ldx   <TheWork                 ;Length of string.
1487 105B
1488 105B              ;
1489 105B              ; --- Print text box -----------------------------------------
1490 105B              ;
1491 105B              rect2    equ   TheWork
1492 105B
1493 105B A5 0D                 lda   <windRect+y2
1494 105D 38                    sec   
1495 105E E5 09                 sbc   <windRect+y1
1496 1060 85 6F                 sta   <rect2+y2
1497 1062
1498 1062 A5 0F                 lda   <windRect+x2
1499 1064 38                    sec   
1500 1065 E5 0B                 sbc   <windRect+x1
1501 1067 E9 08 00              sbc   #8
1502 106A A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
1503 106C 10 03                 bpl   store204
1504 106E E9 08 00              sbc   #8
1505 1071 85 71        store204 sta   <rect2+x2
1506 1073
1507 1073 A9 03 00              lda   #TextTop
1508 1076 85 6B                 sta   <rect2+y1
1509 1078
1510 1078 A5 96                 lda   <strgType                ;added 14-Nov-90 DAL
1511 107A 29 08 00              and   #alertRectBit            ;added 14-Nov-90 DAL
1512 107D 49 08 00              eor   #alertRectBit            ;added 14-Nov-90 DAL
1513 1080 F0 02                 beq   @1                       ;added 14-Nov-90 DAL
1514 1082 A5 1F                 lda   <xxBounds+x2             ;Right side of icon,
1515 1084 18           @1       clc   
1516 1085 69 0A 00              adc   #10                      ;plus some padding.
1517 1088 A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
1518 108A 10 03                 bpl   store205
1519 108C 69 0A 00              adc   #10                      ;More padding in 640 mode.
1520 108F 85 6D        store205 sta   <rect2+x1
1521 1091
1522 1091 A5 37                 lda   <ptr+2                   ;pass pointer to string
1523 1093 8F 4C 11 02           sta   >awTextPtr+2
1524 1097 48                    pha   
1525 1098 A5 35                 lda   <ptr
1526 109A 1A                    inc   a                        ;Skip length byte (does not cross bank)
1527 109B 8F 4A 11 02           sta   >awTextPtr
1528 109F 48                    pha   
1529 10A0 DA                    phx                            ;Pass length of string.
1530 10A1 8A                    txa   
1531 10A2 8F 4E 11 02           sta   >awTextLen
1532 10A6 20 4F 19              jsr   pushrect2                ;Pass pointer to text box.
1533 10A9 A5 6B                 lda   <rect2
1534 10AB 8F 50 11 02           sta   >awTextRect
1535 10AF A5 6D                 lda   <rect2+2
1536 10B1 8F 52 11 02           sta   >awTextRect+2
1537 10B5 A5 6F                 lda   <rect2+4
1538 10B7 8F 54 11 02           sta   >awTextRect+4
1539 10BB A5 71                 lda   <rect2+6
1540 10BD 8F 56 11 02           sta   >awTextRect+6
1541 10C1 F4 00 00              pea   0                        ;Pass 'left justification' flag.
1542 10C4 A2 14 20 22           _LETextBox2 
1543 10CB
1544 10CB 20 9D 16              jsr   DrawTheAWIcon
1545 10CE
1546 10CE 7B                    tdc   
1547 10CF 8F C5 18 02           sta   >DirPageCheat+1          ;give DP to the update routine
1548 10D3
1549 10D3
1550 10D3 A5 33                 lda   <handle+2
1551 10D5 8D 48 11              sta   awTextHandle+2
1552 10D8 A5 31                 lda   <handle
1553 10DA 8D 46 11              sta   awTextHandle
1554 10DD
1555 10DD              ;
1556 10DD              ; --- Get button titles --------------------------------------
1557 10DD              ;
1558 10DD              buttCount equ   TheWork+2
1559 10DD
1560 10DD 64 26                 stz   <butt1+1                 ;Set 'no title' flag.
1561 10DF 64 2A                 stz   <butt2+1                 ;Set 'no title' flag.
1562 10E1 64 2E                 stz   <butt3+1                 ;Set 'no title' flag.
1563 10E3
1564 10E3 64 6D                 stz   <buttCount               ;Button counter.
1565 10E5 64 21                 stz   <terminate               ;Alert string terminator (16-Jan-92 DAL)
1566 10E7
1567 10E7 A9 51 00     lop200   lda   #MaxButtStrg             ;Maximum number of characters.
1568 10EA 38                    sec                            ;added 25-Nov-90 DAL
1569 10EB 66 73                 ror   <DoingButtons            ;added 25-Nov-90 DAL
1570 10ED 20 30 17              jsr   compileStrg
1571 10F0 08                    php                            ;Save 'end of string' flag.
1572 10F1
1573 10F1 A5 6D                 lda   <buttCount               ;Remember handle of title.
1574 10F3 0A                    asl   a
1575 10F4 0A                    asl   a
1576 10F5 AA                    tax   
1577 10F6 A5 31                 lda   <handle
1578 10F8 95 25                 sta   <butt1,x
1579 10FA A5 33                 lda   <handle+2
1580 10FC 95 27                 sta   <butt1+2,x
1581 10FE
1582 10FE E6 6D                 inc   <buttCount
1583 1100 28                    plp                            ;End of alert string?
1584 1101 90 E4                 bcc   lop200
1585 1103
1586 1103 C6 6D                 dec   <buttCount               ;Zero relative.
1587 1105
1588 1105              ;
1589 1105              ; --- Find widest title --------------------------------------
1590 1105              ;
1591 1105              counter  equ   TheWork
1592 1105              widest   equ   TheWork+4
1593 1105
1594 1105 A5 6D                 lda   <buttCount               ;Start with last button.
1595 1107 85 6B                 sta   <counter
1596 1109 64 6F                 stz   <widest                  ;Start with no width.
1597 110B
1598 110B              *** Flag that we don't have any button first-characters yet
1599 110B 9C 58 11              stz   ButtonChars
1600 110E 9C 5A 11              stz   ButtonChars+2
1601 1111 9C 5C 11              stz   ButtonChars+4
1602 1114
1603 1114 A5 6B        lop201   lda   <counter
1604 1116 0A                    asl   a
1605 1117 0A                    asl   a
1606 1118 AA                    tax   
1607 1119 B5 25                 lda   <butt1,x
1608 111B 85 31                 sta   <handle
1609 111D B5 26                 lda   <butt1+1,x
1610 111F 85 32                 sta   <handle+1
1611 1121
1612 1121 48                    pha                            ;Space for result.
1613 1122 A0 02 00              ldy   #2                       ;Pass pointer to string.
1614 1125 B7 31                 lda   [<handle],y
1615 1127 48                    pha   
1616 1128 A7 31                 lda   [<handle]
1617 112A 48                    pha   
1618 112B              *** Remember the first character for duplicate-checking later
1619 112B A5 6B                 lda   <counter
1620 112D 0A                    asl   a
1621 112E AA                    tax   
1622 112F 0B                    phd   
1623 1130 3B                    tsc   
1624 1131 5B                    tcd   
1625 1132
1626 1132 A0 00 00              ldy   #0                       ;skip over blanks
1627 1135 98           @search  tya   
1628 1136 E2 30                 sep   #$30
1629 1138 D7 03                 cmp   [3],y
1630 113A C2 30                 rep   #$30
1631 113C A9 00 00              lda   #0
1632 113F B0 0B                 bcs   @gotKeyEq
1633 1141 C8                    iny   
1634 1142 B7 03                 lda   [3],y
1635 1144 29 FF 00              and   #$00ff
1636 1147 C9 20 00              cmp   #$0020
1637 114A F0 E9                 beq   @search
1638 114C
1639 114C 20 36 16     @gotKeyEq jsr   upcase
1640 114F 9D 58 11              sta   ButtonChars,x
1641 1152 2B                    pld   
1642 1153              *** done finding key equivalent
1643 1153
1644 1153 A2 04 A9 22           _StringWidth 
1645 115A 68                    pla   
1646 115B C5 6F                 cmp   <widest                  ;Is this button the widest so far?
1647 115D 90 02                 bcc   next201
1648 115F 85 6F                 sta   <widest                  ;Remember widest.
1649 1161
1650 1161 C6 6B        next201  dec   <counter
1651 1163 10 AF                 bpl   lop201
1652 1165
1653 1165 A5 6F                 lda   <widest                  ;Pad the button size.
1654 1167 18                    clc   
1655 1168 A4 10                 ldy   <xxLocInfo-1             ;320 or 640 mode?
1656 116A 10 0D                 bpl   ck320min
1657 116C
1658 116C 69 14 00              adc   #20
1659 116F C9 3C 00              cmp   #minWidth640             ;Minimum size?
1660 1172 B0 12                 bcs   store201
1661 1174 A9 3C 00              lda   #minWidth640             ;Make minimum size.
1662 1177 80 0D                 bra   store201
1663 1179              ;
1664 1179 69 0A 00     ck320min adc   #10
1665 117C C9 1E 00              cmp   #minWidth320             ;Minimum size?
1666 117F B0 05                 bcs   store201
1667 1181 A9 1E 00              lda   #minWidth320             ;Make minimum size.
1668 1184 80 00                 bra   store201
1669 1186
1670 1186 85 6F        store201 sta   <widest
1671 1188
1672 1188              ;
1673 1188              ; --- Compute space between buttons --------------------------
1674 1188              ;
1675 1188              Thewidth equ   TheWork
1676 1188
1677 1188 64 6B                 stz   <TheWidth                ;No space between buttons, just in case.
1678 118A
1679 118A A5 0F                 lda   <windRect+x2             ;Compute width of window.
1680 118C 38                    sec   
1681 118D E5 0B                 sbc   <windRect+x1
1682 118F
1683 118F A6 6D                 ldx   <buttCount
1684 1191 E5 6F        lop202   sbc   <widest
1685 1193 90 22                 bcc   done2                    ;Buttons don't fit in window?
1686 1195 CA                    dex   
1687 1196 10 F9                 bpl   lop202
1688 1198              ;                                     a = space between all buttons.
1689 1198
1690 1198 A6 6D                 ldx   <buttCount               ;Compute space between buttons.
1691 119A D0 03                 bne   next203
1692 119C
1693 119C 4A                    lsr   a                        ;One button.
1694 119D 80 16                 bra   store203
1695 119F
1696 119F CA           next203  dex   
1697 11A0 D0 11                 bne   threeButts
1698 11A2
1699 11A2 48                    pha                            ;Space for result.
1700 11A3 48                    pha   
1701 11A4 48                    pha                            ;Pass remaining space.
1702 11A5 F4 03 00              pea   3                        ;Divide by 3.
1703 11A8 A2 0B 0B 22           _UDivide 
1704 11AF 68                    pla                            ;Get quotient
1705 11B0 FA                    plx                            ;Get remainder (not used).
1706 11B1 80 02                 bra   store203
1707 11B3
1708 11B3 4A           threeButts lsr   a
1709 11B4 4A                    lsr   a
1710 11B5
1711 11B5 85 6B        store203 sta   <TheWidth                ;Width between buttons.
1712 11B7              done2     
1713 11B7
1714 11B7              ;
1715 11B7              ; --- Create buttons -----------------------------------------
1716 11B7              ;
1717 11B7              counter2 equ   TheWork+6
1718 11B7              ;
1719 11B7 64 3A                 stz   <ptr2+1                  No default button flag, just in case.
1720 11B9              ;
1721 11B9 A5 0D                 lda   <windRect+y2
1722 11BB 38                    sec   
1723 11BC E5 09                 sbc   <windRect+y1
1724 11BE E9 05 00              sbc   #5
1725 11C1 85 0D                 sta   <windRect+y2
1726 11C3 E9 0D 00              sbc   #13
1727 11C6 85 09                 sta   <windRect+y1
1728 11C8              ;
1729 11C8 64 0F                 stz   <windRect+x2
1730 11CA 64 71                 stz   <counter2
1731 11CC              ;
1732 11CC A5 71        lop204   lda   <counter2
1733 11CE 0A                    asl   a
1734 11CF 0A                    asl   a
1735 11D0 AA                    tax   
1736 11D1 B5 25                 lda   <butt1,x
1737 11D3 85 31                 sta   <handle
1738 11D5 B5 27                 lda   <butt1+2,x
1739 11D7 85 33                 sta   <handle+2
1740 11D9              ;
1741 11D9 A5 0F                 lda   <windRect+x2
1742 11DB 18                    clc   
1743 11DC 65 6B                 adc   <TheWidth
1744 11DE              *** If we're doing uneven button spacing, do stuff here
1745 11DE 48                    pha   
1746 11DF A5 96                 lda   <strgType
1747 11E1 29 20 00              and   #alertSpacingBit
1748 11E4 F0 27                 beq   @notUneven
1749 11E6
1750 11E6 A5 6D                 lda   <buttCount               ;zero-relative count
1751 11E8 38                    sec   
1752 11E9 E5 71                 sbc   <counter2
1753 11EB F0 17                 beq   @rightmost
1754 11ED 3A                    dec   a
1755 11EE F0 06                 beq   @center
1756 11F0 AF 52 11 02  @leftmost lda   >awTextRect+2           ;left button aligned w/ left of text
1757 11F4 80 15                 bra   @uneven
1758 11F6
1759 11F6 AF 56 11 02  @center  lda   >awTextRect+6            ;center button to left of rightmost button
1760 11FA 38                    sec   
1761 11FB E5 6F                 sbc   <widest
1762 11FD E5 6F                 sbc   <widest
1763 11FF E9 0E 00              sbc   #14
1764 1202 80 07                 bra   @uneven
1765 1204
1766 1204 AF 56 11 02  @rightmost lda   >awTextRect+6          ;rightmost button aligned w/ right of window
1767 1208 38                    sec   
1768 1209 E5 6F                 sbc   <widest
1769 120B
1770 120B 83 01        @uneven  sta   1,s
1771 120D 68           @notUneven pla   
1772 120E
1773 120E 85 0B                 sta   <windRect+x1
1774 1210 65 6F                 adc   <widest
1775 1212 85 0F                 sta   <windRect+x2
1776 1214
1777 1214              *** Use NewControl2 to make our buttons
1778 1214 A5 09                 lda   <windRect
1779 1216 8D AD 15              sta   buttonRect
1780 1219 A5 0B                 lda   <windRect+2
1781 121B 8D AF 15              sta   buttonRect+2
1782 121E A5 0D                 lda   <windRect+4
1783 1220 8D B1 15              sta   buttonRect+4
1784 1223 A5 0F                 lda   <windRect+6
1785 1225 8D B3 15              sta   buttonRect+6
1786 1228
1787 1228 A0 02 00              ldy   #2
1788 122B B7 31                 lda   [<handle],y
1789 122D 85 37                 sta   <ptr+2
1790 122F 8D C3 15              sta   buttonTitle+2
1791 1232 A7 31                 lda   [<handle]
1792 1234 8D C1 15              sta   buttonTitle
1793 1237 85 35                 sta   <ptr
1794 1239
1795 1239 A5 33                 lda   <handle+2
1796 123B 2A                    rol   a
1797 123C 2A                    rol   a
1798 123D 29 01 00              and   #1
1799 1240 8D B9 15              sta   buttonFlags
1800 1243
1801 1243              *** compute the key equivalents
1802 1243 F0 07                 beq   @notDefault
1803 1245
1804 1245 20 CF 15              jsr   CheckForCancel
1805 1248 F0 32                 beq   @defaultCancel
1806 124A
1807 124A 80 35                 bra   @isDefault
1808 124C
1809 124C 20 CF 15     @notDefault jsr   CheckForCancel
1810 124F F0 26                 beq   @isCancel
1811 1251
1812 1251              *** see if this is the only button that starts with this letter
1813 1251 9C C9 15              stz   buttonKeyEquivs           ;anticipate that it's a duplicate
1814 1254
1815 1254 20 82 16              jsr   GetFirstNonBlank
1816 1257
1817 1257 20 36 16              jsr   upcase
1818 125A A2 00 00              ldx   #0
1819 125D CD 58 11              cmp   ButtonChars
1820 1260 D0 01                 bne   @key1
1821 1262 E8                    inx   
1822 1263 CD 5A 11     @key1    cmp   ButtonChars+2
1823 1266 D0 01                 bne   @key2
1824 1268 E8                    inx   
1825 1269 CD 5C 11     @key2    cmp   ButtonChars+4
1826 126C D0 01                 bne   @key3
1827 126E E8                    inx   
1828 126F CA           @key3    dex                            ;did we have exactly one match?
1829 1270 D0 15                 bne   @didKeys
1830 1272
1831 1272              ;;; NOTE--A is still the first non-blank character (uppercase)
1832 1272 20 1C 16              jsr   BuildKeyEquivs
1833 1275 80 0D                 bra   @setKeys
1834 1277
1835 1277 A9 1B 1B     @isCancel lda   #$1b1b
1836 127A 80 08                 bra   @setKeys
1837 127C
1838 127C A9 0D 1B     @defaultCancel lda   #$1b0d             ;Cancel *and* Return
1839 127F 80 03                 bra   @setKeys
1840 1281
1841 1281 A9 0D 0D     @isDefault lda   #$0d0d
1842 1284 8D C9 15     @setKeys sta   buttonKeyEquivs
1843 1287              @didKeys  
1844 1287 A5 71                 lda   <counter2
1845 1289 8D BD 15              sta   buttonRefcon
1846 128C
1847 128C 48                    pha   
1848 128D 48                    pha                            ;space for NewControl2 result
1849 128E D4 83                 pei   <alertWind+2
1850 1290 D4 81                 pei   <alertWind
1851 1292 F4 00 00              pea   0                        ;by pointer
1852 1295 F4 02 00 F4           pushlong #extButtonTemplate 
1853 129B A2 10 31 22           _NewControl2 
1854 12A2 68                    pla   
1855 12A3 FA                    plx   
1856 12A4 82 9D 00              brl   aroundTemplate
1857 12A7
1858 12A7 09 00        extButtonTemplate DC W:9                ;pCount
1859 12A9 00 00 00 00           DC L:0                         ;control ID
1860 12AD 00 00 00 00  buttonRect DC W:0,0,0,0                 ;rect
1861 12B5 00 00 00 80           DC L:$80000000                 ;procRef
1862 12B9 00 00        buttonFlags DC W:0
1863 12BB 00 30                 DC W:$3000                     ;moreFlags = fCtlWantEvents+fCtlProcNotPtr
1864 12BD 00 00 00 00  buttonRefCon DC L:0
1865 12C1 00 00 00 00  buttonTitle DC L:0
1866 12C5 00 00 00 00           DC L:0                         ;color table
1867 12C9 00 00        buttonKeyEquivs DC B:0,0                ;key equivalents
1868 12CB 00 00 00 00           DC W:0,0                       ;key modifiers
1869 12CF
1870 12CF
1871 12CF              *** CheckForCanel tolerates leading blanks and nonstandard case
1872 12CF A7 35        CheckForCancel lda   [<ptr]
1873 12D1 29 FF 00              and   #$00ff
1874 12D4 AA                    tax   
1875 12D5 A0 01 00              ldy   #1
1876 12D8 B7 35        @skipBlanks lda   [<ptr],y
1877 12DA 29 FF 00              and   #$00ff
1878 12DD C9 20 00              cmp   #$0020
1879 12E0 D0 04                 bne   @pastBlanks
1880 12E2 C8                    iny   
1881 12E3 CA                    dex   
1882 12E4 10 F2                 bpl   @skipBlanks
1883 12E6
1884 12E6              *** Allow localization (string is inline with padding for longer spellings)
1885 12E6 EC 0B 16     @pastBlanks cpx   theCancelString       ;compare against length
1886 12E9 90 1C                 bcc   @notCancel
1887 12EB A2 00 00              ldx   #0
1888 12EE B7 35        @compareLoop lda   [<ptr],y
1889 12F0 C8                    iny   
1890 12F1 29 DF 00              and   #$00df                   ;case insensitivity
1891 12F4 E2 20                 sep   #$20
1892 12F6 DD 0D 16              cmp   theCancelString+2,x
1893 12F9 C2 20                 rep   #$20
1894 12FB D0 0A                 bne   @notCancel
1895 12FD E8                    inx   
1896 12FE EC 0B 16              cpx   theCancelString
1897 1301 90 EB                 bcc   @compareLoop
1898 1303 A9 00 00              lda   #0                       ;BEQ
1899 1306 60                    rts   
1900 1307
1901 1307 A9 01 00     @notCancel lda   #1                     ;BNE
1902 130A 60                    rts   
1903 130B
1904 130B 06 00        theCancelString DC W:6                  ;Length of localizable Cancel string
1905 130D 43 41 4E 43           DC B:'CANCEL'
1906 1313 78 78 78 78           DC B:'xxxxxxxxx'               ;space for expansion
1907 131C
1908 131C
1909 131C 20 28 16     BuildKeyEquivs jsr   downcase
1910 131F 48                    pha   
1911 1320 20 36 16              jsr   upcase
1912 1323 EB                    xba   
1913 1324 03 01                 ora   1,s
1914 1326 FA                    plx   
1915 1327 60                    rts   
1916 1328
1917 1328 C9 41 00     downcase cmp   #$41
1918 132B 90 08                 bcc   @x
1919 132D C9 5B 00              cmp   #$5B
1920 1330 B0 03                 bcs   @x
1921 1332 09 20 00              ora   #$20
1922 1335 60           @x       rts   
1923 1336
1924 1336 C9 61 00     upcase   cmp   #$61
1925 1339 90 08                 bcc   @x
1926 133B C9 7B 00              cmp   #$7B
1927 133E B0 03                 bcs   @x
1928 1340 29 DF 00              and   #$00df
1929 1343 60           @x       rts   
1930 1344
1931 1344              aroundTemplate  
1932 1344
1933 1344 A4 33                 ldy   <handle+2                ;Was that the default button?
1934 1346 10 04                 bpl   next204
1935 1348
1936 1348 85 39                 sta   <ptr2                    ;Remember default button's handle.
1937 134A 86 3B                 stx   <ptr2+2
1938 134C
1939 134C E6 71        next204  inc   <counter2
1940 134E A5 6D                 lda   <buttCount
1941 1350 C5 71                 cmp   <counter2
1942 1352 90 03                 bcc   @blah
1943 1354 82 75 FE              brl   lop204
1944 1357              @blah     
1945 1357
1946 1357              *** 5-Nov-91 DAL -- if no button has a high-ascii key equivalent, disable key trans
1947 1357              ***  (It's restored at a very outer level of AlertWindow.)
1948 1357 AD 58 11              lda   ButtonChars
1949 135A 0D 5A 11              ora   ButtonChars+2
1950 135D 0D 5C 11              ora   ButtonChars+4
1951 1360 29 80 00              and   #$0080
1952 1363 D0 06                 bne   @someHighAscii
1953 1365
1954 1365 A9 00 00              lda   #0
1955 1368 20 12 11              jsr   mySetKeyTranslation
1956 136B              @someHighAscii  
1957 136B
1958 136B              ;
1959 136B              ; --- Draw buttons -------------------------------------------
1960 136B              ;
1961 136B D4 83                 pei   <alertWind+2             ;Draw buttons in alert.
1962 136D D4 81                 pei   <alertWind
1963 136F A2 10 10 22           _DrawControls 
1964 1376
1965 1376 D4 07                 pei   <alertStrgHand+2         ;Free compiled string.
1966 1378 D4 05                 pei   <alertStrgHand
1967 137A A2 02 10 22           _DisposeHandle 
1968 1381
1969 1381 60                    rts   
1970 1382
1971 1382              *
1972 1382              * GetFirstNonBlank
1973 1382              *
1974 1382              * Return A = first interesting character in PString at [ptr], for
1975 1382              * possible use as the button's key equivalent
1976 1382              *
1977 1382 A0 00 00     GetFirstNonBlank ldy   #0
1978 1385 E2 30        @search  sep   #$30
1979 1387 98                    tya   
1980 1388 C7 35                 cmp   [<ptr]
1981 138A C2 30                 rep   #$30
1982 138C A9 00 00              lda   #0
1983 138F B0 0B                 bcs   @done
1984 1391 C8                    iny   
1985 1392 B7 35                 lda   [<ptr],y
1986 1394 29 FF 00              and   #$00ff
1987 1397 C9 20 00              cmp   #$0020
1988 139A F0 E9                 beq   @search
1989 139C 60           @done    rts   
1990 139D
1991 139D              *
1992 139D              * DrawTheAWIcon
1993 139D              *
1994 139D              * Made this a subroutine so we can call it from the Update
1995 139D              *
1996 139D A5 7F        DrawTheAWIcon lda   <realDrawIconFlag
1997 139F D0 27                 bne   @drawIcon
1998 13A1
1999 13A1 A5 1F                 lda   <xxBounds+x2
2000 13A3 F0 22                 beq   @noIcon
2001 13A5
2002 13A5 A9 11 00              lda   #xxLocInfo               ;Pass pointer to parameter block.
2003 13A8 20 57 19              jsr   pushDpage
2004 13AB A9 19 00              lda   #xxBounds                ;Pass pointer to source RECT.
2005 13AE 20 57 19              jsr   pushDpage
2006 13B1 A9 04 00              lda   #4                       ;320 X position.
2007 13B4 A6 10                 ldx   <xxLocInfo-1             ;320 or 640 mode?
2008 13B6 10 01                 bpl   @store206
2009 13B8 0A                    asl   a                        ;640 x position.
2010 13B9 48           @store206 pha                           ;Pass X position.
2011 13BA F4 04 00              pea   4                        ;Pass Y position. 
2012 13BD F4 00 00              pea   0                        ;Pass mode (normal copy).
2013 13C0 A2 04 D6 22           _PPToPort                      ;Blit.
2014 13C7 60           @noIcon  rts   
2015 13C8
2016 13C8 D4 15        @drawIcon pei   <xxImage+2
2017 13CA D4 13                 pei   <xxImage
2018 13CC F4 00 00              pea   0                        ;mode
2019 13CF A9 04 00              lda   #4                       ;X=4 for 320
2020 13D2 A6 10                 ldx   <xxLocInfo-1
2021 13D4 10 01                 bpl   @320width
2022 13D6 0A                    asl   a                        ;X=8 for 640
2023 13D7 48           @320width pha   
2024 13D8 F4 04 00              pea   4                        ;Y is always 4
2025 13DB A2 12 0B 22           _DrawIcon 
2026 13E2 60                    rts   
2027 13E3
2028 13E3                       export DiskSwap640Hndl 
2029 13E3 00 00 00 00  DiskSwap640Hndl DC L:0
2030 13E7                       export DiskSwap320Hndl 
2031 13E7 00 00 00 00  DiskSwap320Hndl DC L:0
2032 13EB
2033 13EB              **********************************************************************
2034 13EB              *
2035 13EB              * FindUniqueCharacter -- input = handle on stack
2036 13EB              *
2037 13EB              * Output = <theNewSeparator (some character not present anywhere in
2038 13EB              *                            the string)
2039 13EB              *
2040 13EB              **********************************************************************
2041 13EB 0B           FindUniqueCharacter phd   
2042 13EC 48                    pha   
2043 13ED 48                    pha                            ;space for <thePtr
2044 13EE
2045 13EE 3B                    tsc   
2046 13EF 5B                    tcd   
2047 13F0
2048 13F0              @thePtr  equ   1
2049 13F0              @oldD    equ   @thePtr+4
2050 13F0              @rts     equ   @oldD+2
2051 13F0              @theString equ   @rts+2
2052 13F0
2053 13F0 48                    pha   
2054 13F1 48                    pha   
2055 13F2 D4 0B                 pei   <@theString+2
2056 13F4 D4 09                 pei   <@theString
2057 13F6 A2 02 18 22           _GetHandleSize 
2058 13FD
2059 13FD A0 02 00              ldy   #2
2060 1400 B7 09                 lda   [<@theString],y
2061 1402 85 03                 sta   <@thePtr+2
2062 1404 A7 09                 lda   [<@theString]
2063 1406 85 01                 sta   <@thePtr
2064 1408
2065 1408 A9 01 00              lda   #1                       ;start trying with Ctrl-A
2066 140B
2067 140B C2 20        @tryCharA rep   #$20
2068 140D 48                    pha   
2069 140E A3 03                 lda   3,s
2070 1410 A8                    tay   
2071 1411 88                    dey   
2072 1412 68                    pla   
2073 1413 E2 20                 sep   #$20
2074 1415
2075 1415 D7 01        @keepLooking cmp   [<@thePtr],y
2076 1417 F0 05                 beq   @tryNextChar
2077 1419 88                    dey   
2078 141A 10 F9                 bpl   @keepLooking
2079 141C 80 05                 bra   @foundIt
2080 141E
2081 141E 1A           @tryNextChar inc   a
2082 141F D0 EA                 bne   @tryCharA
2083 1421 A7 01                 lda   [<@thePtr]               ;if no unique characters, return unchanged
2084 1423
2085 1423 C2 20        @foundIt rep   #$20
2086 1425 29 FF 00              and   #$00ff
2087 1428
2088 1428 FA                    plx   
2089 1429 FA                    plx                            ;kill handle size
2090 142A FA                    plx   
2091 142B FA                    plx                            ;kill <thePtr
2092 142C 2B                    pld   
2093 142D 85 77                 sta   <theNewSeparator
2094 142F 60                    rts   
2095 1430
2096 1430              ; = = = = = = = = = = = = = = = = = = = = =
2097 1430              ;          Compile a text string.
2098 1430              ;800= = = = = = = = = = = = = = = = = = = =
2099 1430              ;
2100 1430              ;   IN:    a = maximum size of string.
2101 1430              ;          <alertStrg = pointer to string.
2102 1430              ;          <separator = text termination character.
2103 1430              ;          <terminate = alert string termination character.
2104 1430              ;          <DoingButtons = bit 15 set if we're parsing button text (DAL)
2105 1430              ;
2106 1430              ;  OUT:    <handle = handle of text string, high bit set if '>' found.
2107 1430              ;          <ptr = pointer to string (length byte first).
2108 1430              ;          <work = length of string.
2109 1430              ;          Carry set if end of alert string.
2110 1430              ;
2111 1430              compileStrg  
2112 1430
2113 1430              buffSize equ   1
2114 1430              ;
2115 1430 48                    pha                            ;Save buffer size.
2116 1431
2117 1431              ;
2118 1431              ; --- Allocate memory for text string ------------------------
2119 1431              ;
2120 1431 48                    pha                            ;Space for result.
2121 1432 48                    pha   
2122 1433 F4 00 00              pea   0                        ;Pass number of bytes to allocate.
2123 1436 48                    pha   
2124 1437 F4 0E 40              pea   $400e                    ;pass ID to use
2125 143A F4 10 C0              pea   $C010                    ;Pass attributes, fixed, in bank.
2126 143D 48                    pha                            ;Pass address (not used).
2127 143E 48                    pha   
2128 143F A2 02 09 22           _NewHandle 
2129 1446 68                    pla   
2130 1447 85 31                 sta   <handle
2131 1449 68                    pla   
2132 144A 85 33                 sta   <handle+2
2133 144C
2134 144C 20 8B 17              jsr   derefHand                ;ptr = (handle)
2135 144F
2136 144F E6 35                 inc   <ptr                     ;Start past length byte.
2137 1451 64 6B                 stz   <TheWork                 ;Start length counter.
2138 1453
2139 1453 68                    pla                            ;Adjust max buffer size for easy compare.
2140 1454 3A                    dec   a
2141 1455 48                    pha   
2142 1456              ;
2143 1456              ;
2144 1456              ; --- Compile text string ------------------------------------
2145 1456              ;
2146 1456 20 66 11     lop800   jsr   fetchChar
2147 1459
2148 1459              *** "^" is not special until we get to the button text
2149 1459 24 73                 bit   <DoingButtons            ;added 25-Nov-90 DAL
2150 145B 10 0C                 bpl   next802                  ;added 25-Nov-90 DAL
2151 145D C9 5E 00              cmp   #'^'                     ;Default character for buttons?
2152 1460 D0 07                 bne   next802
2153 1462
2154 1462 A9 00 80              lda   #$8000
2155 1465 04 33                 tsb   <handle+2
2156 1467 80 ED                 bra   lop800
2157 1469
2158 1469 C5 23        next802  cmp   <separator               ;End of this string?
2159 146B F0 10                 beq   exit800
2160 146D C5 21                 cmp   <terminate               ;End of line?
2161 146F F0 0D                 beq   exit801
2162 1471
2163 1471 87 35        store800 sta   [<ptr]                   ;Store character in text string.
2164 1473 E6 35                 inc   <ptr
2165 1475 E6 6B                 inc   <TheWork                 ;Length counter.
2166 1477
2167 1477 A5 6B                 lda   <TheWork                 ;Is buffer full?
2168 1479 C3 01                 cmp   buffSize,s
2169 147B 90 D9                 bcc   lop800
2170 147D              ; End line if buffer full.
2171 147D
2172 147D 18           exit800  clc                            ;Continue flag.
2173 147E              ;
2174 147E 20 8B 17     exit801  jsr   derefHand                ;ptr = (handle).
2175 1481              ;
2176 1481 E2 30                 sep   #$30                     ;Store length byte.
2177 1483 A5 6B                 lda   <TheWork
2178 1485 87 35                 sta   [<ptr]
2179 1487 C2 30                 rep   #$30
2180 1489              ;
2181 1489 68                    pla                            ;Get rid of buffer size.
2182 148A 60                    rts   
2183 148B              ;
2184 148B              ;
2185 148B              ; = = = = = = = = = = = = = = = = = = = =
2186 148B              ;          Dereference handle.
2187 148B              ; = = = = = = = = = = = = = = = = = = = =
2188 148B              ;
2189 148B A0 02 00     derefHand ldy   #2                      ;Dereference the handle.
2190 148E B7 31                 lda   [<handle],y
2191 1490 85 37                 sta   <ptr+2
2192 1492 A7 31                 lda   [<handle]
2193 1494 85 35                 sta   <ptr
2194 1496 60                    rts   
2195 1497              ;
2196 1497              ;
2197 1497              ; = = = = = = = = = = = = = = = = = =
2198 1497              ;          Monitor the alert.
2199 1497              ;900= = = = = = = = = = = = = = = = =
2200 1497              ;
2201 1497              ;   IN:    alertWind = window to monitor.
2202 1497              ;          ptr2 = handle of default button, ptr2+1 = zero if none.
2203 1497              ;
2204 1497 00 00 00 00  bigRect  DC W:0,0,1000,1000
2205 149F
2206 149F A9 04 80     monitor  lda   #%1000000000000100
2207 14A2 85 51                 sta   <taskRec+TaskMask
2208 14A4 A9 03 00              lda   #%0000000000000011       ;tmControlKey+tmContentControls
2209 14A7 85 53                 sta   <taskRec+TaskMask+2
2210 14A9
2211 14A9 F4 02 00 F4           pushlong #bigRect 
2212 14AF A2 0E 3C 22           _ValidRect 
2213 14B6
2214 14B6 A5 96                 lda   <strgType
2215 14B8 29 40 00              and   #alertSkipScanBit
2216 14BB D0 03                 bne   @skipInitialScan
2217 14BD 20 31 19              jsr   PollForInsertion
2218 14C0              @skipInitialScan  
2219 14C0
2220 14C0 20 FC 18     poll900  jsr   PostReturnOnInsertion
2221 14C3 48                    pha                            ;Space for result.
2222 14C4 F4 6E 0E              pea   $0E6E                    ;Mouse Up+Down, keys, switch, deskAcc, driver, update
2223 14C7 20 54 19              jsr   pushTask                 ;Pass pointer to Task record.
2224 14CA A2 0E 1D 22           _TaskMaster 
2225 14D1 68                    pla   
2226 14D2 F0 EC                 beq   poll900
2227 14D4
2228 14D4 0A                    asl   a                        ;strip off system-window bit
2229 14D5 4A                    lsr   a
2230 14D6
2231 14D6              ;
2232 14D6              ; --- Handle event ----------------------------------------------------
2233 14D6              ;
2234 14D6 C9 06 00              cmp   #6                       ;update event? (DAL)
2235 14D9 D0 43                 bne   @notUpdate
2236 14DB
2237 14DB 48                    pha   
2238 14DC 48                    pha   
2239 14DD A2 0E 15 22           _FrontWindow 
2240 14E4 FA                    plx   
2241 14E5 68                    pla   
2242 14E6 C5 41                 cmp   <taskRec+4
2243 14E8 D0 12                 bne   @notMyUpdate
2244 14EA E4 3F                 cpx   <taskRec+2
2245 14EC D0 0E                 bne   @notMyUpdate
2246 14EE F4 00 00              pea   0                        ;UpdateWindow flags (19-Jun-92 DAL)
2247 14F1 48                    pha   
2248 14F2 DA                    phx   
2249 14F3              *** added 6-Mar-92 DAL -- use UpdateWindow
2250 14F3              ;	_UpdateWindow
2251 14F3 A2 0E 6C              ldx   #$6c0e
2252 14F6 22 00 00 E1           jsl   $e10000
2253 14FA              ;	pha
2254 14FA              ;	phx
2255 14FA              ;	_BeginUpdate
2256 14FA              ;	jsl	UpdateGuts
2257 14FA              ;	_EndUpdate
2258 14FA              *** end 6-Mar-92
2259 14FA 80 C4                 bra   poll900
2260 14FC
2261 14FC              *** 19-Jun-92 DAL -- update other people's windows!
2262 14FC AF 84 0D 02  @notMyUpdate lda   >WindowUpdateCount   ;so GS/OS won't call AlertWindow!
2263 1500 1A                    inc   a
2264 1501 8F 84 0D 02           sta   >WindowUpdateCount
2265 1505
2266 1505 F4 00 80              pea   $8000                    ;window knows about bank register
2267 1508 D4 41                 pei   <taskRec+4
2268 150A D4 3F                 pei   <taskRec+2
2269 150C              ;	_UpdateWindow
2270 150C A2 0E 6C              ldx   #$6C0E
2271 150F 22 00 00 E1           jsl   $e10000
2272 1513
2273 1513 AF 84 0D 02           lda   >WindowUpdateCount
2274 1517 3A                    dec   a
2275 1518 8F 84 0D 02           sta   >WindowUpdateCount
2276 151C
2277 151C 80 A2                 bra   poll900
2278 151E              *** end 19-Jun-92
2279 151E
2280 151E C9 21 00     @notUpdate cmp   #wInControl
2281 1521 D0 12                 bne   next900
2282 1523
2283 1523 A5 5B        enter899 lda   <taskRec+taskData2       ;Handle of selected button.
2284 1525 A6 5D                 ldx   <taskRec+taskData2+2
2285 1527
2286 1527 48           enter900 pha                            ;Space for result.
2287 1528 48                    pha   
2288 1529 DA                    phx                            ;Pass handle of selected control.
2289 152A 48                    pha   
2290 152B A2 10 23 22           _GetCtlRefCon                  ;Get control's refCon.
2291 1532 68                    pla                            ;Control's ID number.
2292 1533 FA                    plx   
2293 1534 60                    rts   
2294 1535              ;
2295 1535              ; --- Handle key event ---------------------------------------
2296 1535              ;
2297 1535 C9 03 00     next900  cmp   #wInKey                  ;Key?
2298 1538 F0 05                 beq   doKey
2299 153A C9 05 00              cmp   #wInAutoKey
2300 153D D0 35                 bne   notKey
2301 153F
2302 153F A5 3F        doKey    lda   <taskRec+message
2303 1541 C9 2E 00              cmp   #$2e                     ;period
2304 1544 D0 28                 bne   @notApplePeriod
2305 1546 A5 4B                 lda   <taskRec+oModifiers
2306 1548 29 00 01              and   #$0100                   ;Apple key?
2307 154B F0 21                 beq   @notApplePeriod
2308 154D
2309 154D A9 1B 00              lda   #$1b
2310 1550 85 3F                 sta   <taskRec+message         ;turn it into an ESC
2311 1552 64 4B                 stz   <taskRec+oModifiers
2312 1554
2313 1554 48                    pha   
2314 1555 F4 00 00              pea   0                        ;target-only flag
2315 1558 48                    pha   
2316 1559 48                    pha   
2317 155A A2 0E 15 22           _FrontWindow 
2318 1561 20 54 19              jsr   pushTask
2319 1564 A2 10 29 22           _SendEventToCtl 
2320 156B 68                    pla   
2321 156C D0 B5                 bne   enter899
2322 156E
2323 156E F4 08 00     @notApplePeriod pea   $0008
2324 1571 82 45 00              brl   BonkNoisePushed          ;27-Mar-91 DAL
2325 1574
2326 1574 C9 1B 00     notKey   cmp   #wInFrame
2327 1577 F0 3D                 beq   BonkNoise
2328 1579
2329 1579 C9 14 00              cmp   #wInDrag
2330 157C F0 38                 beq   BonkNoise
2331 157E
2332 157E C9 11 00              cmp   #wInMenuBar
2333 1581 F0 33                 beq   BonkNoise
2334 1583
2335 1583 C9 10 00              cmp   #wInDesk
2336 1586 F0 2E                 beq   BonkNoise
2337 1588
2338 1588 C9 18 00              cmp   #wInInfo
2339 158B F0 29                 beq   BonkNoise
2340 158D
2341 158D C9 15 00              cmp   #wInGrow
2342 1590 F0 24                 beq   BonkNoise
2343 1592
2344 1592 C9 17 00              cmp   #wInZoom
2345 1595 F0 1F                 beq   BonkNoise
2346 1597
2347 1597 C9 16 00              cmp   #wInGoAway
2348 159A F0 1A                 beq   BonkNoise
2349 159C
2350 159C C9 13 00              cmp   #wInContent
2351 159F D0 1F                 bne   notContent
2352 15A1
2353 15A1 48                    pha   
2354 15A2 48                    pha   
2355 15A3 A2 0E 15 22           _FrontWindow 
2356 15AA FA                    plx   
2357 15AB 68                    pla   
2358 15AC C5 4F                 cmp   <taskRec+TaskData+2
2359 15AE D0 06                 bne   BonkNoise
2360 15B0 E4 4D                 cpx   <taskRec+TaskData
2361 15B2 D0 02                 bne   BonkNoise                ;bonk for any other window
2362 15B4 80 0A                 bra   goNextEvent
2363 15B6
2364 15B6 F4 04 00     BonkNoise pea   $0004
2365 15B9 A2 03 38 22  BonkNoisePushed _SysBeep2 
2366 15C0              notContent  
2367 15C0 82 FD FE     goNextEvent brl   poll900
2368 15C3
2369 15C3
2370 15C3              **********************************************************************
2371 15C3              *
2372 15C3              * UpdateGuts
2373 15C3              *
2374 15C3              * Draw the contents of the alert window
2375 15C3              *
2376 15C3              **********************************************************************
2377 15C3 0B           UpdateGuts phd   
2378 15C4 A9 77 77     DirPageCheat lda   #$7777               ;*** modified ***
2379 15C7 5B                    tcd   
2380 15C8
2381 15C8 AF 4C 11 02           pushlong >awTextPtr 
2382 15D2 AF 4E 11 02           pushword >awTextLen 
2383 15D7 F4 02 00 F4           pushlong #awTextRect 
2384 15DD F4 00 00              pea   0                        ;left justify
2385 15E0 A2 14 20 22           _LETextBox2 
2386 15E7
2387 15E7 20 9D 16              jsr   DrawTheAWIcon            ;requires our local direct page
2388 15EA
2389 15EA 48                    pha   
2390 15EB 48                    pha   
2391 15EC A2 04 1C 22           _GetPort 
2392 15F3 A2 10 10 22           _DrawControls 
2393 15FA
2394 15FA 2B                    pld   
2395 15FB 6B                    rtl   
2396 15FC
2397 15FC
2398 15FC              **********************************************************************
2399 15FC              *
2400 15FC              * PostReturnOnInsertion
2401 15FC              *
2402 15FC              * Check for a disk insertion, and post a Return keypress if we
2403 15FC              * actually find that something was inserted.
2404 15FC              *
2405 15FC              **********************************************************************
2406 15FC              PostReturnOnInsertion  
2407 15FC
2408 15FC 48                    pha   
2409 15FD 48                    pha   
2410 15FE A2 06 10 22           _TickCount 
2411 1605 68                    pla   
2412 1606 FA                    plx   
2413 1607 A8                    tay   
2414 1608 38                    sec   
2415 1609 EF 2F 19 02           sbc   >previousTickCount
2416 160D C9 28 00              cmp   #40                      ;every 40 ticks
2417 1610 90 1C                 bcc   @notPollTime
2418 1612 98                    tya   
2419 1613 8F 2F 19 02           sta   >previousTickCount
2420 1617
2421 1617 20 31 19              jsr   PollForInsertion
2422 161A B0 12                 bcs   @nothingInserted
2423 161C
2424 161C 48                    pha                            ;space for result
2425 161D F4 03 00              pea   3                        ;keyDown event
2426 1620 F4 00 00              pea   0
2427 1623 F4 0D 00              pea   $000D
2428 1626 A2 06 14 22           _PostEvent 
2429 162D 68                    pla   
2430 162E
2431 162E              @nothingInserted  
2432 162E 60           @notPollTime rts   
2433 162F
2434 162F 00 00        previousTickCount DC W:0
2435 1631
2436 1631
2437 1631              **********************************************************************
2438 1631              *
2439 1631              * PollForInsertion
2440 1631              *
2441 1631              * If it's been long enough, check for a disk insertion and return
2442 1631              * CLC+device number in A if something was inserted
2443 1631              *
2444 1631              * The DO_INSERT_SCAN service scans *all* the devices and then tells
2445 1631              * us about the first insertion it detected.  This is good for two
2446 1631              * things:
2447 1631              *
2448 1631              * 1. We can call PollForInsertion *once* to ignore all pending inserts.
2449 1631              * 2. When a CD with multiple partitions is inserted, we only find out
2450 1631              *    about it once.
2451 1631              *
2452 1631              **********************************************************************
2453 1631 38           PollForInsertion sec   
2454 1632 A5 75                 lda   <diskInsertFlag
2455 1634 F0 13                 beq   @dontScan
2456 1636
2457 1636              *** If we're sharing stack with GS/OS, don't poll!  If there was enough
2458 1636              *** memory in bank 0, we'll be using our own stack at this point.
2459 1636 3B                    tsc   
2460 1637 C9 00 BD              cmp   #$bd00
2461 163A B0 0D                 bcs   @dontScan                ;leave with carry set, no insertion
2462 163C
2463 163C 48                    pha   
2464 163D A2 03 3D 22           _ScanDevices 
2465 1644 68                    pla   
2466 1645
2467 1645 18                    clc   
2468 1646 D0 01                 bne   @gotSomething
2469 1648 38                    sec   
2470 1649              @gotSomething  
2471 1649
2472 1649 60           @dontScan rts   
2473 164A
2474 164A
2475 164A              ; = = = = = = = = = = = = = = = = = = = =
2476 164A              ;          Push a direct page
2477 164A              ;          address on the stack.
2478 164A              ; = = = = = = = = = = = = = = = = = = = =
2479 164A              ;
2480 164A              ;   IN:    a = direct page offset.
2481 164A              ;
2482 164A A9 31 00     pushHandle lda   #handle
2483 164D 80 08                 bra   pushDpage
2484 164F
2485 164F A9 6B 00     pushrect2 lda   #rect2
2486 1652 80 03                 bra   pushDpage
2487 1654
2488 1654 A9 3D 00     pushTask lda   #taskRec
2489 1657 FA           pushDpage plx   
2490 1658 F4 00 00              pea   0
2491 165B 48                    pha   
2492 165C 7B                    tdc   
2493 165D 18                    clc   
2494 165E 63 01                 adc   1,s
2495 1660 83 01                 sta   1,s
2496 1662 DA                    phx   
2497 1663 60                    rts   
2498 1664
2499 1664              ;
2500 1664              ; --- Task Master return codes -------------------------------
2501 1664              ;
2502 1664              wInKey   equ   3
2503 1664              wInAutoKey equ   5
2504 1664
2505 1664              ;
2506 1664              ; --- Alert window default sizes -----------------------------
2507 1664              ;
2508 1664              MaxString equ   1001                    Maximum length of alert text.
2509 1664              MaxButtStrg equ   81                    Maximum length of button string.
2510 1664              minWidth320 equ   30                    Minimum button width in 320 mode.
2511 1664              minWidth640 equ   60                    Minimum button width in 640 mode.
2512 1664
2513 1664              TextTop  equ   3                        Y position of first line of text.
2514 1664
2515 1664 2E 00        heights320 DC W:46                      1
2516 1666 3E 00                 DC W:62                        2
2517 1668 3E 00                 DC W:62                        3
2518 166A 5A 00                 DC W:90                        4
2519 166C 36 00                 DC W:54                        5
2520 166E 3E 00                 DC W:62                        6
2521 1670 50 00                 DC W:80                        7
2522 1672 6C 00                 DC W:108                       8
2523 1674 86 00                 DC W:134                       9
2524 1676
2525 1676 2E 00        heights640 DC W:46                      1
2526 1678 36 00                 DC W:54                        2
2527 167A 3E 00                 DC W:62                        3
2528 167C 48 00                 DC W:72                        4
2529 167E 2E 00                 DC W:46                        5
2530 1680 36 00                 DC W:54                        6
2531 1682 3E 00                 DC W:62                        7
2532 1684 48 00                 DC W:72                        8
2533 1686 50 00                 DC W:80                        9
2534 1688
2535 1688 98 00        widths320 DC W:152                      1
2536 168A B0 00                 DC W:176                       2
2537 168C FC 00                 DC W:252                       3
2538 168E FC 00                 DC W:252                       4
2539 1690 FC 00                 DC W:252                       5
2540 1692 2C 01                 DC W:300                       6
2541 1694 2C 01                 DC W:300                       7
2542 1696 2C 01                 DC W:300                       8
2543 1698 2C 01                 DC W:300                       9
2544 169A
2545 169A C8 00        widths640 DC W:200                      1
2546 169C E4 00                 DC W:228                       2
2547 169E 2C 01                 DC W:300                       3
2548 16A0 60 01                 DC W:352                       4
2549 16A2 90 01                 DC W:400                       5
2550 16A4 C4 01                 DC W:452                       6
2551 16A6 F4 01                 DC W:500                       7
2552 16A8 28 02                 DC W:552                       8
2553 16AA 58 02                 DC W:600                       9
2554 16AC
2555 16AC              ;
2556 16AC              ; --- New window parameter list offsets ----------------------------
2557 16AC              ;
2558 16AC              p_length equ   0                        Number of bytes in parameter list.
2559 16AC              p_wframe equ   p_length+2               Type of window, frame flags.
2560 16AC              p_wtitle equ   p_wframe+2               Pointer to window's title.
2561 16AC              p_wrefCon equ   p_wtitle+4              Reserved for application.
2562 16AC              p_wfull  equ   p_wrefCon+4              Size of window, used with ZoomWindow.
2563 16AC              p_wcolor equ   p_wfull+8                Pointer to window's color table.
2564 16AC              p_y_origin equ   p_wcolor+4             Content's vertical offset.
2565 16AC              p_x_origin equ   p_y_origin+2           Content's horizontal offset.
2566 16AC              p_data_h equ   p_x_origin+2             Height of total data area.
2567 16AC              p_data_w equ   p_data_h+2               Width of total data area.
2568 16AC              p_wmaxheight equ   p_data_w+2
2569 16AC              p_wmaxwidth equ   p_wmaxheight+2
2570 16AC              p_vscroll equ   p_wmaxwidth+2           Amount to scroll vertically (arrows).
2571 16AC              p_hscroll equ   p_vscroll+2             Amount to scroll horizonally (arrows).
2572 16AC              p_vpage  equ   p_hscroll+2              Amount to page vertically (page region).
2573 16AC              p_hpage  equ   p_vpage+2                Amount to page horizontally (page rgn).
2574 16AC              p_wInfoText equ   p_hpage+2
2575 16AC              p_wInfoH equ   p_wInfoText+4            Height of infomation bar.
2576 16AC              p_wdefProc equ   p_wInfoH+2             NOT USED.
2577 16AC              p_wInfoDraw equ   p_wdefProc+4          Address of routine to draw Info Bar.
2578 16AC              p_updateDraw equ   p_wInfoDraw+4        Address of routine to draw content region.
2579 16AC              p_position equ   p_updateDraw+4
2580 16AC              p_behind equ   p_position+8
2581 16AC              p_windrec equ   p_behind+4
2582 16AC              p_size   equ   p_windrec+4
2583 16AC
2584 16AC                       ENDP 
2585 16AC
2586 16AC
2587 16AC              **********************************************************************
2588 16AC              *
2589 16AC              * $630E GetAuxWindInfo -- new call 19-Jan-91 DAL
2590 16AC              *
2591 16AC              * Input:
2592 16AC              *   space for result (LONG)
2593 16AC              *   window pointer   (LONG)
2594 16AC              *
2595 16AC              * Uses <auxInfoHandle on Window Manager direct page.  If it's NIL,
2596 16AC              * we allocate it for the first time.
2597 16AC              *
2598 16AC              * If we don't find the window we're looking for, we need to grow the
2599 16AC              * handle to make more room.
2600 16AC              *
2601 16AC              * The AuxWindHandle block has this structure:
2602 16AC              *   +000: number of aux window record that will fit in the handle
2603 16AC              *   +002: number of aux window records really in the list
2604 16AC              *   +004: first record
2605 16AC              *   +xxx: ...
2606 16AC              * Each record has the form:
2607 16AC              *   -004:window pointer
2608 16AC              *   +000:size in bytes
2609 16AC              *   +002:bank register value (low byte of word)
2610 16AC              *   +004:data register value
2611 16AC              *   +006:resource app value
2612 16AC              *   +008:old update region handle
2613 16AC              *   +012:old port (for EndUpdate)
2614 16AC              *   +016:window layer (for Windoid support) (LONG)
2615 16AC              *   +020:min vertical size for window (used only for system windows?)
2616 16AC              *   +022:min horizontal size for window (used only for system windows?)
2617 16AC              *   +024:NDA Structure Pointer (points to what's handy for the Desk Mgr)
2618 16AC              *   +028:(size of record)
2619 16AC              *
2620 16AC              **********************************************************************
2621 16AC              GetAuxWindInfo proc export 
2622 16AC                       export KillAuxInfoRecord 
2623 16AC                       export DerefMyhandle 
2624 16AC                       export IncResultBy4 
2625 16AC
2626 16AC              auxWindRecSize equ   28+4               ;size includes window pointer
2627 16AC              auxWindUserSize equ   28                ;34 bytes in the user-visible area
2628 16AC              GrowByNWindows equ   5                  ;grow the list 10 windows at a time
2629 16AC
2630 16AC              DirPagePtr equ   1
2631 16AC              myPtr    equ   DirPagePtr+4
2632 16AC              myHandle equ   myPtr+4
2633 16AC              oldD     equ   myHandle+4
2634 16AC              rtl      equ   oldD+2
2635 16AC              windPtr  equ   rtl+6
2636 16AC              result   equ   windPtr+4
2637 16AC
2638 16AC 0B                    phd   
2639 16AD 48                    pha   
2640 16AE 48                    pha                            ;space for myHandle
2641 16AF 48                    pha   
2642 16B0 48                    pha                            ;space for myPtr
2643 16B1 5A                    phy   
2644 16B2 48                    pha                            ;push direct-page pointer on stack frame
2645 16B3 3B                    tsc   
2646 16B4 5B                    tcd   
2647 16B5
2648 16B5 64 1B                 stz   <result+2
2649 16B7 64 19                 stz   <result
2650 16B9 20 7C 1A              jsr   GetAuxPointer
2651 16BC
2652 16BC A0 02 00              ldy   #2
2653 16BF B7 05                 lda   [<myPtr],y               ;number of entries in the list
2654 16C1 F0 2F                 beq   @noMatch
2655 16C3 AA                    tax                            ;keep the count in X
2656 16C4
2657 16C4 A0 04 00              ldy   #4
2658 16C7 B7 05        @scan    lda   [<myPtr],y
2659 16C9 C8                    iny   
2660 16CA C8                    iny   
2661 16CB C5 15                 cmp   <windPtr
2662 16CD D0 18                 bne   @tryNext
2663 16CF B7 05                 lda   [<myPtr],y
2664 16D1 C5 17                 cmp   <windPtr+2
2665 16D3 D0 12                 bne   @tryNext
2666 16D5 C8                    iny   
2667 16D6 C8                    iny   
2668 16D7 98                    tya   
2669 16D8 18                    clc   
2670 16D9 65 05                 adc   <myPtr
2671 16DB 85 19                 sta   <result
2672 16DD A5 07                 lda   <myPtr+2
2673 16DF 90 01                 bcc   @1
2674 16E1 1A                    inc   a
2675 16E2 85 1B        @1       sta   <result+2
2676 16E4 82 84 00              brl   @exit
2677 16E7
2678 16E7 88           @tryNext dey   
2679 16E8 88                    dey   
2680 16E9 98                    tya   
2681 16EA 18                    clc   
2682 16EB 69 20 00              adc   #auxWindRecSize
2683 16EE A8                    tay   
2684 16EF CA                    dex   
2685 16F0 D0 D5                 bne   @scan
2686 16F2
2687 16F2              *
2688 16F2              * No matching entry found--allocate another one, clean it out, and return
2689 16F2              * the pointer.
2690 16F2              *
2691 16F2              * May need to grow the handle to make room.
2692 16F2              *
2693 16F2 A0 02 00     @noMatch ldy   #2
2694 16F5 B7 05                 lda   [<myPtr],y               ;number of entries in list
2695 16F7 C7 05                 cmp   [<myPtr]                 ;equal to number that will fit?
2696 16F9 90 32                 bcc   @itFits
2697 16FB
2698 16FB 48                    pha   
2699 16FC 48                    pha                            ;space for _Multiply result
2700 16FD 18                    clc   
2701 16FE A7 05                 lda   [<myPtr]
2702 1700 69 05 00              adc   #GrowByNWindows
2703 1703 87 05                 sta   [<myPtr]
2704 1705 48                    pha   
2705 1706 F4 20 00              pea   auxWindRecSize
2706 1709 A2 0B 09 22           _Multiply 
2707 1710              *** added 28-Feb-91 DAL--Oops, I forgot to add 4 for the header stuff
2708 1710 68                    pla   
2709 1711 FA                    plx   
2710 1712              ;	clc		;carry is already clear
2711 1712 69 04 00              adc   #4
2712 1715 90 01                 bcc   @coolBeans
2713 1717 E8                    inx   
2714 1718 DA           @coolBeans phx   
2715 1719 48                    pha   
2716 171A              *** end of 28-Feb-91 DAL
2717 171A
2718 171A D4 0B                 pei   <myHandle+2
2719 171C D4 09                 pei   <myHandle
2720 171E A2 02 19 22           _SetHandleSize                 ;this had better work....
2721 1725
2722 1725 20 CD 1A              jsr   DerefMyHandle            ;maybe it moved when we grew it
2723 1728
2724 1728 A0 02 00              ldy   #2
2725 172B B7 05                 lda   [<myPtr],y               ;get entry count back in A
2726 172D 1A           @itFits  inc   a
2727 172E 97 05                 sta   [<myPtr],y               ;increment count of entries in list
2728 1730
2729 1730 48                    pha   
2730 1731 48                    pha                            ;space for _Multiply result
2731 1732 3A                    dec   a
2732 1733 48                    pha                            ;zero-based index to new entry
2733 1734 F4 20 00              pea   auxWindRecSize
2734 1737 A2 0B 09 22           _Multiply 
2735 173E 18                    clc   
2736 173F 68                    pla   
2737 1740 65 05                 adc   <myPtr
2738 1742 85 19                 sta   <result
2739 1744 68                    pla   
2740 1745 65 07                 adc   <myPtr+2
2741 1747 85 1B                 sta   <result+2
2742 1749
2743 1749 20 D9 1A              jsr   IncResultBy4
2744 174C
2745 174C A5 15                 lda   <windPtr
2746 174E 87 19                 sta   [<result]
2747 1750 A0 02 00              ldy   #2
2748 1753 A5 17                 lda   <windPtr+2
2749 1755 97 19                 sta   [<result],y
2750 1757
2751 1757 20 D9 1A              jsr   IncResultBy4
2752 175A
2753 175A A9 00 00              lda   #0
2754 175D A0 1A 00              ldy   #auxWindUserSize-2       ;oops, was auxWindRecSize! 3-Mar-91 DAL
2755 1760 97 19        @clear   sta   [<result],y
2756 1762 88                    dey   
2757 1763 88                    dey   
2758 1764 D0 FA                 bne   @clear
2759 1766 A9 1C 00              lda   #auxWindUserSize
2760 1769 87 19                 sta   [<result]                ;set up the user-visible record size word
2761 176B
2762 176B 68           @exit    pla   
2763 176C 68                    pla                            ;pulled direct-page pointer
2764 176D 68                    pla   
2765 176E 68                    pla                            ;pulled myPtr
2766 176F 68                    pla   
2767 1770 68                    pla                            ;pulled myHandle
2768 1771 2B                    pld                            ;restored D
2769 1772 A2 00 00              ldx   #0
2770 1775 A0 04 00              ldy   #4
2771 1778 5C 84 01 E1           jml   $e10184                  ;ToStrip
2772 177C
2773 177C              *
2774 177C              * GetAuxPointer -- allocate the AuxInfoHandle if necessary, and return
2775 177C              *   myHandle, myPtr.
2776 177C              *
2777 177C A0 EB 00     GetAuxPointer ldy   #AuxInfoHandle+1
2778 177F B7 01                 lda   [<DirPagePtr],y
2779 1781 D0 39                 bne   @allocated
2780 1783
2781 1783 48                    pha   
2782 1784 48                    pha                            ;space for handle
2783 1785 F4 00 00              pea   0
2784 1788 F4 A4 00              pea   GrowByNWindows*auxWindRecSize+4
2785 178B A0 DC 00              ldy   #MyID
2786 178E B7 01                 lda   [<DirPagePtr],y
2787 1790 48                    pha                            ;mem id
2788 1791 F4 00 00              pea   0                        ;attributes
2789 1794 48                    pha   
2790 1795 48                    pha                            ;location unused
2791 1796 A2 02 09 22           _NewHandle 
2792 179D 68                    pla   
2793 179E A0 EA 00              ldy   #AuxInfoHandle
2794 17A1 97 01                 sta   [<DirPagePtr],y
2795 17A3 85 09                 sta   <myHandle
2796 17A5 68                    pla   
2797 17A6 C8                    iny   
2798 17A7 C8                    iny   
2799 17A8 97 01                 sta   [<DirPagePtr],y
2800 17AA 85 0B                 sta   <myHandle+2
2801 17AC
2802 17AC              *** Initialize the new handle
2803 17AC 20 CD 1A              jsr   DerefMyHandle
2804 17AF A9 05 00              lda   #GrowByNWindows          ;init the how-many-fit field
2805 17B2 87 05                 sta   [<myPtr]
2806 17B4 A0 02 00              ldy   #2
2807 17B7 A9 00 00              lda   #0                       ;init the how-many-there-are field
2808 17BA 97 05                 sta   [<myPtr],y
2809 17BC
2810 17BC A0 EA 00     @allocated ldy   #AuxInfoHandle
2811 17BF B7 01                 lda   [<DirPagePtr],y
2812 17C1 85 09                 sta   <myHandle
2813 17C3 C8                    iny   
2814 17C4 C8                    iny   
2815 17C5 B7 01                 lda   [<DirPagePtr],y
2816 17C7 85 0B                 sta   <myHandle+2
2817 17C9 20 CD 1A              jsr   DerefMyHandle
2818 17CC 60                    rts   
2819 17CD
2820 17CD A0 02 00     DerefMyHandle ldy   #2
2821 17D0 A7 09                 lda   [<myHandle]
2822 17D2 85 05                 sta   <myPtr
2823 17D4 B7 09                 lda   [<myHandle],y
2824 17D6 85 07                 sta   <myPtr+2
2825 17D8 60                    rts   
2826 17D9
2827 17D9 18           IncResultBy4 clc   
2828 17DA A5 19                 lda   <result
2829 17DC 69 04 00              adc   #4
2830 17DF 85 19                 sta   <result
2831 17E1 90 02                 bcc   @1
2832 17E3 E6 1B                 inc   <result+2
2833 17E5 60           @1       rts   
2834 17E6
2835 17E6              **********************************************************************
2836 17E6              *
2837 17E6              * KillAuxInfoRecord -- new subroutine 20-Jan-91 DAL
2838 17E6              *
2839 17E6              * Input:
2840 17E6              *   PUSH Window Pointer (LONG)
2841 17E6              *   JSL KillAuxInfoRecord
2842 17E6              *
2843 17E6              * (This is a subroutine, not a tool call)
2844 17E6              *
2845 17E6              * Direct page must be set to the Window Manager
2846 17E6              *
2847 17E6              **********************************************************************
2848 17E6              KillAuxInfoRecord  
2849 17E6
2850 17E6              @DirPagePtr equ   1
2851 17E6              @myPtr   equ   @DirPagePtr+4
2852 17E6              @myHandle equ   @myPtr+4
2853 17E6              @oldD    equ   @myHandle+4
2854 17E6              @rtl     equ   @oldD+2
2855 17E6              @windPtr equ   @rtl+3
2856 17E6
2857 17E6 0B                    phd   
2858 17E7 48                    pha   
2859 17E8 48                    pha                            ;space for myHandle
2860 17E9 48                    pha   
2861 17EA 48                    pha                            ;space for myPtr
2862 17EB F4 00 00              pea   0
2863 17EE 0B                    phd                            ;push direct-page pointer on stack frame
2864 17EF 3B                    tsc   
2865 17F0 5B                    tcd   
2866 17F1
2867 17F1 20 7C 1A              jsr   GetAuxPointer            ;creates it if necessary
2868 17F4 A0 02 00              ldy   #2
2869 17F7 B7 05                 lda   [<myPtr],y
2870 17F9 F0 1D                 beq   @exit                    ;no aux window records--just leave
2871 17FB AA                    tax   
2872 17FC A0 04 00              ldy   #4                       ;offset to first record
2873 17FF B7 05        @scan    lda   [<myPtr],y
2874 1801 C8                    iny   
2875 1802 C8                    iny   
2876 1803 C5 12                 cmp   @windPtr
2877 1805 D0 06                 bne   @tryNext
2878 1807 B7 05                 lda   [<myPtr],y
2879 1809 C5 14                 cmp   @windPtr+2
2880 180B F0 1D                 beq   @foundIt
2881 180D 88           @tryNext dey   
2882 180E 88                    dey   
2883 180F 98                    tya   
2884 1810 18                    clc   
2885 1811 69 20 00              adc   #auxWindRecSize
2886 1814 A8                    tay   
2887 1815 CA                    dex   
2888 1816 D0 E7                 bne   @scan
2889 1818
2890 1818 68           @exit    pla   
2891 1819 68                    pla                            ;pulled direct-page pointer
2892 181A 68                    pla   
2893 181B 68                    pla                            ;pulled myPtr
2894 181C 68                    pla   
2895 181D 68                    pla                            ;pulled myHandle
2896 181E 2B                    pld                            ;restored D
2897 181F A3 02                 lda   2,s
2898 1821 83 06                 sta   2+4,s
2899 1823 A3 01                 lda   1,s
2900 1825 83 05                 sta   1+4,s
2901 1827 68                    pla   
2902 1828 68                    pla   
2903 1829 6B                    rtl   
2904 182A              *
2905 182A              * Found the matching aux window record at myPtr+Y.  Squish
2906 182A              * the rest of them in and decrement the total count.
2907 182A              *
2908 182A 88           @foundIt dey   
2909 182B 88                    dey   
2910 182C 98                    tya   
2911 182D 18                    clc   
2912 182E 69 20 00              adc   #auxWindRecSize
2913 1831 8F 72 1B 02           sta   >@minusSize
2914 1835 65 05                 adc   <myPtr
2915 1837 AA                    tax   
2916 1838 A5 07                 lda   <myPtr+2
2917 183A 69 00 00              adc   #0
2918 183D 48                    pha   
2919 183E DA                    phx                            ;pushed pointer to the next record
2920 183F
2921 183F 18                    clc   
2922 1840 98                    tya   
2923 1841 65 05                 adc   <myPtr
2924 1843 AA                    tax   
2925 1844 A5 07                 lda   <myPtr+2
2926 1846 69 00 00              adc   #0
2927 1849 48                    pha   
2928 184A DA                    phx   
2929 184B
2930 184B 48                    pha   
2931 184C 48                    pha                            ;space for GetHandleSize
2932 184D D4 0B                 pei   <@myHandle+2
2933 184F D4 09                 pei   <@myHandle
2934 1851 A2 02 18 22           _GetHandleSize 
2935 1858 38                    sec   
2936 1859 A3 01                 lda   1,s
2937 185B EF 72 1B 02           sbc   >@minusSize
2938 185F 83 01                 sta   1,s                      ;size to copy (remaineder of record)
2939 1861 A2 02 2B 22           _BlockMove 
2940 1868
2941 1868 A0 02 00              ldy   #2                       ;decrement number-of-entries count
2942 186B B7 05                 lda   [<myPtr],y
2943 186D 3A                    dec   a
2944 186E 97 05                 sta   [<myPtr],y
2945 1870 80 A6                 bra   @exit
2946 1872
2947 1872 00 00        @minusSize DC W:0
2948 1874
2949 1874                       endp 
2950 1874
2951 1874              **********************************************************************
2952 1874              *
2953 1874              * $640E DoModalWindow -- new call 22-Jan-91 DAL
2954 1874              *
2955 1874              * Input:
2956 1874              *
2957 1874              *
2958 1874              *
2959 1874              * First, a little about fakeModalDialog:
2960 1874              *
2961 1874              * fakeModalDialog returns a long as a result.
2962 1874              * If the result is NULL:
2963 1874              *     Nothing happened.  Unlike ModalDialog, control is returned to
2964 1874              *     the application during null events.  This is so the application
2965 1874              *     can do stuff like switch cursors, or other idle tasks.
2966 1874              * If bit 31 of the result is true:
2967 1874              *     The user chose a menu item.  Bits 0-15 are the menu item ID.
2968 1874              *                                  Bits 16-30 are the menu ID.
2969 1874              * If bit 31 of the result is false:
2970 1874              *     The user clicked on a control.  Bits 0-30 are the control ID.
2971 1874              *
2972 1874              * Now, the sample code fragment:
2973 1874              *
2974 1874              *   #define aboutBoxID 0x1001L
2975 1874              *
2976 1874              *   void    doAboutBox()
2977 1874              *   {
2978 1874              *       WindowPtr       wptr, keepPort;
2979 1874              *       unsigned long   id;
2980 1874              *       unsigned int    item;
2981 1874              *       keepPort = GetPort();   /* Preserve the current port. */
2982 1874              *
2983 1874              *       wptr = NewWindow2(NULL, NULL, NULL, NULL, 2, aboutBoxID, rWindParam1);
2984 1874              *           /* Open the about box from a resource. */
2985 1874              *
2986 1874              *       if (!_toolErr) {            /* If the window opened successfully... */
2987 1874              *           aboutWindow = wptr;     /* Set the aboutWindow global variable. */
2988 1874              *                                   /* This tells other routines what state */
2989 1874              *                                   /* we are in.                           */
2990 1874              *
2991 1874              *           for (;;) {      /* Loop, due to NULL events being returned. */
2992 1874              *
2993 1874              *               id = fakeModalDialog(
2994 1874              *                   &event,         /* Pointer to extended event record.   */
2995 1874              *                   NULL,           /* Use default update procedure.       */
2996 1874              *                   NULL,           /* There will be no event mods.        */
2997 1874              *                   NULL,           /* Do standard beep.                   */
2998 1874              *                   mwMenuSelect+   /* Allow pullDowns.                    */
2999 1874              *                   mwMenuKey+      /* Allow menu keys.                    */
3000 1874              *                   mwDeskAcc+      /* Allow desk accessories.             */
3001 1874              *                   mwUpdateAll     /* Update all windows, not just about. */
3002 1874              *               );
3003 1874              *
3004 1874              *               item = id;          /* Get lo-word from result. */
3005 1874              *
3006 1874              *               if (id & 0x80000000L) {             /* If menu command...    */
3007 1874              *                   if (item == 255) {              /* If close command then */
3008 1874              *                       HiliteMenu(0, FileMenuID);  /* turn menu inv. off.   */
3009 1874              *                       break;                      /* Go close about box.   */
3010 1874              *                   }
3011 1874              *                   doMenuCommand(id);      /* Do other menus (like quit).   */
3012 1874              *                   if (quitFlag) break;    /* User did do a quit from menu. */
3013 1874              *               }
3014 1874              *               else {                          /* ...else handle controls. */
3015 1874              *                   if (item == 1) break;       /* User clicked OK button.  */
3016 1874              *               }
3017 1874              *           }
3018 1874              *
3019 1874              *           SetPort(keepPort);      /* Put port back before closing about. */
3020 1874              *           CloseWindow(wptr);      /* Close aboutBox.                     */
3021 1874              *           aboutWindow = NULL;     /* Let others know it is closed.       */
3022 1874              *           appSetMenus();          /* Update the menus to reflect a new.  */
3023 1874              *       }                           /* top window.                         */
3024 1874              *   }
3025 1874              *
3026 1874              **********************************************************************
3027 1874              DoModalWindow proc export 
3028 1874                       entry theIBeamAdr 
3029 1874                       import ctlPart 
3030 1874                       import doInitCursor            ;14-Nov-91 DAL
3031 1874
3032 1874              fVis     equ   $0020                    ;visible bit in window frame
3033 1874
3034 1874              mwNoScrapForLE equ   $0001
3035 1874              mwMenuSelect equ   $0002
3036 1874              mwMenuKey equ   $0004
3037 1874              mwIBeam  equ   $0008
3038 1874              mwDeskAcc equ   $0010
3039 1874              mwWantActivate equ   $0020              ;added 20-May-91 DAL
3040 1874              mwUpdateAll equ   $4000
3041 1874              mwMovable equ   $8000
3042 1874
3043 1874                       DefineStack 
3044 1874              dlgwptr  long                           ;Must be at 1,s
3045 1874              keepPort long                           ;Must be at 5,s
3046 1874              ctlHndl  long 
3047 1874              ctlPtr   long 
3048 1874              theHndl  long 
3049 1874              thePtr   long 
3050 1874              whichWindow long 
3051 1874              tempwptr long 
3052 1874              code     word 
3053 1874              editTask word 
3054 1874              yloc     word 
3055 1874              xloc     word 
3056 1874              wkind    word 
3057 1874              menunum  word 
3058 1874              zero     word 
3059 1874              sizeLocals EndLocals 
3060 1874
3061 1874              saveDPage word 
3062 1874              returnAddr block 6                      ;was 3 (DAL)
3063 1874
3064 1874                       BegParms 
3065 1874              flags    word 
3066 1874              beepProc long                           ;Null, SysBeep.  Negative, do nothing.
3067 1874              eventHook long                          ;Optional -- pass a NULL for none.
3068 1874              updateProc long                         ;Optional -- pass a NULL for default.
3069 1874              event    long                           ;Must be extended 5.0 event rec ptr.
3070 1874              sizeParms EndParms 
3071 1874
3072 1874              retval   long                           ;Control ID hit.  NULL if none.
3073 1874                                                      ;If bit 31 is on, then retval
3074 1874                                                      ;is a menu ID.
3075 1874
3076 1874 A9 00 00              lda   #0                       ;added 18-Apr-91 DAL
3077 1877 8F 3F 23 02           sta   >ctlPart                 ;added 18-Apr-91 DAL
3078 187B
3079 187B 0B                    phd                            ;Save directPage register.
3080 187C 3B                    tsc                            ;Make space for locals.
3081 187D 38                    sec   
3082 187E E9 2E 00              sbc   #sizeLocals
3083 1881 1B                    tcs   
3084 1882 5B                    tcd                            ;Set directPage register.
3085 1883
3086 1883 68                    pla   
3087 1884 68                    pla   
3088 1885 A2 04 1C 22           _GetPort                       ;Result space already there (keepPort).
3089 188C
3090 188C 48                    pha   
3091 188D 48                    pha   
3092 188E A2 0E 15 22           _FrontWindow                   ;Result space already there (dlgwptr).
3093 1895
3094 1895 48                    pha                            ;Find out if it is a DA window.
3095 1896 D4 03                 pei   dlgwptr+2
3096 1898 D4 01                 pei   dlgwptr
3097 189A A2 0E 2B 22           _GetWKind 
3098 18A1 68                    pla   
3099 18A2 85 29                 sta   wkind
3100 18A4 10 32                 bpl   @gotit
3101 18A6
3102 18A6 48           @get1stRegWnd pha                       ;Result space for _GetWFrame.
3103 18A7
3104 18A7 48                    pha                            ;Result space for _GetNextWindow.
3105 18A8 48                    pha   
3106 18A9
3107 18A9 D4 03                 pei   dlgwptr+2
3108 18AB D4 01                 pei   dlgwptr
3109 18AD A2 0E 2A 22           _GetNextWindow 
3110 18B4
3111 18B4 A3 01                 lda   1,s                      ;Param for _GetWFrame.
3112 18B6 85 01                 sta   dlgwptr
3113 18B8 A3 03                 lda   3,s
3114 18BA 85 03                 sta   dlgwptr+2
3115 18BC
3116 18BC A2 0E 2C 22           _GetWFrame 
3117 18C3 68                    pla   
3118 18C4
3119 18C4 29 20 00              and   #fVis
3120 18C7 F0 DD                 beq   @get1stRegWnd            ;Window is invisible, so skip it.
3121 18C9
3122 18C9 48                    pha   
3123 18CA D4 03                 pei   dlgwptr+2
3124 18CC D4 01                 pei   dlgwptr
3125 18CE A2 0E 2B 22           _GetWKind 
3126 18D5 68                    pla   
3127 18D6 30 CE                 bmi   @get1stRegWnd            ;Window is system window, so skip it.
3128 18D8
3129 18D8 64 49        @gotit   stz   retval                   ;Assume nothing interesting is
3130 18DA 64 4B                 stz   retval+2                 ;going to happen.
3131 18DC 64 21                 stz   code
3132 18DE 64 23                 stz   editTask                 ;For cut/copy/paste/clear signal.
3133 18E0 64 2D                 stz   zero                     ;For optimization purposes.
3134 18E2
3135 18E2              *** Note that updateProc+3 can have flag bits set
3136 18E2 A5 42                 lda   updateProc+1             ;Set up the update procedure for all
3137 18E4 D0 1E                 bne   @a                       ;cases.  This also sets it up so that
3138 18E6                                                      ;TaskMaster can handle this window
3139 18E6                                                      ;from other parts of the application.
3140 18E6
3141 18E6              *** added 10-Jul-92 DAL -- See if the window already has a wContDraw procedure
3142 18E6 48                    pha   
3143 18E7 48                    pha   
3144 18E8 D4 03                 pei   <dlgwptr+2
3145 18EA D4 01                 pei   <dlgwptr
3146 18EC A2 0E 48 22           _GetContentDraw 
3147 18F3 68                    pla   
3148 18F4 FA                    plx   
3149 18F5 D0 21                 bne   @aa
3150 18F7 AA                    tax   
3151 18F8 D0 1E                 bne   @aa
3152 18FA              *** end 10-Jul-92
3153 18FA
3154 18FA A9 02 00              lda   #doStdDrawProc>>16
3155 18FD              ;;;	sta	updateProc+2
3156 18FD              *** 10-Jul-92 DAL -- OR in so we don't mess up the no-GS/OS-needed flag bit (bit 30)
3157 18FD 04 43                 tsb   updateProc+2
3158 18FF              *** end 10-Jul-92
3159 18FF A9 24 23              lda   #doStdDrawProc
3160 1902 85 41                 sta   updateProc               ;Use the default update procedure.
3161 1904              @a        
3162 1904              *** added 10-Jul-92 DAL -- assume modal windows are always smart about B/D/ResApp/CtlParamPtr
3163 1904 A9 00 80              lda   #$8000
3164 1907 04 43                 tsb   <updateProc+2
3165 1909              *** end 10-Jul-92
3166 1909 D4 43                 pei   updateProc+2
3167 190B D4 41                 pei   updateProc
3168 190D D4 03                 pei   dlgwptr+2
3169 190F D4 01                 pei   dlgwptr
3170 1911 A2 0E 49 22           _SetContentDraw                ;Let the window and TaskMaster know.
3171 1918
3172 1918 48           @aa      pha                            ;Make sure that top window is
3173 1919 48                    pha                            ;the active window.
3174 191A A2 04 1C 22           _GetPort 
3175 1921 68                    pla   
3176 1922 85 05                 sta   keepPort
3177 1924 68                    pla   
3178 1925 85 07                 sta   keepPort+2
3179 1927 D4 03                 pei   dlgwptr+2
3180 1929 D4 01                 pei   dlgwptr
3181 192B A2 04 1B 22           _SetPort 
3182 1932
3183 1932 A5 37                 lda   flags
3184 1934 29 08 00              and   #mwIBeam
3185 1937 F0 63                 beq   @b                       ;No cursor changes.
3186 1939
3187 1939 A5 29                 lda   wkind
3188 193B 30 5F                 bmi   @b
3189 193D
3190 193D 48                    pha                            ;Result space for control part.
3191 193E
3192 193E A0 00 00              ldy   #0                       ;Point to where to put the handle.
3193 1941 5A                    phy   
3194 1942 7B                    tdc   
3195 1943 18                    clc   
3196 1944 69 09 00              adc   #ctlHndl
3197 1947 48                    pha                            ;Pointer to ctlHndl now on stack.
3198 1948
3199 1948 5A                    phy   
3200 1949 69 1C 00              adc   #yloc-ctlHndl
3201 194C 48                    pha                            ;Pointer to yloc now on stack.
3202 194D A2 06 0C 22           _GetMouse 
3203 1954
3204 1954 D4 27                 pei   xloc                     ;Now that they are right, pass 'em on.
3205 1956 D4 25                 pei   yloc
3206 1958 D4 03                 pei   dlgwptr+2
3207 195A D4 01                 pei   dlgwptr
3208 195C A2 0E 69 22           _FindCursorCtl                 ;Find which control cursor is over.
3209 1963 68                    pla                            ;The part code, which we don't care
3210 1964                                                      ;about here.
3211 1964
3212 1964 F0 0D                 beq   @arrowCursor             ;Not over any control -- use arrow.
3213 1966
3214 1966 20 FA 1E              jsr   getCtlProc               ;Find out what kind of control it is.
3215 1969 C9 00 85              cmp   #editTextControl>>16
3216 196C F0 0F                 beq   @ibeamCursor             ;It is a TextEdit ctl, kind of
3217 196E                                                      ;See fmdFindCursorCtl for more info.
3218 196E C9 00 83              cmp   #editLineControl>>16
3219 1971 F0 0A                 beq   @ibeamCursor             ;It is a LineEdit tool.
3220 1973
3221 1973 20 FB 22     @arrowCursor jsr   ibeamTest
3222 1976 90 24                 bcc   @b
3223 1978 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
3224 197B 80 1F                 bra   @b                       ;We have an arrow cursor.
3225 197D
3226 197D 20 FB 22     @ibeamCursor jsr   ibeamTest
3227 1980 B0 1A                 bcs   @b                       ;We have an ibeam cursor.
3228 1982 A2 12 13 22           _IBeamCursor 
3229 1989 48                    pha   
3230 198A 48                    pha   
3231 198B A2 04 8F 22           _GetCursorAdr 
3232 1992 68                    pla   
3233 1993 8F 20 23 02           sta   >theIBeamAdr
3234 1997 68                    pla   
3235 1998 8F 22 23 02           sta   >theIBeamAdr+2
3236 199C
3237 199C A2 05 19 22  @b       _SystemTask 
3238 19A3
3239 19A3 A5 37                 lda   flags                    ;See if cut/copy/paste is tied to menu.
3240 19A5 29 06 00              and   #mwMenuSelect+mwMenuKey
3241 19A8 F0 07                 beq   @c                       ;Isn't keyDownEvt or mouseDownEvt.
3242 19AA A2 0E 68 22           _MWSetUpEditMenu               ;Update the edit menu.
3243 19B1
3244 19B1              @c        
3245 19B1              *** added 21-Apr-91 DAL -- to let sounds happen right, do our update before
3246 19B1              *** calling GetNextEvent allowing mouse and key events
3247 19B1 48           @eventAgain pha   
3248 19B2 F4 40 01              pea   $0140                    ;update and activate events only
3249 19B5 D4 47                 pei   <event+2
3250 19B7 D4 45                 pei   <event
3251 19B9 A2 06 0A 22           _GetNextEvent 
3252 19C0 68                    pla   
3253 19C1 F0 10                 beq   @noSpecialUpdate
3254 19C3 A7 45                 lda   [<event]
3255 19C5 C9 08 00              cmp   #8                              ;8=activate
3256 19C8 F0 1B                 beq   @handleSpecialUpdate     ;munch other window's deactivate event
3257 19CA              ; (event must be an update, #6)
3258 19CA
3259 19CA              *** compare middle word of window ptr
3260 19CA A0 03 00              ldy   #3                       ;middle word of message field
3261 19CD B7 45                 lda   [<event],y
3262 19CF C5 02                 cmp   <dlgwptr+1
3263 19D1 F0 12                 beq   @handleSpecialUpdate
3264 19D3
3265 19D3              @noSpecialUpdate  
3266 19D3              *** end of 21-Apr-91 DAL
3267 19D3
3268 19D3 48                    pha                            ;Get the event.
3269 19D4 F4 FF 0F              pea   $0FFF                    ;was $FFFF 17-Feb-91 DAL
3270 19D7 D4 47                 pei   event+2
3271 19D9 D4 45                 pei   event
3272 19DB A2 06 0A 22           _GetNextEvent 
3273 19E2 68                    pla   
3274 19E3 F0 06                 beq   @exit                    ;Event shouldn't be handled by app.
3275 19E5
3276 19E5              @handleSpecialUpdate  
3277 19E5
3278 19E5 A7 45                 lda   [event]
3279 19E7 85 21                 sta   code
3280 19E9 D0 34                 bne   @gotEvent
3281 19EB
3282 19EB A5 21        @exit    lda   code                     ;See if code is 0.  If it is, force a
3283 19ED D0 14                 bne   @exit0                   ;NULL event, so the cursor will flash
3284 19EF 87 45                 sta   [event]                  ;for lineedit items, etc.
3285 19F1 48                    pha   
3286 19F2 F4 01 00              pea   1
3287 19F5 48                    pha   
3288 19F6 48                    pha   
3289 19F7 D4 47                 pei   event+2
3290 19F9 D4 45                 pei   event
3291 19FB A2 10 29 22           _SendEventToCtl 
3292 1A02 68                    pla   
3293 1A03
3294 1A03 D4 07        @exit0   pei   keepPort+2
3295 1A05 D4 05                 pei   keepPort
3296 1A07 A2 04 1B 22           _SetPort 
3297 1A0E 3B                    tsc                            ;Get rid of local variables.
3298 1A0F 18                    clc   
3299 1A10 69 2E 00              adc   #sizeLocals
3300 1A13 1B                    tcs   
3301 1A14 2B                    pld                            ;Restore directPage register.
3302 1A15
3303 1A15 A2 00 00              ldx   #0
3304 1A18 A0 12 00              ldy   #sizeParms
3305 1A1B 5C 84 01 E1           jml   $e10184                  ;ToStrip
3306 1A1F
3307 1A1F
3308 1A1F 20 E9 1F     @gotEvent jsr   XlateApplePeriod
3309 1A22 A5 3E                 lda   eventHook+1
3310 1A24 F0 10                 beq   @noEventHook             ;Zero, no event massaging.
3311 1A26
3312 1A26 D4 47                 pei   event+2                  ;Give the event hook something
3313 1A28 D4 45                 pei   event                    ;to play with.
3314 1A2A 4B                    phk                            ;Push where we want to return to.
3315 1A2B F4 35 1D              pea   @noEventHook-1
3316 1A2E
3317 1A2E 48                    pha                            ;Push the eventHook address and return
3318 1A2F 8B                    phb                            ;to it.
3319 1A30 68                    pla   
3320 1A31 A5 3D                 lda   eventHook
3321 1A33 3A                    dec   a
3322 1A34 48                    pha   
3323 1A35 6B                    rtl   
3324 1A36
3325 1A36 A7 45        @noEventHook lda   [event]
3326 1A38 85 21                 sta   code
3327 1A3A
3328 1A3A 20 62 20              jsr   doMouseDown
3329 1A3D 90 AC                 bcc   @exit
3330 1A3F
3331 1A3F 20 E7 22              jsr   doMenuKey
3332 1A42 90 A7                 bcc   @exit                    ;The key was a menu key.
3333 1A44
3334 1A44 20 CB 1D              jsr   doCutCopyPaste
3335 1A47 90 A2                 bcc   @exit                    ;We did a cut, copy, or paste.
3336 1A49
3337 1A49 20 0B 1F              jsr   doActivate
3338 1A4C              ***	bcc	@exit	;We did an activate.
3339 1A4C              *** added 20-May-91 DAL
3340 1A4C B0 0A                 bcs   @didNotActivate
3341 1A4E A5 37                 lda   <flags
3342 1A50 29 20 00              and   #mwWantActivate
3343 1A53 D0 96                 bne   @exit                    ;return with the activate event
3344 1A55 82 59 FF              brl   @eventAgain              ;shortcut back for another one
3345 1A58              @didNotActivate  
3346 1A58              *** end of 20-May-91 DAL
3347 1A58
3348 1A58 20 20 20              jsr   doUpdate
3349 1A5B 90 8E                 bcc   @exit                    ;We did an update.
3350 1A5D
3351 1A5D 48                    pha   
3352 1A5E A9 00 00              lda   #0
3353 1A61 48                    pha   
3354 1A62 48                    pha   
3355 1A63 48                    pha   
3356 1A64 D4 47                 pei   event+2
3357 1A66 D4 45                 pei   event
3358 1A68 A2 10 29 22           _SendEventToCtl 
3359 1A6F 68                    pla   
3360 1A70 F0 91                 beq   @exit0
3361 1A72
3362 1A72              *** added 4-Oct-91 DAL -- if we Tabbed to another control, return the new one
3363 1A72 A7 45                 lda   [<event]
3364 1A74 C9 03 00              cmp   #keyDownEvt
3365 1A77 F0 05                 beq   @isKey
3366 1A79 C9 05 00              cmp   #autoKeyEvt
3367 1A7C D0 3A                 bne   @notKey
3368 1A7E A0 02 00     @isKey   ldy   #oMessage
3369 1A81 B7 45                 lda   [<event],y
3370 1A83 29 FF 00              and   #$00ff
3371 1A86 C9 09 00              cmp   #$0009                   ;Tab?
3372 1A89 D0 2D                 bne   @notTab
3373 1A8B
3374 1A8B 48                    pha   
3375 1A8C 48                    pha   
3376 1A8D A2 10 26 22           _FindTargetCtl 
3377 1A94 68                    pla   
3378 1A95 FA                    plx   
3379 1A96 B0 20                 bcs   @notTab
3380 1A98
3381 1A98 48                    pha   
3382 1A99 48                    pha                            ;space for GetCtlID
3383 1A9A DA                    phx   
3384 1A9B 48                    pha   
3385 1A9C
3386 1A9C A0 1E 00              ldy   #owmTaskData2            ;store ctl handle in TaskData2
3387 1A9F 97 45                 sta   [<event],y
3388 1AA1 C8                    iny   
3389 1AA2 C8                    iny   
3390 1AA3 8A                    txa   
3391 1AA4 97 45                 sta   [<event],y
3392 1AA6
3393 1AA6 A2 10 2A 22           _GetCtlID                      ;store ctl id in TaskData4
3394 1AAD 68                    pla   
3395 1AAE A0 26 00              ldy   #owmTaskData4
3396 1AB1 97 45                 sta   [<event],y
3397 1AB3 68                    pla   
3398 1AB4 C8                    iny   
3399 1AB5 C8                    iny   
3400 1AB6 97 45                 sta   [<event],y
3401 1AB8
3402 1AB8              @notTab   
3403 1AB8              @notKey   
3404 1AB8              *** end 4-Oct-91
3405 1AB8
3406 1AB8 A0 1E 00              ldy   #owmTaskData2            ;Get the ctl hndl of affected ctl.
3407 1ABB B7 45                 lda   [event],y
3408 1ABD 85 09                 sta   ctlHndl                  ;Save this in ctlHndl.
3409 1ABF C8                    iny   
3410 1AC0 C8                    iny   
3411 1AC1 B7 45                 lda   [event],y
3412 1AC3 85 0B                 sta   ctlHndl+2
3413 1AC5 20 D9 21              jsr   setValues
3414 1AC8 82 20 FF              brl   @exit
3415 1ACB
3416 1ACB              ***
3417 1ACB
3418 1ACB A5 23        doCutCopyPaste lda   editTask           ;We already have a task, 
3419 1ACD D0 41                 bne   @atask                   ;so don't check keypress.
3420 1ACF
3421 1ACF A5 21                 lda   code
3422 1AD1 C9 03 00              cmp   #keyDownEvt
3423 1AD4 F0 07                 beq   @akey
3424 1AD6 C9 05 00              cmp   #autoKeyEvt
3425 1AD9 F0 02                 beq   @akey
3426 1ADB
3427 1ADB 38           @secexit sec   
3428 1ADC 60                    rts   
3429 1ADD
3430 1ADD A5 37        @akey    lda   flags
3431 1ADF 29 04 00              and   #mwMenuKey
3432 1AE2 D0 F7                 bne   @secexit
3433 1AE4 A0 0E 00              ldy   #omodifiers              ;See if it is a cut/copy/paste command.
3434 1AE7 B7 45                 lda   [event],y
3435 1AE9 29 00 19              and   #controlKey+optionKey+appleKey
3436 1AEC C9 00 01              cmp   #appleKey
3437 1AEF D0 EA                 bne   @secexit                 ;Wrong modifiers -- no go.
3438 1AF1
3439 1AF1 A0 02 00              ldy   #omessage
3440 1AF4 B7 45                 lda   [event],y
3441 1AF6 09 20 00              ora   #$20                     ;Lower-case it.
3442 1AF9
3443 1AF9 A2 FB 00              ldx   #251
3444 1AFC C9 78 00              cmp   #'x'
3445 1AFF F0 0D                 beq   @yes
3446 1B01 E8                    inx   
3447 1B02 C9 63 00              cmp   #'c'
3448 1B05 F0 07                 beq   @yes
3449 1B07 E8                    inx   
3450 1B08 C9 76 00              cmp   #'v'
3451 1B0B 38                    sec   
3452 1B0C D0 CD                 bne   @secexit
3453 1B0E 86 23        @yes     stx   editTask                 ;We have a valid task now.
3454 1B10
3455 1B10 48           @atask   pha                            ;Find out what control we are talking
3456 1B11 48                    pha                            ;about.
3457 1B12 A2 10 26 22           _FindTargetCtl 
3458 1B19 7A                    ply   
3459 1B1A 84 09                 sty   ctlHndl
3460 1B1C 7A                    ply   
3461 1B1D 84 0B                 sty   ctlHndl+2
3462 1B1F B0 BA                 bcs   @secexit
3463 1B21
3464 1B21 A5 23                 lda   editTask                 ;251 thru 254 (cut/copy/paste/clear)
3465 1B23 64 23                 stz   editTask                 ;This is also a flag, so we need to set
3466 1B25 38                    sec                            ;it back.
3467 1B26 E9 F7 00              sbc   #251-4
3468 1B29 0A                    asl   a                        ;Assume TextEdit.
3469 1B2A AA                    tax   
3470 1B2B 64 11                 stz   theHndl
3471 1B2D 64 13                 stz   theHndl+2
3472 1B2F
3473 1B2F 20 FA 1E              jsr   getCtlProc               ;Find out what tool it is.
3474 1B32 C9 00 85              cmp   #editTextControl>>16
3475 1B35 F0 17                 beq   @b                       ;It is TextEdit, and the xreg is set up
3476 1B37                                                      ;for TextEdit.
3477 1B37
3478 1B37 C9 00 83              cmp   #editLineControl>>16
3479 1B3A D0 9F                 bne   @secexit                 ;Not a LineEdit tool, so there can be
3480 1B3C                                                      ;no cut/copy/paste.
3481 1B3C
3482 1B3C A0 1C 00              ldy   #octlData                ;It is LineEdit.
3483 1B3F B7 0D                 lda   [ctlPtr],y
3484 1B41 85 11                 sta   theHndl
3485 1B43 C8                    iny   
3486 1B44 C8                    iny   
3487 1B45 B7 0D                 lda   [ctlPtr],y
3488 1B47 85 13                 sta   theHndl+2
3489 1B49 8A                    txa   
3490 1B4A 29 07 00              and   #7
3491 1B4D AA                    tax                            ;LineEdit tool.
3492 1B4E
3493 1B4E D4 13        @b       pei   theHndl+2                ;All the below routines will use this
3494 1B50 D4 11                 pei   theHndl                  ;parameter eventually.
3495 1B52 7C 55 1E              jmp   (@theTask,x)
3496 1B55
3497 1B55 65 1E 81 1E  @theTask DC W:@leCut, @leCopy, @lePaste, @leClear
3498 1B5D C2 1E DC 1E           DC W:@teCut, @teCopy, @tePaste, @teClear
3499 1B65
3500 1B65 A2 14 12 22  @leCut   _LECut                         ;Do the cut.
3501 1B6C 20 D9 21              jsr   setValues                ;added 30-Nov-92 DAL
3502 1B6F A5 37        @leCut0  lda   flags
3503 1B71 4A                    lsr   a
3504 1B72 B0 07                 bcs   @clcexit
3505 1B74
3506 1B74              ***	_ZeroScrap	;Then conditionally do the LEToScrap.
3507 1B74              ***	pha	;Conditionally, because of the bug for
3508 1B74              ***	_LEGetScrapLen	;zero-length scrap.
3509 1B74              ***	pla
3510 1B74              ***	beq	@clcexit
3511 1B74
3512 1B74 A2 14 1A 22           _LEToScrap 
3513 1B7B 18           @clcexit clc   
3514 1B7C 60                    rts   
3515 1B7D 68           @clcexitz pla   
3516 1B7E 68                    pla   
3517 1B7F 18                    clc   
3518 1B80 60                    rts   
3519 1B81
3520 1B81 A2 14 13 22  @leCopy  _LECopy                        ;Do the copy.
3521 1B88 80 E5                 bra   @leCut0
3522 1B8A
3523 1B8A A5 37        @lePaste lda   flags
3524 1B8C 4A                    lsr   a
3525 1B8D B0 1E                 bcs   @c
3526 1B8F
3527 1B8F 48                    pha                            ;Boy, are we good citizens, or what?
3528 1B90 48                    pha   
3529 1B91 D4 2D                 pei   zero
3530 1B93 A2 16 0F 22           _GetScrapSize 
3531 1B9A FA                    plx   
3532 1B9B 7A                    ply   
3533 1B9C B0 DF                 bcs   @clcexitz                ;Give up and do nothing.
3534 1B9E 98                    tya   
3535 1B9F D0 DC                 bne   @clcexitz                ;Way too big, so give up.
3536 1BA1 8A                    txa   
3537 1BA2 F0 D9                 beq   @clcexitz                ;Too small, so give up.
3538 1BA4 A2 14 19 22           _LEFromScrap 
3539 1BAB B0 D0                 bcs   @clcexitz                ;Somebody wasn't pleased, so give up.
3540 1BAD A2 14 14 22  @c       _LEPaste 
3541 1BB4 20 D9 21              jsr   setValues                ;added 30-Nov-92 DAL
3542 1BB7 18                    clc   
3543 1BB8 60                    rts   
3544 1BB9
3545 1BB9 A2 14 15 22  @leClear _LEDelete                      ;Do the clear.
3546 1BC0 18                    clc   
3547 1BC1 60                    rts   
3548 1BC2
3549 1BC2 A0 2A 00     @teCut   ldy   #$28+2                   ;Find out if we are read-only.
3550 1BC5 B7 0D                 lda   [ctlPtr],y
3551 1BC7 29 00 04              and   #$0400                   ;Bit 26, please.
3552 1BCA F0 04                 beq   @teCut0                  ;Not read-only, so it is okay.
3553 1BCC 68                    pla   
3554 1BCD 68                    pla   
3555 1BCE 80 0A                 bra   @teCut1
3556 1BD0 A2 22 16 22  @teCut0  _TECut                         ;Do the cut.
3557 1BD7 20 D9 21              jsr   setValues                ;added 30-Nov-92 DAL
3558 1BDA 18           @teCut1  clc   
3559 1BDB 60                    rts   
3560 1BDC
3561 1BDC A2 22 17 22  @teCopy  _TECopy                        ;Do the copy.
3562 1BE3 18                    clc   
3563 1BE4 60                    rts   
3564 1BE5
3565 1BE5 A2 22 18 22  @tePaste _TEPaste                       ;Do the paste.
3566 1BEC 20 D9 21              jsr   setValues                ;added 30-Nov-92 DAL
3567 1BEF 18                    clc   
3568 1BF0 60                    rts   
3569 1BF1
3570 1BF1 A2 22 19 22  @teClear _TEClear                       ;Do the clear.
3571 1BF8 18                    clc   
3572 1BF9 60                    rts   
3573 1BFA
3574 1BFA A0 02 00     getCtlProc ldy   #2                     ;Find out what tool it is.
3575 1BFD B7 09                 lda   [ctlHndl],y
3576 1BFF 85 0F                 sta   ctlPtr+2
3577 1C01 A7 09                 lda   [ctlHndl]
3578 1C03 85 0D                 sta   ctlPtr                   ;Handle now dereferenced.
3579 1C05 A0 16 00              ldy   #octlProc+2              ;Get hi-word of proc address.
3580 1C08 B7 0D                 lda   [ctlPtr],y
3581 1C0A 60                    rts   
3582 1C0B
3583 1C0B              ***
3584 1C0B
3585 1C0B A5 21        doActivate lda   code
3586 1C0D C9 08 00              cmp   #activateEvt
3587 1C10 F0 02                 beq   @a
3588 1C12 38                    sec   
3589 1C13 60                    rts   
3590 1C14
3591 1C14 48           @a       pha   
3592 1C15 48                    pha   
3593 1C16 A2 04 1C 22           _GetPort 
3594 1C1D
3595 1C1D 48                    pha                            ;Result space for _GetWControls.
3596 1C1E 48                    pha   
3597 1C1F A0 04 00              ldy   #omessage+2              ;Find out which window we are
3598 1C22 B7 45                 lda   [event],y                ;talking about.
3599 1C24 AA                    tax   
3600 1C25 88                    dey   
3601 1C26 88                    dey   
3602 1C27 B7 45                 lda   [event],y
3603 1C29 DA                    phx   
3604 1C2A 48                    pha   
3605 1C2B DA                    phx   
3606 1C2C 48                    pha   
3607 1C2D A2 04 1B 22           _SetPort 
3608 1C34
3609 1C34 A0 0E 00              ldy   #omodifiers              ;See if we are activating.
3610 1C37 B7 45                 lda   [event],y
3611 1C39 4A                    lsr   a
3612 1C3A 90 20                 bcc   @noMenuProc              ;We are not, so don't update menus.
3613 1C3C
3614 1C3C 48                    pha                            ;See if we have a proc to set the state
3615 1C3D 48                    pha                            ;of the menus.
3616 1C3E A9 FF FF              lda   #$ffff                   ;was 0 30-Apr-91 DAL
3617 1C41 48                    pha   
3618 1C42 48                    pha   
3619 1C43 A2 0E 66 22           _MWSetMenuProc                 ;pass 0 to get the current menu proc
3620 1C4A FA                    plx                            ;Lo-word of address.
3621 1C4B 68                    pla                            ;Hi-word of address.
3622 1C4C D0 03                 bne   @haveMenuProc            ;We have a menu proc -- go do it.
3623 1C4E 9B                    txy   
3624 1C4F F0 0B                 beq   @noMenuProc              ;We don't have one.
3625 1C51
3626 1C51 4B           @haveMenuProc phk                       ;Push where we want to return to.
3627 1C52 F4 5B 1F              pea   @noMenuProc-1
3628 1C55 EB                    xba                            ;Push just the lo-byte as the hi-byte
3629 1C56 48                    pha                            ;of ret addr.
3630 1C57 8B                    phb   
3631 1C58 68                    pla   
3632 1C59 CA                    dex                            ;Push the lo-word minus 1 for rtl.
3633 1C5A DA                    phx   
3634 1C5B 6B                    rtl   
3635 1C5C
3636 1C5C A2 0E 33 22  @noMenuProc _GetWControls 
3637 1C63 68                    pla   
3638 1C64 85 09                 sta   ctlHndl
3639 1C66 68                    pla   
3640 1C67 85 0B                 sta   ctlHndl+2
3641 1C69
3642 1C69              *** added 23-Mar-93 DAL -- if the window's fCtlTie bit is set, then don't invalidate controls
3643 1C69 48                    pha                            ;space for GetWFrame
3644 1C6A A0 04 00              ldy   #omessage+2
3645 1C6D B7 45                 lda   [<event],y
3646 1C6F 48                    pha   
3647 1C70 88                    dey   
3648 1C71 88                    dey   
3649 1C72 B7 45                 lda   [<event],y
3650 1C74 48                    pha   
3651 1C75 A2 0E 2C 22           _GetWFrame 
3652 1C7C 68                    pla   
3653 1C7D 29 08 00              and   #$0008                   ;fCtlTie = 1 --> ctl state is independent of window state
3654 1C80 D0 56                 bne   @exit
3655 1C82              *** end 23-Mar-93
3656 1C82
3657 1C82 A5 0A        @loop    lda   ctlHndl+1
3658 1C84 F0 52                 beq   @exit
3659 1C86 20 FA 1E              jsr   getCtlProc
3660 1C89
3661 1C89              *** added 27-Oct-91 DAL -- special-case Static Text
3662 1C89 AA                    tax   
3663 1C8A C9 00 81              cmp   #$8100
3664 1C8D D0 0A                 bne   @notST
3665 1C8F A0 10 00              ldy   #oCtlFlag
3666 1C92 B7 0D                 lda   [<ctlPtr],y
3667 1C94 29 08 00              and   #$0008                   ;fTextCanDim
3668 1C97 D0 1A                 bne   @inval                   ;inval if it can dim
3669 1C99 8A           @notST   txa   
3670 1C9A              *** end 27-Oct-91
3671 1C9A A2 06 00              ldx   #@nakend-@nak-2
3672 1C9D DF E1 1F 02  @naklook cmp   >@nak,x
3673 1CA1 F0 28                 beq   @nextCtl
3674 1CA3 CA                    dex   
3675 1CA4 CA                    dex   
3676 1CA5 10 F6                 bpl   @naklook
3677 1CA7
3678 1CA7 C9 00 83              cmp   #editLineControl>>16
3679 1CAA D0 07                 bne   @inval                   ;Invalidate unless lineEdit.
3680 1CAC                                                      ;Invalidate this one selectively.  If
3681 1CAC                                                      ;it is the window's target, then
3682 1CAC                                                      ;invalidate it.
3683 1CAC
3684 1CAC A0 3C 00              ldy   #octlMoreFlags
3685 1CAF B7 0D                 lda   [ctlPtr],y
3686 1CB1 10 18                 bpl   @nextCtl                 ;It doesn't need invalidating (not target).
3687 1CB3
3688 1CB3 A5 0D        @inval   lda   ctlPtr                   ;Push pointer to bounding rect of ctl.
3689 1CB5 18                    clc   
3690 1CB6 69 08 00              adc   #octlRect
3691 1CB9 AA                    tax   
3692 1CBA A5 0F                 lda   ctlPtr+2
3693 1CBC 69 00 00              adc   #0
3694 1CBF 48                    pha   
3695 1CC0 DA                    phx   
3696 1CC1 A2 0E 3A 22           _InvalRect 
3697 1CC8 20 FA 1E              jsr   getCtlProc               ;An easy way to redereference.
3698 1CCB
3699 1CCB A0 02 00     @nextCtl ldy   #2
3700 1CCE A7 0D                 lda   [ctlPtr]
3701 1CD0 85 09                 sta   ctlHndl
3702 1CD2 B7 0D                 lda   [ctlPtr],y
3703 1CD4 85 0B                 sta   ctlHndl+2
3704 1CD6 80 AA                 bra   @loop
3705 1CD8
3706 1CD8 A2 04 1B 22  @exit    _SetPort 
3707 1CDF 18                    clc                            ;displayed in the correct state.
3708 1CE0 60                    rts   
3709 1CE1
3710 1CE1 00 81 00 89  @nak     DC W:$8100,$8900,$8D00         ;These don't need invalidating ever.
3711 1CE7 FF 87                 DC W:$87ff                     ;added 20-May-91 DAL
3712 1CE9              @nakend   
3713 1CE9
3714 1CE9              *
3715 1CE9              * XLateApplePeriod
3716 1CE9              *
3717 1CE9              * Added 14-Feb-91 DAL: bit 31 of eventhook translates
3718 1CE9              *                      Apple-period into ESC
3719 1CE9              *
3720 1CE9 A5 3F        XlateApplePeriod lda   eventHook+2      ;bit 31 set?
3721 1CEB 10 32                 bpl   @noTranslate
3722 1CED A7 45                 lda   [<event]
3723 1CEF C9 05 00              cmp   #5                       ;auto key
3724 1CF2 F0 05                 beq   @xlate
3725 1CF4 C9 03 00              cmp   #3                       ;key down
3726 1CF7 D0 26                 bne   @noTranslate
3727 1CF9 A0 0E 00     @xlate   ldy   #14                      ;modifiers
3728 1CFC B7 45                 lda   [<event],y
3729 1CFE AA                    tax   
3730 1CFF 29 00 01              and   #$0100                   ;Apple key down?
3731 1D02 F0 1B                 beq   @noTranslate
3732 1D04 A0 02 00              ldy   #2                       ;message (key in low byte)
3733 1D07 B7 45                 lda   [<event],y
3734 1D09 29 FF 00              and   #$00ff
3735 1D0C C9 2E 00              cmp   #$002e                   ;period?
3736 1D0F D0 0E                 bne   @noTranslate
3737 1D11 A9 1B 00              lda   #$001b                   ;escape
3738 1D14 97 45                 sta   [<event],y
3739 1D16 8A                    txa   
3740 1D17 29 FF FE              and   #$ffff-$0100
3741 1D1A A0 0E 00              ldy   #14
3742 1D1D 97 45                 sta   [<event],y               ;new modifiers
3743 1D1F 60           @noTranslate rts   
3744 1D20              *** end of 14-Feb-91 DAL
3745 1D20
3746 1D20              ***
3747 1D20
3748 1D20 A5 21        doUpdate lda   code
3749 1D22 C9 06 00              cmp   #updateEvt
3750 1D25 F0 06                 beq   @a
3751 1D27 38                    sec   
3752 1D28 60                    rts                            ;Event isn't an update event.
3753 1D29
3754 1D29 64 21        @noUpdate stz   code                    ;We don't do this update, since the
3755 1D2B 18                    clc                            ;window that needs to be updated isn't
3756 1D2C 60                    rts                            ;the modal dialog.
3757 1D2D
3758 1D2D A0 04 00     @a       ldy   #omessage+2              ;Find out which window we are
3759 1D30 B7 45                 lda   [event],y                ;talking about.
3760 1D32 85 1F                 sta   tempwptr+2
3761 1D34 AA                    tax   
3762 1D35 88                    dey   
3763 1D36 88                    dey   
3764 1D37 B7 45                 lda   [event],y
3765 1D39 85 1D                 sta   tempwptr
3766 1D3B A8                    tay   
3767 1D3C
3768 1D3C A5 37                 lda   flags
3769 1D3E 29 00 40              and   #mwUpdateAll
3770 1D41 D0 0F                 bne   @doUpdate                ;We are movable/modal, so update it, whatever it is.
3771 1D43
3772 1D43 C4 01                 cpy   dlgwptr
3773 1D45 D0 04                 bne   @backgndUpdate
3774 1D47 E4 03                 cpx   dlgwptr+2
3775 1D49 F0 07                 beq   @doUpdate
3776 1D4B
3777 1D4B              @backgndUpdate  
3778 1D4B              *** added 5-Apr-93 DAL for 6.0.1d17 -- Zero out code so we will blink insertion points even if
3779 1D4B              ***   we never handling pending updates behind our dialog.
3780 1D4B 64 21                 stz   code
3781 1D4D              *** end 5-Apr-93
3782 1D4D F4 00 80              pea   $8000                    ;UpdateWindow flags (update a background window if possible)
3783 1D50 80 03                 bra   @commonUpdate
3784 1D52
3785 1D52 F4 00 00     @doUpdate pea   0                       ;UpdateWindow flags (19-Jun-92 DAL)
3786 1D55 D4 1F        @commonUpdate pei   <tempwptr+2
3787 1D57 D4 1D                 pei   <tempwptr
3788 1D59              ;	_UpdateWindow
3789 1D59 A2 0E 6C              ldx   #$6c0e
3790 1D5C 22 00 00 E1           jsl   $e10000
3791 1D60              *** end 6-Mar-92
3792 1D60
3793 1D60 18           @exit    clc   
3794 1D61 60                    rts   
3795 1D62
3796 1D62              ***
3797 1D62
3798 1D62 A5 21        doMouseDown lda   code
3799 1D64 C9 01 00              cmp   #mouseDownEvt
3800 1D67 F0 02                 beq   @a
3801 1D69 38                    sec   
3802 1D6A 60                    rts   
3803 1D6B
3804 1D6B 48           @a       pha                            ;Find out what window we clicked on.
3805 1D6C D4 2D                 pei   zero
3806 1D6E 7B                    tdc   
3807 1D6F 18                    clc   
3808 1D70 69 19 00              adc   #whichWindow
3809 1D73 48                    pha   
3810 1D74 A0 0C 00              ldy   #owhere+2
3811 1D77 B7 45                 lda   [event],y
3812 1D79 85 27                 sta   xloc
3813 1D7B 48                    pha   
3814 1D7C 88                    dey   
3815 1D7D 88                    dey   
3816 1D7E B7 45                 lda   [event],y
3817 1D80 85 25                 sta   yloc
3818 1D82 48                    pha   
3819 1D83 A2 0E 17 22           _FindWindow 
3820 1D8A 68                    pla   
3821 1D8B 10 1A                 bpl   @aa
3822 1D8D
3823 1D8D AA                    tax                            ;Keep it for _SystemClick's use.
3824 1D8E A5 37                 lda   flags
3825 1D90 29 10 00              and   #mwDeskAcc
3826 1D93 F0 74                 beq   @toBeep
3827 1D95
3828 1D95 D4 47                 pei   event+2                  ;Let the DA have some fun, too.
3829 1D97 D4 45                 pei   event
3830 1D99 D4 1B                 pei   whichWindow+2
3831 1D9B D4 19                 pei   whichWindow
3832 1D9D DA                    phx   
3833 1D9E A2 05 17 22           _SystemClick 
3834 1DA5 18                    clc   
3835 1DA6 60                    rts   
3836 1DA7
3837 1DA7 C9 14 00     @aa      cmp   #wInDrag
3838 1DAA D0 39                 bne   @b
3839 1DAC
3840 1DAC 20 D9 22              jsr   isMyWindow               ;See if "whichWindow" equals dlgwptr.
3841 1DAF 90 58                 bcc   @toBeep                  ;Wrong window -- nice try, though.
3842 1DB1
3843 1DB1 A5 37                 lda   flags
3844 1DB3 10 2D                 bpl   @az                      ;@noBeep
3845 1DB5
3846 1DB5 A0 00 00              ldy   #0                       ;Drag resolution -- default.
3847 1DB8 5A                    phy   
3848 1DB9 D4 27                 pei   xloc                     ;Starting mouse location.
3849 1DBB D4 25                 pei   yloc
3850 1DBD F4 08 00              pea   8                        ;TaskMaster uses this value, so we do.
3851 1DC0 5A                    phy                            ;Default cursor boundary.
3852 1DC1 5A                    phy   
3853 1DC2 D4 03                 pei   dlgwptr+2
3854 1DC4 D4 01                 pei   dlgwptr
3855 1DC6 A2 0E 1A 22           _DragWindow 
3856 1DCD A0 0E 00              ldy   #omodifiers
3857 1DD0 B7 45                 lda   [event],y
3858 1DD2 29 00 01              and   #appleKey
3859 1DD5 D0 0B                 bne   @az
3860 1DD7 D4 03                 pei   dlgwptr+2
3861 1DD9 D4 01                 pei   dlgwptr
3862 1DDB A2 0E 11 22           _SelectWindow 
3863 1DE2 82 C1 00     @az      brl   @noBeep
3864 1DE5
3865 1DE5 C9 11 00     @b       cmp   #wInMenuBar
3866 1DE8 D0 10                 bne   @c                       ;Not in menu bar.
3867 1DEA A5 37                 lda   flags
3868 1DEC 4A                    lsr   a
3869 1DED 4A                    lsr   a
3870 1DEE 90 19                 bcc   @toBeep                  ;_MenuSelect not allowed -- go do beep.
3871 1DF0 A5 37                 lda   flags
3872 1DF2 29 06 00              and   #mwMenuSelect+mwMenuKey
3873 1DF5 F0 12                 beq   @toBeep                  ;Modal dialog, no menus allowed, so go
3874 1DF7                                                      ;do beep.
3875 1DF7 82 26 01              brl   doMenuTask               ;Movable/modal dialog, so go
3876 1DFA                                                      ;handle menu bar.
3877 1DFA
3878 1DFA C9 1B 00     @c       cmp   #wInFrame                ;Don't beep if on dialog frame.  This
3879 1DFD F0 05                 beq   @d                       ;branch is the most efficient sizewise,
3880 1DFF                                                      ;since we won't hit any controls.
3881 1DFF C9 13 00              cmp   #wInContent
3882 1E02 D0 05                 bne   @toBeep                  ;We didn't click in a content.
3883 1E04
3884 1E04 20 D9 22     @d       jsr   isMyWindow
3885 1E07 B0 03                 bcs   @e
3886 1E09 82 76 00     @toBeep  brl   @beep
3887 1E0C
3888 1E0C 48           @e       pha   
3889 1E0D 48                    pha   
3890 1E0E A2 0E 15 22           _FrontWindow 
3891 1E15              *** 20-May-91 DAL -- don't select the already-front window!
3892 1E15 A3 01                 lda   1,s
3893 1E17 C5 01                 cmp   <dlgwptr
3894 1E19 D0 06                 bne   @needToSelectIt
3895 1E1B A3 03                 lda   3,s
3896 1E1D C5 03                 cmp   <dlgwptr+2
3897 1E1F F0 0B                 beq   @alreadyFront
3898 1E21              @needToSelectIt  
3899 1E21              *** end of 20-May-91 DAL
3900 1E21 D4 03                 pei   dlgwptr+2
3901 1E23 D4 01                 pei   dlgwptr
3902 1E25 A2 0E 11 22           _SelectWindow 
3903 1E2C              @alreadyFront  
3904 1E2C 68                    pla   
3905 1E2D FA                    plx   
3906 1E2E C5 19                 cmp   whichWindow
3907 1E30 D0 74                 bne   @noBeep
3908 1E32 E4 1B                 cpx   whichWindow+2
3909 1E34 D0 70                 bne   @noBeep
3910 1E36
3911 1E36 48           @f       pha   
3912 1E37 D4 2D                 pei   zero
3913 1E39 7B                    tdc   
3914 1E3A 18                    clc   
3915 1E3B 69 09 00              adc   #ctlHndl
3916 1E3E 48                    pha   
3917 1E3F D4 27                 pei   xloc
3918 1E41 D4 25                 pei   yloc
3919 1E43 D4 03                 pei   dlgwptr+2
3920 1E45 D4 01                 pei   dlgwptr
3921 1E47 A2 10 13 22           _FindControl 
3922 1E4E 68                    pla   
3923 1E4F F0 55                 beq   @noBeep                  ;Missed all of the controls.
3924 1E51
3925 1E51 20 A8 21              jsr   fixLEflash
3926 1E54
3927 1E54 48                    pha   
3928 1E55 D4 27                 pei   xloc
3929 1E57 D4 25                 pei   yloc
3930 1E59 A9 FF FF              lda   #-1
3931 1E5C 48                    pha   
3932 1E5D 48                    pha   
3933 1E5E D4 0B                 pei   ctlHndl+2
3934 1E60 D4 09                 pei   ctlHndl
3935 1E62 A2 10 15 22           _TrackControl 
3936 1E69 68                    pla   
3937 1E6A 8F 3F 23 02           sta   >ctlPart
3938 1E6E F0 36                 beq   @noBeep
3939 1E70
3940 1E70 A0 1E 00              ldy   #owmTaskData2            ;Put the found control in TaskData2
3941 1E73 A5 09                 lda   ctlHndl                  ;for application.
3942 1E75 97 45                 sta   [event],y
3943 1E77 C8                    iny   
3944 1E78 C8                    iny   
3945 1E79 A5 0B                 lda   ctlHndl+2
3946 1E7B 97 45                 sta   [event],y
3947 1E7D 20 D9 21              jsr   setValues
3948 1E80 18                    clc   
3949 1E81 60                    rts   
3950 1E82
3951 1E82 A5 3B        @beep    lda   beepProc+2
3952 1E84 30 20                 bmi   @noBeep                  ;Negative, do nothing.
3953 1E86 05 39                 ora   beepProc
3954 1E88 F0 12                 beq   @sysBeep                 ;Zero, regular SysBeep.
3955 1E8A
3956 1E8A D4 47                 pei   event+2                  ;Give the custom "beep" something
3957 1E8C D4 45                 pei   event                    ;to play with.
3958 1E8E 4B                    phk                            ;Push where we want to return to.
3959 1E8F F4 A5 21              pea   @noBeep-1
3960 1E92 A5 3A                 lda   beepProc+1               ;Push beepProc addr and return to it.
3961 1E94 48                    pha   
3962 1E95 8B                    phb   
3963 1E96 68                    pla   
3964 1E97 A5 39                 lda   beepProc
3965 1E99 3A                    dec   a
3966 1E9A 48                    pha   
3967 1E9B 6B                    rtl   
3968 1E9C F4 04 00     @sysBeep pea   4                        ;clicked outside the dialog
3969 1E9F A2 03 38 22           _SysBeep2 
3970 1EA6 18           @noBeep  clc   
3971 1EA7 60                    rts   
3972 1EA8
3973 1EA8 20 FA 1E     fixLEflash jsr   getCtlProc
3974 1EAB C9 00 83              cmp   #editLineControl>>16
3975 1EAE D0 28                 bne   @rts
3976 1EB0 A0 3C 00              ldy   #octlMoreFlags
3977 1EB3 B7 0D                 lda   [ctlPtr],y
3978 1EB5 30 21                 bmi   @rts                     ;LineEdit control already target.
3979 1EB7
3980 1EB7 A0 1C 00              ldy   #octlData                ;For lineEdit controls that are
3981 1EBA B7 0D                 lda   [ctlPtr],y               ;inactive, make sure that there is no
3982 1EBC 85 11                 sta   theHndl                  ;text currently selected.  If there is,
3983 1EBE C8                    iny                            ;TrackControl will temporarily flash
3984 1EBF C8                    iny                            ;the selected range.  So, we check to
3985 1EC0 B7 0D                 lda   [ctlPtr],y               ;see if we are a lineEdit control.  If
3986 1EC2 85 13                 sta   theHndl+2                ;we are, we see if we are active.  If
3987 1EC4 A0 02 00              ldy   #2                       ;we aren't, we set selEnd to be the
3988 1EC7 A7 11                 lda   [theHndl]                ;same as selStart.  Simple, huh?
3989 1EC9 85 15                 sta   thePtr
3990 1ECB B7 11                 lda   [theHndl],y
3991 1ECD 85 17                 sta   thePtr+2
3992 1ECF
3993 1ECF A0 20 00              ldy   #oleSelStart             ;thePtr is deref'ed lineEdit record.
3994 1ED2 B7 15                 lda   [thePtr],y               ;Set selEnd to be the same as selStart.
3995 1ED4 C8                    iny   
3996 1ED5 C8                    iny   
3997 1ED6 97 15                 sta   [thePtr],y               ;It is done.  It is good.  The end.
3998 1ED8
3999 1ED8 60           @rts     rts   
4000 1ED9
4001 1ED9              ***
4002 1ED9
4003 1ED9 48           setValues pha                           ;Convert the control handle into an ID
4004 1EDA 48                    pha                            ;for application.
4005 1EDB D4 0B                 pei   ctlHndl+2
4006 1EDD D4 09                 pei   ctlHndl
4007 1EDF A2 10 2A 22           _GetCtlID 
4008 1EE6 68                    pla   
4009 1EE7 7A                    ply   
4010 1EE8 B0 04                 bcs   @a                       ;List controls have non-super-control
4011 1EEA                                                      ;scrollbars.  We therefore don't want
4012 1EEA                                                      ;to return a control-id here, since
4013 1EEA                                                      ;non-super-controls don't have an id to
4014 1EEA                                                      ;return anyway.  (We get an error $1007
4015 1EEA                                                      ;if it isn't a super-control, so we
4016 1EEA                                                      ;don't want to return anything
4017 1EEA                                                      ;anything, since it garbage.)
4018 1EEA 85 49                 sta   retval
4019 1EEC 84 4B                 sty   retval+2                 ;Return the ctlID in retval.
4020 1EEE
4021 1EEE 20 FA 1E     @a       jsr   getCtlProc               ;See if radio button or checkbox.
4022 1EF1 C9 00 84              cmp   #radioControl>>16
4023 1EF4 F0 25                 beq   @radioButtonHit
4024 1EF6 C9 00 82              cmp   #checkControl>>16
4025 1EF9 D0 1F                 bne   @rts
4026 1EFB
4027 1EFB 48           @checkBoxHit pha   
4028 1EFC D4 0B                 pei   ctlHndl+2
4029 1EFE D4 09                 pei   ctlHndl
4030 1F00 A2 10 1A 22           _GetCtlValue 
4031 1F07 68                    pla   
4032 1F08 F0 03                 beq   @c                       ;Do a true NOT.
4033 1F0A A9 FF FF              lda   #$FFFF
4034 1F0D 1A           @c       inc   a
4035 1F0E 48           @d       pha   
4036 1F0F D4 0B                 pei   ctlHndl+2
4037 1F11 D4 09                 pei   ctlHndl
4038 1F13 A2 10 19 22           _SetCtlValue 
4039 1F1A 60           @rts     rts   
4040 1F1B
4041 1F1B A9 01 00     @radioButtonHit lda   #1
4042 1F1E 80 EE                 bra   @d
4043 1F20
4044 1F20 18           doMenuTask clc   
4045 1F21 08           doMenuTaskz php                         ;Keep carry status.
4046 1F22 D4 47                 pei   event+2
4047 1F24 D4 45                 pei   event
4048 1F26 A9 00 00              lda   #0
4049 1F29 48                    pha   
4050 1F2A 48                    pha   
4051 1F2B B0 11                 bcs   @b
4052 1F2D 20 FB 22              jsr   ibeamTest
4053 1F30 90 03                 bcc   @a
4054 1F32 20 2C 23              jsr   doInitCursor             ;This only gets done if it is currently an ibeam.
4055 1F35 A2 0F 2B 22  @a       _MenuSelect                    ;Handle the pullDown.
4056 1F3C 80 07                 bra   @c
4057 1F3E A2 0F 09 22  @b       _MenuKey                       ;Handle the menu key.
4058 1F45
4059 1F45 28           @c       plp                            ;Restore carry status.
4060 1F46 A0 10 00              ldy   #owmTaskData
4061 1F49 B7 45                 lda   [event],y
4062 1F4B F0 65                 beq   @rts                     ;PullDown, cclear.  MenuKey, cset.
4063 1F4D AA                    tax   
4064 1F4E C8                    iny   
4065 1F4F C8                    iny   
4066 1F50 B7 45                 lda   [event],y
4067 1F52 85 2B                 sta   menunum
4068 1F54
4069 1F54 E0 FA 00              cpx   #250                     ;See if we should open a DA.
4070 1F57 B0 16                 bcs   @d
4071 1F59
4072 1F59 A5 37                 lda   flags                    ;See if we should handle DA's.
4073 1F5B 29 10 00              and   #mwDeskAcc
4074 1F5E F0 3D                 beq   @y                       ;No, so hilite menu to normal.
4075 1F60 DA                    phx                            ;Open the can-o-worms.
4076 1F61 DA                    phx   
4077 1F62 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
4078 1F65 A2 05 15 22           _OpenNDA 
4079 1F6C 68                    pla   
4080 1F6D 80 2E                 bra   @y                       ;Do _HiliteMenu and leave.
4081 1F6F
4082 1F6F E0 00 01     @d       cpx   #256                     ;Anything above close, let app do it.
4083 1F72 B0 36                 bcs   @z                       ;Not an undo/cut/copy/paste/clear/close
4084 1F74                                                      ;menu item.
4085 1F74
4086 1F74 A4 29                 ldy   wkind
4087 1F76 10 16                 bpl   @e
4088 1F78
4089 1F78 E0 FF 00              cpx   #255
4090 1F7B F0 36                 beq   @closeNDA                ;Go let the DA handle it.
4091 1F7D
4092 1F7D 8A                    txa   
4093 1F7E 38                    sec   
4094 1F7F E9 F9 00              sbc   #249
4095 1F82 48                    pha   
4096 1F83 48                    pha   
4097 1F84 A2 05 18 22           _SystemEdit 
4098 1F8B 68                    pla   
4099 1F8C 80 0F                 bra   @y                       ;Do _HiliteMenu and leave.
4100 1F8E
4101 1F8E E0 FF 00     @e       cpx   #255
4102 1F91 F0 17                 beq   @z                       ;Let app do close for non DA windows.
4103 1F93 E0 FA 00              cpx   #250
4104 1F96 F0 12                 beq   @z                       ;Let app do undo also.
4105 1F98
4106 1F98 86 23                 stx   editTask                 ;Let cut/copy/paste know what to do.
4107 1F9A 20 CB 1D              jsr   doCutCopyPaste
4108 1F9D
4109 1F9D D4 2D        @y       pei   zero
4110 1F9F D4 2B                 pei   menunum
4111 1FA1 A2 0F 2C 22           _HiliteMenu 
4112 1FA8 18                    clc   
4113 1FA9 60                    rts   
4114 1FAA
4115 1FAA 86 49        @z       stx   retval                   ;Low-order word contains the ID # of
4116 1FAC 09 00 80              ora   #$8000                   ;item selected.  Hi-order word contains
4117 1FAF 85 4B                 sta   retval+2                 ;the menu ID # with hi-bit turned on.
4118 1FB1 18                    clc                            ;The hi-bit is to allow the application
4119 1FB2                                                      ;to distinguish this from a control ID.
4120 1FB2                                                      ;This means ID's must be hi-bit off!!
4121 1FB2 60           @rts     rts   
4122 1FB3
4123 1FB3 48           @closeNDA pha   
4124 1FB4 48                    pha   
4125 1FB5 A2 0E 15 22           _FrontWindow 
4126 1FBC A3 01                 lda   1,s                      ;Be extra paranoid -- it helps.
4127 1FBE C5 05                 cmp   keepPort                 ;Make sure that the desk accessory was
4128 1FC0 D0 0E                 bne   @db                      ;not active port when fakeModalDialog
4129 1FC2 A3 03                 lda   3,s                      ;was called.  If it is, we will get
4130 1FC4 C5 07                 cmp   keepPort+2               ;into trouble closing it, because we
4131 1FC6 D0 08                 bne   @db                      ;will do a SetPort to keepPort when we
4132 1FC8 A5 01                 lda   dlgwptr                  ;leave.  So, if keepPort is the port we
4133 1FCA 85 05                 sta   keepPort                 ;are about to close, change it to the
4134 1FCC A5 03                 lda   dlgwptr+2                ;dlgwptr (the app's dialog window).
4135 1FCE 85 07                 sta   keepPort+2
4136 1FD0 A2 05 1C 22  @db      _CloseNDAByWinPtr 
4137 1FD7 80 C4                 bra   @y
4138 1FD9
4139 1FD9 A5 19        isMyWindow lda   whichWindow
4140 1FDB C5 01                 cmp   dlgwptr
4141 1FDD D0 06                 bne   @no
4142 1FDF A5 1B                 lda   whichWindow+2
4143 1FE1 C5 03                 cmp   dlgwptr+2
4144 1FE3 F0 01                 beq   @yes
4145 1FE5 18           @no      clc   
4146 1FE6 60           @yes     rts   
4147 1FE7
4148 1FE7              ***
4149 1FE7
4150 1FE7 A5 21        doMenuKey lda   code
4151 1FE9 C9 03 00              cmp   #keyDownEvt
4152 1FEC F0 02                 beq   @a
4153 1FEE 38                    sec   
4154 1FEF 60           @rts     rts                            ;It isn't a menu key, since it isn't
4155 1FF0                                                      ;even a key.
4156 1FF0
4157 1FF0 A5 37        @a       lda   flags
4158 1FF2 29 04 00              and   #mwMenuKey
4159 1FF5 38                    sec   
4160 1FF6 F0 F7                 beq   @rts                     ;Menu keys not allowed (carry is set).
4161 1FF8
4162 1FF8 82 26 FF              brl   doMenuTaskz              ;Carry still set, which is important.
4163 1FFB
4164 1FFB              ***
4165 1FFB
4166 1FFB              *** IBeamTest -- return SEC if we're displaying the I-Beam cursor
4167 1FFB
4168 1FFB A5 29        ibeamTest lda   wkind
4169 1FFD 18                    clc   
4170 1FFE 30 1F                 bmi   @rts                     ;Don't do our ibeam when a DA is up.
4171 2000 48                    pha                            ;This is so we know what cursor we
4172 2001 48                    pha                            ;currently have.  Otherwise, we will be
4173 2002 A2 04 8F 22           _GetCursorAdr                  ;setting the cursor a lot, and it will
4174 2009
4175 2009              ;	pha		;flash.
4176 2009              ;	pha
4177 2009              ;	jsl	fmdGetIBeamAdr	;This clears carry (no error returned.)
4178 2009              ;	pla
4179 2009              ;	ply
4180 2009
4181 2009 18                    clc   
4182 200A AF 22 23 02           lda   >theIBeamAdr+2
4183 200E A8                    tay   
4184 200F AF 20 23 02           lda   >theIBeamAdr             ;DAL
4185 2013
4186 2013 43 01                 eor   1,s
4187 2015 D0 06                 bne   @no                      ;Carry is clear.
4188 2017 98                    tya   
4189 2018 43 03                 eor   3,s
4190 201A D0 01                 bne   @no                      ;Carry is clear.
4191 201C 38                    sec   
4192 201D 68           @no      pla   
4193 201E 68                    pla   
4194 201F 60           @rts     rts                            ;Carry set means we now have ibeam.
4195 2020
4196 2020                       export theIBeamAdr 
4197 2020 00 00 00 00  theIBeamAdr DC L:0
4198 2024
4199 2024 A2 0E 67 22  doStdDrawProc _MWStdDrawProc 
4200 202B 6B                    rtl   
4201 202C
4202 202C                       EndP 
4203 202C
4204 202C              **********************************************************************
4205 202C              *
4206 202C              * doInitCursor
4207 202C              *
4208 202C              * (JSRing here instead of _InitCursor saves 4 bytes per.)
4209 202C              *
4210 202C              **********************************************************************
4211 202C              doInitCursor proc export 
4212 202C A2 04 CA 22           _InitCursor 
4213 2033 60                    rts   
4214 2034                       EndP 
4215 2034
4216 2034              **********************************************************************
4217 2034              *
4218 2034              * $650E MWGetCtlPart -- new call 22-Jan-91 DAL
4219 2034              *
4220 2034              * Input:
4221 2034              *   WORD  space for result
4222 2034              *
4223 2034              **********************************************************************
4224 2034              MWGetCtlPart proc export 
4225 2034
4226 2034 AF 3F 23 02           lda   >ctlPart
4227 2038 83 07                 sta   7,s
4228 203A A9 00 00              lda   #0
4229 203D 18                    clc   
4230 203E 6B                    rtl   
4231 203F
4232 203F                       export ctlPart 
4233 203F 00 00        ctlPart  DC W:0
4234 2041
4235 2041                       EndP 
4236 2041
4237 2041              **********************************************************************
4238 2041              *
4239 2041              * $660E MWSetMenuProc -- new call 19-Jan-91 DAL
4240 2041              *
4241 2041              * Input:
4242 2041              *   LONG space for result: old menu proc
4243 2041              *   LONG pointer to menu proc, $FFFFFFFF to leave unchanged
4244 2041              *
4245 2041              * To tell fakeModalDialog to automatically call a menu update routine when
4246 2041              * it gets an activate event, make a call to fmdSetMenuProc.  For an application
4247 2041              * menu update routine called appSetMenus, you would tell fakeModalDialog
4248 2041              * about it by the following:
4249 2041              *     ignore = fmdSetMenuProc(appSetMenus);
4250 2041              * To turn off menu updating again, do this:
4251 2041              *     ignore = fmdSetMenuProc(NULL);
4252 2041              *
4253 2041              **********************************************************************
4254 2041              MWSetMenuProc proc export 
4255 2041
4256 2041              newProc  equ   7                        ;on stack
4257 2041              result   equ   newProc+4                ;on stack
4258 2041
4259 2041 AF 69 23 02           lda   >menuProc+2
4260 2045 83 0D                 sta   result+2,s
4261 2047 AF 67 23 02           lda   >menuProc
4262 204B 83 0B                 sta   result,s
4263 204D
4264 204D A3 09                 lda   newProc+2,s
4265 204F 1A                    inc   a
4266 2050 F0 0B                 beq   @noChange                ;$FFFFxxxx = keep old value
4267 2052 3A                    dec   a
4268 2053 8F 69 23 02           sta   >menuProc+2
4269 2057 A3 07                 lda   newProc,s
4270 2059 8F 67 23 02           sta   >menuProc
4271 205D
4272 205D A2 00 00     @noChange ldx   #0                      ;no error
4273 2060 A0 04 00              ldy   #4                       ;strip 4 bytes of input
4274 2063 5C 84 01 E1           jml   $e10184                  ;ToStrip
4275 2067
4276 2067                       export MenuProc 
4277 2067 00 00 00 00  MenuProc DC L:0
4278 206B
4279 206B                       EndP 
4280 206B
4281 206B              **********************************************************************
4282 206B              *
4283 206B              * $670E MWStdDrawProc -- new call 22-Jan-91 DAL
4284 206B              *
4285 206B              * Input: none
4286 206B              *
4287 206B              * Window to draw is current port.  We always draw the controls, and
4288 206B              * we may also draw our own "alert" type frame inside the content.
4289 206B              *
4290 206B              **********************************************************************
4291 206B              MWStdDrawProc proc export 
4292 206B
4293 206B 48                    pha                            ;What kind of window frame do we want?
4294 206C 48                    pha   
4295 206D 48                    pha   
4296 206E A2 04 1C 22           _GetPort 
4297 2075 A2 0E 2C 22           _GetWFrame 
4298 207C 68                    pla                            ;fAlert is bit 13.  fFlex is bit 9.
4299 207D 0A                    asl   a
4300 207E 0A                    asl   a                        ;fAlert is now in bit 15.
4301 207F 30 4F                 bmi   @noFrame                 ;We already have a frame, and
4302 2081                                                      ;it looks maaahvelous!
4303 2081
4304 2081 29 00 08              and   #$0800                   ;Bit 9 moved into bit 11.
4305 2084 D0 4A                 bne   @noFrame
4306 2086
4307 2086 48                    pha   
4308 2087 A2 04 17 22           _GetMasterSCB 
4309 208E 68                    pla   
4310 208F EB                    xba   
4311 2090 0A                    asl   a
4312 2091 A9 05 00              lda   #5
4313 2094 B0 01                 bcs   @in640
4314 2096 4A                    lsr   a
4315 2097 48           @in640   pha                            ;Keep the width for _InsetRect.
4316 2098 48                    pha                            ;Push the width for _FrameRect.
4317 2099 F4 02 00              pea   2
4318 209C A2 04 2C 22           _SetPenSize 
4319 20A3 FA                    plx                            ;The width for _InsetRect.
4320 20A4 A9 E1 23              lda   #@workRect
4321 20A7 A0 02 00              ldy   #@workRect>>16
4322 20AA 5A                    phy                            ;Push parameters for _FrameRect.
4323 20AB 48                    pha   
4324 20AC 5A                    phy                            ;Push parameters for _InsetRect.
4325 20AD 48                    pha   
4326 20AE DA                    phx                            ;Push the width for _InsetRect.
4327 20AF F4 02 00              pea   2
4328 20B2 5A                    phy                            ;Push parameters for _GetPortRect.
4329 20B3 48                    pha   
4330 20B4 A2 04 20 22           _GetPortRect 
4331 20BB A2 04 4C 22           _InsetRect 
4332 20C2 A2 04 53 22           _FrameRect 
4333 20C9 A2 04 36 22           _PenNormal 
4334 20D0
4335 20D0 48           @noFrame pha   
4336 20D1 48                    pha   
4337 20D2 A2 04 1C 22           _GetPort 
4338 20D9 A2 10 10 22           _DrawControls 
4339 20E0 6B                    rtl   
4340 20E1
4341 20E1 00 00 00 00  @workRect DS W:4
4342 20E9
4343 20E9                       EndP 
4344 20E9
4345 20E9              **********************************************************************
4346 20E9              *
4347 20E9              * $680E MWSetUpEditMenu -- new call 19-Jan-91 DAL
4348 20E9              *
4349 20E9              * Input:
4350 20E9              *
4351 20E9              *
4352 20E9              * fmdEditMenu figures the state of cut, copy, paste, and clear in
4353 20E9              * the edit menu based on the state of controls in the window.
4354 20E9              * It looks up the target control (either lineEdit or textEdit) and
4355 20E9              * then sets the states appropriately.  For lineEdit, if anything
4356 20E9              * is selected, then cut, copy and clear are available.  If there is
4357 20E9              * anything in the scrap, then paste is also available.  TextEdit 
4358 20E9              * works the same way, unless the textEdit control is a read-only
4359 20E9              * control.  In that case, cut, paste, and clear are not available.
4360 20E9              * If there is no lineEdit or textEdit control, then the state of
4361 20E9              * these menu items is left alone.  The application needs to take care
4362 20E9              * of them in that case.  (It is possible that there are custom
4363 20E9              * controls for the application that can use these menu items, and
4364 20E9              * there is no way for fakeModalDialog to know about them.  Therefore
4365 20E9              * the correct thing to do is to do nothing.)
4366 20E9              *
4367 20E9              **********************************************************************
4368 20E9              MWSetUpEditMenu proc export 
4369 20E9
4370 20E9                       DefineStack 
4371 20E9              selStart long 
4372 20E9              selEnd   long 
4373 20E9              leHndl   long 
4374 20E9              lePtr    long 
4375 20E9              ctlPtr   long                           ;Must be 2nd from end of local space.
4376 20E9              ctlHndl  long                           ;Must be at end of local space.
4377 20E9              sizeLocals EndLocals 
4378 20E9
4379 20E9              saveDPage word 
4380 20E9              returnAddr block 6                      ;was 3 (DAL)
4381 20E9
4382 20E9 0B                    phd                            ;Save directPage register.
4383 20EA
4384 20EA 3B                    tsc                            ;Make space for locals, part 1.
4385 20EB 38                    sec   
4386 20EC E9 18 00              sbc   #sizeLocals
4387 20EF 5B                    tcd   
4388 20F0
4389 20F0 48                    pha                            ;Find out if it is a DA window.
4390 20F1 48                    pha   
4391 20F2 48                    pha   
4392 20F3 A2 0E 15 22           _FrontWindow 
4393 20FA A2 0E 2B 22           _GetWKind 
4394 2101 68                    pla   
4395 2102 10 1A                 bpl   @a                       ;It is a regular window.
4396 2104 F4 FA 00              pea   250
4397 2107 A2 0F 30 22           _EnableMItem                   ;Enable undo.
4398 210E F4 FF 00              pea   255
4399 2111 A2 0F 30 22           _EnableMItem                   ;Enable close.
4400 2118 A2 0F 00              ldx   #%1111                   ;Enable cut/copy/paste/clear.
4401 211B 82 9B 00              brl   @setMenus
4402 211E
4403 211E 48           @a       pha   
4404 211F 48                    pha   
4405 2120 A2 10 26 22           _FindTargetCtl 
4406 2127 90 03                 bcc   @aa                      ;There is a target, so go do some work.
4407 2129 82 8A 00              brl   @noTool
4408 212C
4409 212C A0 02 00     @aa      ldy   #2                       ;Deref target ctl handle into ctlPtr.
4410 212F B7 15                 lda   [ctlHndl],y
4411 2131 48                    pha   
4412 2132 A7 15                 lda   [ctlHndl]
4413 2134 48                    pha   
4414 2135
4415 2135 7B                    tdc                            ;Make space for locals, part 2.
4416 2136 1B                    tcs                            ;Stack ptr & directPage ptr agree now.
4417 2137
4418 2137 A0 16 00              ldy   #octlProc+2              ;Get hi-word of proc address.
4419 213A B7 11                 lda   [ctlPtr],y
4420 213C
4421 213C
4422 213C C9 00 85              cmp   #editTextControl>>16
4423 213F F0 35                 beq   @textEdit                ;It is TextEdit tool.
4424 2141 C9 00 83              cmp   #editLineControl>>16
4425 2144 D0 70                 bne   @noTool                  ;Not LineEdit tool.
4426 2146
4427 2146 A0 1C 00     @lineEdit ldy   #octlData               ;Get the lineEdit handle from
4428 2149 B7 11                 lda   [ctlPtr],y               ;the control's data field.
4429 214B 85 09                 sta   leHndl
4430 214D C8                    iny   
4431 214E C8                    iny   
4432 214F B7 11                 lda   [ctlPtr],y
4433 2151 85 0B                 sta   leHndl+2
4434 2153
4435 2153 A0 02 00              ldy   #2                       ;Dereference leHndl.
4436 2156 A7 09                 lda   [leHndl]
4437 2158 85 0D                 sta   lePtr
4438 215A B7 09                 lda   [leHndl],y
4439 215C 85 0F                 sta   lePtr+2
4440 215E
4441 215E A2 00 00              ldx   #0
4442 2161 20 EF 24              jsr   canWePaste
4443 2164
4444 2164 A0 20 00              ldy   #oleSelStart
4445 2167 B7 0D                 lda   [lePtr],y
4446 2169 C8                    iny   
4447 216A C8                    iny   
4448 216B D7 0D                 cmp   [lePtr],y
4449 216D F0 4A                 beq   @setMenus
4450 216F 8A                    txa   
4451 2170 09 0B 00              ora   #%1011                   ;Enable cut/copy/clear.
4452 2173 AA                    tax   
4453 2174 80 43                 bra   @setMenus
4454 2176
4455 2176 A0 00 00     @textEdit ldy   #0
4456 2179 5A                    phy   
4457 217A 7B                    tdc   
4458 217B 18                    clc   
4459 217C 69 01 00              adc   #selStart
4460 217F 48                    pha   
4461 2180 5A                    phy   
4462 2181 69 04 00              adc   #selEnd-selStart
4463 2184 48                    pha   
4464 2185 D4 17                 pei   ctlHndl+2
4465 2187 D4 15                 pei   ctlHndl
4466 2189 A2 22 1C 22           _TEGetSelection 
4467 2190 A2 0B 00              ldx   #%1011
4468 2193 A5 01                 lda   selStart
4469 2195 C5 05                 cmp   selEnd
4470 2197 D0 09                 bne   @hasSelect
4471 2199 A5 03                 lda   selStart+2
4472 219B C5 07                 cmp   selEnd+2
4473 219D D0 03                 bne   @hasSelect
4474 219F A2 00 00              ldx   #0
4475 21A2
4476 21A2 20 EF 24     @hasSelect jsr   canWePaste
4477 21A5
4478 21A5 A0 2A 00              ldy   #$28+2                   ;Find out if we are read-only.
4479 21A8 B7 11                 lda   [ctlPtr],y
4480 21AA 29 00 04              and   #$0400                   ;Bit 26, please.
4481 21AD F0 0A                 beq   @setMenus
4482 21AF
4483 21AF 8A                    txa                            ;Don't allow cut & paste.
4484 21B0 29 02 00              and   #2
4485 21B3 AA                    tax   
4486 21B4 80 03                 bra   @setMenus
4487 21B6
4488 21B6 A2 00 00     @noTool  ldx   #0                       ;Bit 0 for cut, 1 for copy,
4489 21B9                                                      ;2 for paste.
4490 21B9 8A           @setMenus txa   
4491 21BA A0 FB 00              ldy   #251
4492 21BD 20 D5 24              jsr   setOneMenu
4493 21C0 20 D5 24              jsr   setOneMenu
4494 21C3 20 D5 24              jsr   setOneMenu
4495 21C6 20 D5 24              jsr   setOneMenu
4496 21C9
4497 21C9 7B           @exit    tdc                            ;Remove local space.
4498 21CA 18                    clc   
4499 21CB 69 18 00              adc   #sizeLocals
4500 21CE 1B                    tcs   
4501 21CF 2B                    pld                            ;Restore directPage register.
4502 21D0
4503 21D0 A9 00 00              lda   #0
4504 21D3 18                    clc   
4505 21D4 6B                    rtl   
4506 21D5
4507 21D5 4A           setOneMenu lsr   a
4508 21D6 48                    pha   
4509 21D7 5A                    phy   
4510 21D8 5A                    phy   
4511 21D9 B0 09                 bcs   @enable
4512 21DB A2 0F 31 22  @disable _DisableMItem 
4513 21E2 80 07                 bra   @a
4514 21E4 A2 0F 30 22  @enable  _EnableMItem 
4515 21EB 7A           @a       ply   
4516 21EC C8                    iny   
4517 21ED 68                    pla   
4518 21EE 60                    rts   
4519 21EF
4520 21EF 8A           canWePaste txa                          ;Assume no paste.
4521 21F0 29 FB FF              and   #$FFFF-4
4522 21F3 48                    pha   
4523 21F4
4524 21F4 48                    pha                            ;See if paste should be available.
4525 21F5 48                    pha   
4526 21F6 F4 00 00              pea   0
4527 21F9 A2 16 0F 22           _GetScrapSize 
4528 2200 FA                    plx   
4529 2201 7A                    ply   
4530 2202
4531 2202 68                    pla                            ;Get cut/copy/paste status back.
4532 2203
4533 2203 B0 0A                 bcs   @exit                    ;Error, so no paste.
4534 2205 5A                    phy   
4535 2206 7A                    ply   
4536 2207 D0 03                 bne   @yes
4537 2209 9B                    txy   
4538 220A F0 03                 beq   @exit
4539 220C 09 04 00     @yes     ora   #4
4540 220F
4541 220F AA           @exit    tax   
4542 2210 60                    rts   
4543 2211
4544 2211                       EndP 
4545 2211
4546 2211              **********************************************************************
4547 2211              *
4548 2211              * $690E FindCursorCtl -- new call 22-Jan-91 DAL
4549 2211              *
4550 2211              * Input:
4551 2211              *    LONG  pointer to buffer to receive control handle
4552 2211              *    WORD  X position
4553 2211              *    WORD  Y position
4554 2211              *    LONG  window pointer
4555 2211              *
4556 2211              * FindCursorCtl is used to find which control is at a certain point.
4557 2211              * The toolbox call FindControl can't be used for this because TextEdit
4558 2211              * controls become active when called with a point in them.  That is not
4559 2211              * the desired effect of fmdFindCursorCtl.  If you just want to know what
4560 2211              * control you are over and have nothing affected, then use this entry
4561 2211              * point.  It is used by fakeModalDialog to determine whether or not to
4562 2211              * display an i-beam cursor.  If the i-beam bit is set and the user moves
4563 2211              * the mouse over a lineEdit or textEdit control, then the cursor changes
4564 2211              * to an i-beam.  Note that the scrollbars for a textEdit control are
4565 2211              * considered a separate control.  This is so that the cursor stays
4566 2211              * an arrow when over the scrollbars.
4567 2211              *
4568 2211              **********************************************************************
4569 2211              FindCursorCtl proc export 
4570 2211
4571 2211                       DefineStack 
4572 2211
4573 2211              hndl     long                           ;Must be at 1,s
4574 2211              ctlHndl  long 
4575 2211              ctlPtr   long 
4576 2211
4577 2211              sizeLocals EndLocals 
4578 2211
4579 2211              saveDPage word 
4580 2211              returnAddr block 6                      ;was 3 (DAL)
4581 2211
4582 2211                       BegParms 
4583 2211              wptr     long 
4584 2211              yloc     word 
4585 2211              xloc     word 
4586 2211              ctlHndlPtr long                         ;Where to store the control handle.
4587 2211              sizeParms EndParms 
4588 2211
4589 2211              ctlPart  word 
4590 2211
4591 2211 0B                    phd                            ;Save directPage register.
4592 2212 3B                    tsc                            ;Make space for locals.
4593 2213 38                    sec   
4594 2214 E9 0C 00              sbc   #sizeLocals
4595 2217 1B                    tcs   
4596 2218 5B                    tcd                            ;Set directPage register.
4597 2219
4598 2219 D4 17                 pei   wptr+2
4599 221B D4 15                 pei   wptr
4600 221D A2 0E 33 22           _GetWControls                  ;Result space already there (hndl).
4601 2224
4602 2224 64 21                 stz   ctlPart                  ;Assume failure.
4603 2226 64 05                 stz   ctlHndl
4604 2228 64 07                 stz   ctlHndl+2
4605 222A
4606 222A A5 02        @loop    lda   hndl+1
4607 222C F0 50                 beq   @exit                    ;No more controls to check.
4608 222E
4609 222E A0 02 00              ldy   #2                       ;Deref hndl.
4610 2231 A7 01                 lda   [hndl]
4611 2233 85 09                 sta   ctlPtr
4612 2235 B7 01                 lda   [hndl],y
4613 2237 85 0B                 sta   ctlPtr+2
4614 2239
4615 2239              *** added 10-Jun-91 DAL -- see if this control is invisible
4616 2239 A0 10 00              ldy   #octlFlag
4617 223C B7 09                 lda   [<ctlPtr],y
4618 223E 29 80 00              and   #$0080
4619 2241 D0 2E                 bne   @nextCtl
4620 2243              *** end of 10-Jun-91
4621 2243
4622 2243 48                    pha                            ;Result space for _PtInRect
4623 2244 F4 00 00              pea   0                        ;Push pointer to point.
4624 2247 7B                    tdc   
4625 2248 18                    clc   
4626 2249 69 19 00              adc   #yloc
4627 224C 48                    pha   
4628 224D A5 09                 lda   ctlPtr                   ;Push ptr to bounding rect of ctl.
4629 224F 18                    clc   
4630 2250 69 08 00              adc   #octlRect
4631 2253 AA                    tax   
4632 2254 A5 0B                 lda   ctlPtr+2
4633 2256 69 00 00              adc   #0
4634 2259 48                    pha   
4635 225A DA                    phx   
4636 225B A2 04 4F 22           _PtInRect 
4637 2262 68                    pla   
4638 2263 F0 0C                 beq   @nextCtl
4639 2265
4640 2265 85 21                 sta   ctlPart
4641 2267 A5 01                 lda   hndl                     ;Copy the temp hndl to the "real" one.
4642 2269 85 05                 sta   ctlHndl
4643 226B A5 03                 lda   hndl+2
4644 226D 85 07                 sta   ctlHndl+2
4645 226F
4646 226F              *** added 13-Nov-91 DAL -- no need for special Text Edit handling
4647 226F              ;;	ldy	#octlProc+2	;Get hi-word of proc address.
4648 226F              ;;	lda	[ctlPtr],y
4649 226F              ;;	cmp	#editTextControl>>16
4650 226F              ;;	bne	@exit
4651 226F 80 0D                 bra   @exit
4652 2271              *** end 13-Nov-91 DAL
4653 2271
4654 2271 A0 02 00     @nextCtl ldy   #2
4655 2274 A7 09                 lda   [ctlPtr]                 ;Get the next control handle.
4656 2276 85 01                 sta   hndl
4657 2278 B7 09                 lda   [ctlPtr],y
4658 227A 85 03                 sta   hndl+2
4659 227C 80 AC                 bra   @loop
4660 227E
4661 227E A5 05        @exit    lda   ctlHndl                  ;Return the ctl hndl (could be NULL).
4662 2280 87 1D                 sta   [ctlHndlPtr]
4663 2282 A5 07                 lda   ctlHndl+2
4664 2284 A0 02 00              ldy   #2
4665 2287 97 1D                 sta   [ctlHndlPtr],y
4666 2289
4667 2289 3B                    tsc                            ;Get rid of local variables.
4668 228A 18                    clc   
4669 228B 69 0C 00              adc   #sizeLocals
4670 228E 1B                    tcs   
4671 228F 2B                    pld                            ;Restore directPage register.
4672 2290
4673 2290 A2 00 00              ldx   #0                       ;no error
4674 2293 A0 0C 00              ldy   #sizeParms               ;number of bytes to strip
4675 2296 5C 84 01 E1           jml   $e10184                  ;ToStrip
4676 229A
4677 229A                       EndP 
4678 229A
4679 229A
4680 229A              **********************************************************************
4681 229A              *
4682 229A              * $6A0E ResizeInfoBar -- new call 5-Mar-91 DAL
4683 229A              *
4684 229A              * Input:
4685 229A              *    WORD  flags (reserved, use 0)
4686 229A              *    WORD  new info bar height
4687 229A              *    LONG  window pointer
4688 229A              *
4689 229A              * WARNING: This only works for standard windows, not custom windows.
4690 229A              *
4691 229A              **********************************************************************
4692 229A              ResizeInfoBar proc export 
4693 229A
4694 229A 0B                    phd   
4695 229B 3B                    tsc   
4696 229C 5B                    tcd   
4697 229D
4698 229D              @oldD    equ   1
4699 229D              @rtl     equ   @oldD+2
4700 229D              @window  equ   @rtl+6
4701 229D              @height  equ   @window+4
4702 229D              @flags   equ   @height+2
4703 229D
4704 229D A0 FC 00              ldy   #$100-4                  ;offset to info bar height
4705 22A0 A5 0D                 lda   @height
4706 22A2 97 09                 sta   [@window],y
4707 22A4
4708 22A4 48                    pha   
4709 22A5 48                    pha   
4710 22A6 A2 04 1C 22           _GetPort 
4711 22AD D4 0B                 pei   @window+2
4712 22AF D4 09                 pei   @window
4713 22B1 A2 04 1B 22           _SetPort 
4714 22B8
4715 22B8 F4 02 00 F4           pushlong #ThePortRect 
4716 22BE A2 04 20 22           _GetPortRect 
4717 22C5
4718 22C5 A2 04 1B 22           _SetPort 
4719 22CC
4720 22CC 38                    sec   
4721 22CD AF FB 25 02           lda   >ThePortRect+6
4722 22D1 EF F7 25 02           sbc   >ThePortRect+2
4723 22D5 48                    pha   
4724 22D6 AF F9 25 02           lda   >ThePortRect+4
4725 22DA EF F5 25 02           sbc   >ThePortRect
4726 22DE 48                    pha   
4727 22DF D4 0B                 pei   @window+2
4728 22E1 D4 09                 pei   @window
4729 22E3 A2 0E 1C 22           _SizeWindow 
4730 22EA
4731 22EA 2B                    pld   
4732 22EB A2 00 00              ldx   #0
4733 22EE A0 08 00              ldy   #8
4734 22F1 5C 84 01 E1           jml   $e10184                  ;ToStrip
4735 22F5
4736 22F5 00 00 00 00  ThePortRect DS B:8
4737 22FD
4738 22FD                       EndP 
4739 22FD
4740 22FD              **********************************************************************
4741 22FD              **********************************************************************
4742 22FD              *
4743 22FD              * $6B0E HandleDiskInsert -- new call 12-Apr-91 DAL
4744 22FD              *
4745 22FD              * Input:
4746 22FD              *   WORD space for result flags
4747 22FD              *   WORD space for result devnum
4748 22FD              *   WORD flags
4749 22FD              *   WORD devNum
4750 22FD              * Output:
4751 22FD              *   WORD resultFlags
4752 22FD              *   WORD resultDevNum
4753 22FD              *
4754 22FD              * Input flags:
4755 22FD              *   Bit 15 = perform device scanning
4756 22FD              *   Bit 14 = perform Volume call & user interaction on errors
4757 22FD              *   Bit 13 = update the status of a particular device or all devices
4758 22FD              *   Bit 12 = report any detected disk-ejects too, not just inserts
4759 22FD              *   Bit 11 = bypass the normal 1-second delay, scan immediately
4760 22FD              *   Bit 10 = simulate a duplicate-volume error on a specific device
4761 22FD              *            (set bit 14 also, and pass in devNum)
4762 22FD              *   Bit  0 = initialize all devices to "offline" status so that each
4763 22FD              *            device already online will appear as an insertion
4764 22FD              * 
4765 22FD              * Input devnum: Normally zero.  Pass a nonzero device number if you
4766 22FD              * already detected an insert & want the system to check it out & possibly
4767 22FD              * ask the user to format it (flag bit 15 clear, 14 set); or if you are
4768 22FD              * informing the system that you have already taken care of the new status
4769 22FD              * of a particular device (flag bit 13 set).
4770 22FD              * 
4771 22FD              * ResultDevNum: the device number of a device that was inserted or ejected.
4772 22FD              * Zero if nothing happened, or if the user chose to Eject a disk that was
4773 22FD              * discovered to be inserted.
4774 22FD              * 
4775 22FD              * ResultFlags: Bit 0 = set if resultDevNum is an ejection.  Bit 1 = set if
4776 22FD              * ResultDevNum represents a disk that the user elected to format.
4777 22FD              * 
4778 22FD              * Implementation notes:
4779 22FD              * • When scanning, Apple 5.25 devices are ignored, as are character devices.
4780 22FD              * • Block devices with NON-removable media are still scanned, since it's
4781 22FD              *   important for some applications to get an "insert" for them the first
4782 22FD              *   time around (after WindStartUp).  May or may not scan them if they're
4783 22FD              *   already known to be online.
4784 22FD              * • The call will check the tick count against the last time it was called &
4785 22FD              *   take no action if it hasn't been long enough (bypass this check if input
4786 22FD              *   flag bit 11 is set).
4787 22FD              * • Will keep a table indicating which devices are considered online & offline
4788 22FD              *   and will make a series of DStatus calls looking for a status that differs
4789 22FD              *   from before.
4790 22FD              * • When an eject is detected, it is reported if the flags say it should be.
4791 22FD              * • When an insert is detected, it does a Volume call on the device.  If there's
4792 22FD              *   no error, continue with the scan.
4793 22FD              * • If Volume returns an I/O error or unrecognized-volume error, call AlertWindow
4794 22FD              *   with the strings already in Sys.Resources (used by Standard File) asking the
4795 22FD              *   user to Eject or Initialize.
4796 22FD              * • If the user elects to Eject, make the DControl Eject call to get rid of it.
4797 22FD              * • If the user elects to Initialize, make the GS/OS Format call to format it
4798 22FD              *   (letting the user name the disk and specify the file system & format options
4799 22FD              *   within the Format call).
4800 22FD              * • If they cancel out of the Format dialog, eject the disk and return no error.
4801 22FD              * • If the format is successful, return the device number as the ResultDevNum.
4802 22FD              * • If the Volume call returns a *weird* error, leave it online, return the
4803 22FD              *   device number to the caller, and return the Volume error to the caller!
4804 22FD              *
4805 22FD              * If an insert or eject is reported, there is no 1-second delay enforced on the
4806 22FD              * next call.
4807 22FD              *
4808 22FD              * When the volume call returns error $52, we call SendRequest($0002)
4809 22FD              * to see if anybody wants to put up a special dialog for the disk.
4810 22FD              * They get to specify eject/initialize/erase.  Low word of dataIn =
4811 22FD              * device number, offset 4 of dataOut = disposition (0=eject, 1=init,
4812 22FD              * 2=erase, $FFFF = leave the volume online and report no error).
4813 22FD              *
4814 22FD              * If nobody wants to special-case it, then we put up the standard
4815 22FD              * AlertWindow with Eject/Initialize buttons (and Option-initialize
4816 22FD              * means to Erase instead).
4817 22FD              *
4818 22FD              * If they click Option-Initialize on our standard dialog for error $52,
4819 22FD              * then we do an Erase instead of a Format.
4820 22FD              *
4821 22FD              * When call completes, the cursor is set to the same thing it was before.
4822 22FD              * During the call, Arrow and Watch cursors are used.
4823 22FD              *
4824 22FD              * • NOTE -- This code only goes as high as device 127.  References to
4825 22FD              *           DevStatTable need to change if you want more.
4826 22FD              *
4827 22FD              * WindStartUp calls HandleDiskInsert($2000,$0000) to initialize us.
4828 22FD              *
4829 22FD              **********************************************************************
4830 22FD              HandleDiskInsert proc export 
4831 22FD                       import FlushKeyEvents 
4832 22FD
4833 22FD 8B                    phb   
4834 22FE 4B                    phk   
4835 22FF AB                    plb   
4836 2300
4837 2300 0B                    phd   
4838 2301
4839 2301 F4 00 00              pea   0                        ;space/initial value for @theError
4840 2304
4841 2304 3B                    tsc   
4842 2305 5B                    tcd   
4843 2306
4844 2306              fDoDeviceScan equ   $8000               ;must be bit 15 (BPL!)
4845 2306              fHandleInsertion equ   $4000
4846 2306              fUpdateDevStatus equ   $2000
4847 2306              fReportEjects equ   $1000
4848 2306              fNoDelay equ   $0800
4849 2306              fDuplicateVolume equ   $0400            ;23-Apr-91 DAL
4850 2306              fCheckTapeDrives equ   $0200            ;10-Oct-91 DAL
4851 2306              hdiUnreadable equ   $0100               ;9-Dec-91 DAL
4852 2306              fInitialize equ   $0001                 ;must be bit 0
4853 2306
4854 2306              @theError equ   1
4855 2306              @oldD    equ   @theError+2
4856 2306              @oldB    equ   @oldD+2
4857 2306              @rtl     equ   @oldB+1
4858 2306              @devNum  equ   @rtl+6
4859 2306              @flags   equ   @devNum+2
4860 2306              @resultDevNum equ   @flags+2
4861 2306              @resultFlags equ   @resultDevNum+2
4862 2306
4863 2306 64 10                 stz   <@resultDevNum
4864 2308 64 12                 stz   <@resultFlags
4865 230A
4866 230A A5 0E                 lda   <@flags
4867 230C 4A                    lsr   a
4868 230D 90 0D                 bcc   @noInit
4869 230F A9 00 00              lda   #0
4870 2312 A2 0E 00              ldx   #14
4871 2315 9D 89 2E     @clear   sta   DevStatTable,x
4872 2318 CA                    dex   
4873 2319 CA                    dex   
4874 231A 10 F9                 bpl   @clear
4875 231C              @noInit   
4876 231C
4877 231C A5 0E                 lda   <@flags
4878 231E 29 00 20              and   #fUpdateDevStatus
4879 2321 F0 03                 beq   @noUpdate
4880 2323 20 B4 26              jsr   @UpdateDevStatus
4881 2326              @noUpdate  
4882 2326
4883 2326 A5 0E                 lda   <@flags
4884 2328 10 05                 bpl   @noScanning
4885 232A 20 8B 26              jsr   @DoScanning
4886 232D 80 04                 bra   @cont
4887 232F A5 0C        @noScanning lda   <@devNum
4888 2331 85 10                 sta   <@resultDevNum
4889 2333              @cont     
4890 2333 A5 0E                 lda   <@flags
4891 2335 29 00 40              and   #fHandleInsertion
4892 2338 F0 09                 beq   @noUserStuff
4893 233A 20 4F 26              jsr   @PreserveCursor
4894 233D 20 27 28              jsr   @HandleAnInsertion
4895 2340 20 61 26              jsr   @RestoreCursor
4896 2343              @noUserStuff  
4897 2343 A6 01                 ldx   <@theError
4898 2345
4899 2345 68                    pla                            ;pull <@theError
4900 2346
4901 2346 2B                    pld   
4902 2347 AB                    plb   
4903 2348 A0 04 00              ldy   #4
4904 234B 5C 84 01 E1           jml   $e10184                  ;ToStrip
4905 234F
4906 234F              **********************************************************************
4907 234F              *
4908 234F              * PreserveCursor
4909 234F              *
4910 234F              **********************************************************************
4911 234F 48           @PreserveCursor pha   
4912 2350 48                    pha   
4913 2351 A2 04 8F 22           _GetCursorAdr 
4914 2358 68                    pla   
4915 2359 8D 87 26              sta   @theCursor
4916 235C 68                    pla   
4917 235D 8D 89 26              sta   @theCursor+2
4918 2360 60                    rts   
4919 2361
4920 2361              **********************************************************************
4921 2361              *
4922 2361              * RestoreCursor -- if the cursor has changed, put it back
4923 2361              *
4924 2361              * (If it hasn't changed, avoid bogus flicker by not doing anything.)
4925 2361              *
4926 2361              **********************************************************************
4927 2361 48           @RestoreCursor pha   
4928 2362 48                    pha   
4929 2363 A2 04 8F 22           _GetCursorAdr 
4930 236A FA                    plx   
4931 236B 68                    pla   
4932 236C CD 89 26              cmp   @theCursor+2
4933 236F D0 06                 bne   @setIt
4934 2371 EC 87 26              cpx   @theCursor
4935 2374 D0 01                 bne   @setIt
4936 2376 60                    rts   
4937 2377 AD 89 26 48  @setIt   pushlong @theCursor 
4938 237F A2 04 8E 22           _SetCursor 
4939 2386 60                    rts   
4940 2387
4941 2387 00 00 00 00  @theCursor DC L:0
4942 238B
4943 238B              **********************************************************************
4944 238B              *
4945 238B              * DoScanning
4946 238B              *
4947 238B              * If fNoDelay is clear and it's been less than a second since the
4948 238B              * last time we polled, return without doing anything.
4949 238B              *
4950 238B              **********************************************************************
4951 238B A5 0E        @doScanning lda   <@flags
4952 238D 29 00 08              and   #fNoDelay
4953 2390 D0 0D                 bne   @noDelay
4954 2392
4955 2392 20 18 28              jsr   @GetTickCount
4956 2395 38                    sec   
4957 2396 ED 87 2E              sbc   PrevTime
4958 2399 C9 3C 00              cmp   #60                      ;has it been a second yet?
4959 239C B0 01                 bcs   @longEnough
4960 239E 60                    rts                            ;return, no action
4961 239F              @longEnough  
4962 239F              @noDelay  
4963 239F
4964 239F A9 00 00              lda   #0
4965 23A2 1A           @scanLoop inc   a
4966 23A3 C9 80 00              cmp   #128
4967 23A6 B0 05                 bcs   @scanDone
4968 23A8 20 D5 26              jsr   @ScanDeviceA
4969 23AB 90 F5                 bcc   @scanLoop
4970 23AD
4971 23AD 20 18 28     @scanDone jsr   @GetTickCount
4972 23B0 8D 87 2E              sta   PrevTime
4973 23B3 60                    rts   
4974 23B4
4975 23B4
4976 23B4              **********************************************************************
4977 23B4              *
4978 23B4              * UpdateDevStatus
4979 23B4              *
4980 23B4              * Update our private idea of whether a device is online, or all
4981 23B4              * devices.  <@devNum is 0 or a specific device.
4982 23B4              *
4983 23B4              **********************************************************************
4984 23B4 A5 0C        @UpdateDevStatus lda   <@devNum
4985 23B6 D0 09                 bne   @updateDeviceA
4986 23B8
4987 23B8 1A           @updateLoop inc   a
4988 23B9 48                    pha   
4989 23BA 20 C1 26              jsr   @updateDeviceA
4990 23BD 68                    pla   
4991 23BE 90 F8                 bcc   @updateLoop
4992 23C0 60                    rts   
4993 23C1
4994 23C1 C9 80 00     @updateDeviceA cmp   #128
4995 23C4 B0 0C                 bcs   @updated
4996 23C6 48                    pha   
4997 23C7 20 1C 27              jsr   @GetStatusDeviceA        ;SEC=online, CLC=offline, X<>0 if done
4998 23CA 68                    pla   
4999 23CB 9B                    txy   
5000 23CC D0 05                 bne   @errorMeansOnline
5001 23CE 20 DD 27              jsr   @SetDevStatus
5002 23D1 18                    clc   
5003 23D2 60           @updated rts   
5004 23D3
5005 23D3 38           @errorMeansOnline sec   
5006 23D4 60                    rts   
5007 23D5
5008 23D5              **********************************************************************
5009 23D5              *
5010 23D5              * ScanDeviceA -- see if an insert/eject happened for device A
5011 23D5              *
5012 23D5              * If nothing happened, return CLC.
5013 23D5              * If we're out of devices, return SEC.
5014 23D5              * If we find an insert/eject, set <@resultDevNum and <@resultFlags
5015 23D5              *   and return SEC.
5016 23D5              *
5017 23D5              * Side effect: updates the DevStatusTable to reflect the device's
5018 23D5              * new status.
5019 23D5              *
5020 23D5              **********************************************************************
5021 23D5 48           @ScanDeviceA pha   
5022 23D6 20 1C 27              jsr   @GetStatusDeviceA
5023 23D9 8A                    txa   
5024 23DA F0 03                 beq   @stillGoing
5025 23DC 68                    pla   
5026 23DD 38                    sec                            ;out of devices!
5027 23DE 60                    rts   
5028 23DF
5029 23DF 90 11        @stillGoing bcc   @nowOffline           ;carry still has online status
5030 23E1 A3 01        @nowOnline lda   1,s
5031 23E3 5A                    phy                            ;added 31-Jan-92 DAL (keep TheStatusWord)
5032 23E4 20 D3 27              jsr   @LookupDevStatus
5033 23E7 7A                    ply                            ;added 31-Jan-92 DAL
5034 23E8 B0 29                 bcs   @stillOnline
5035 23EA              ; now we know it's an insert
5036 23EA 38           @weHaveAnInsert sec   
5037 23EB A3 01                 lda   1,s
5038 23ED 20 DD 27              jsr   @SetDevStatus
5039 23F0 80 19                 bra   @returnThisDev
5040 23F2
5041 23F2 A3 01        @nowOffline lda   1,s
5042 23F4 20 D3 27              jsr   @LookupDevStatus
5043 23F7 90 20                 bcc   @stillOffline
5044 23F9              ; now we know it's an eject
5045 23F9 18                    clc   
5046 23FA A3 01                 lda   1,s
5047 23FC 20 DD 27              jsr   @SetDevStatus            ;mark it offline
5048 23FF A5 0E                 lda   <@flags
5049 2401 29 00 10              and   #fReportEjects
5050 2404 F0 13                 beq   @stillOffline
5051 2406 A9 01 00              lda   #$0001                   ;bit = 0 ejection
5052 2409 04 12                 tsb   <@resultFlags
5053 240B 68           @returnThisDev pla   
5054 240C 85 10                 sta   <@resultDevNum
5055 240E 9C 87 2E              stz   PrevTime                 ;don't make them wait for the next one!
5056 2411 38                    sec   
5057 2412 60                    rts   
5058 2413
5059 2413              *** added 31-Jan-92 DAL -- If there was a disk-switched, treat online as insert
5060 2413 98           @stillOnline tya   
5061 2414 29 01 00              and   #1
5062 2417 D0 D1                 bne   @weHaveAnInsert
5063 2419              *** end 31-Jan-92
5064 2419 68           @stillOffline pla   
5065 241A 18                    clc   
5066 241B 60                    rts   
5067 241C
5068 241C              **********************************************************************
5069 241C              *
5070 241C              * GetStatusDeviceA
5071 241C              *
5072 241C              * Input: device number in A
5073 241C              *
5074 241C              * Result: SEC=online, CLC=offline
5075 241C              *         X<>0 if we're out of devices
5076 241C              *         Y = device status word (bit 0 = device switched)
5077 241C              *
5078 241C              * (Apple 5.25s are always reported as offline)
5079 241C              *
5080 241C              **********************************************************************
5081 241C 8D 9B 2E     @GetStatusDeviceA sta   DInfoDevNum
5082 241F 8D B3 2E              sta   DStatusDevNum
5083 2422 9C C3 2E              stz   TheStatusWord            ;added 31-Jan-92 DAL
5084 2425
5085 2425              *** added 21-Nov-91 DAL -- set up pcount
5086 2425 A9 03 00              lda   #3                       ;pcount
5087 2428 8D 99 2E              sta   DInfoParms
5088 242B              *** end 21-Nov-91
5089 242B F4 02 00 F4           pushlong #DInfoParms 
5090 2431 F4 2C 20              pea   $202c                    ;DInfo
5091 2434 22 B0 00 E1           jsl   $e100b0
5092 2438 AA                    tax   
5093 2439 18                    clc   
5094 243A D0 41                 bne   @gotStat                 ;error --> treat it as offline
5095 243C
5096 243C 20 81 27              jsr   @GetDeviceID
5097 243F
5098 243F 18                    clc   
5099 2440 AD AF 2E              lda   DeviceID
5100 2443 F0 35                 beq   @returnStat              ;say the 5.25 is offline
5101 2445
5102 2445              *** 10-Oct-91 DAL -- check for Apple tape drive, only scan if we want to
5103 2445 C9 20 00              cmp   #$0020                   ;Apple tape drive
5104 2448 D0 08                 bne   @notTape
5105 244A A5 0E                 lda   <@flags
5106 244C 29 00 02              and   #fCheckTapeDrives
5107 244F 18                    clc   
5108 2450 F0 28                 beq   @returnStat              ;return offline for tape
5109 2452              @notTape  
5110 2452              *** end 10-Oct-91 DAL
5111 2452
5112 2452
5113 2452 AD A1 2E              lda   DInfoChar                ;characteristics
5114 2455 29 80 00              and   #$0080
5115 2458 18                    clc   
5116 2459 F0 1F                 beq   @returnStat              ;character device--return offline
5117 245B
5118 245B AD A1 2E              lda   DInfoChar
5119 245E 29 04 00              and   #$0004                   ;Removable media?
5120 2461 38                    sec   
5121 2462 F0 16                 beq   @returnStat              ;if not removable, report online!
5122 2464
5123 2464 F4 02 00 F4           pushlong #DStatusParms 
5124 246A F4 2D 20              pea   $202d                    ;DStatus
5125 246D 22 B0 00 E1           jsl   $e100b0
5126 2471
5127 2471 AD C3 2E              lda   TheStatusWord
5128 2474 29 10 00              and   #$0010
5129 2477 C9 01 00              cmp   #1                       ;SEC = online
5130 247A
5131 247A A2 00 00     @returnStat ldx   #0
5132 247D              @gotStat  
5133 247D AC C3 2E              ldy   TheStatusWord            ;added 31-Jan-92 DAL
5134 2480 60                    rts   
5135 2481
5136 2481              **********************************************************************
5137 2481              *
5138 2481              * GetDeviceID
5139 2481              *
5140 2481              * Input: DInfoDevNum
5141 2481              * Output: DeviceID
5142 2481              *
5143 2481              * This routine cheats & gets a device's device_id without making a
5144 2481              * DInfo call.  Calling DInfo with a lot of parameters does device
5145 2481              * access, which takes too much time to do here.
5146 2481              *
5147 2481              * $E100BE bit 15 is the GS/OS busy flag.  To make sure I have use of
5148 2481              * GS/OS direct page, I check the bit & then keep it set while I'm
5149 2481              * doing the work.
5150 2481              *
5151 2481              * $01FC00 is the device dispatcher.  DevNum = 0 does special stuff,
5152 2481              * like finding DIBs.  How handy.
5153 2481              *
5154 2481              **********************************************************************
5155 2481 9C AF 2E     @GetDeviceID stz   DeviceID
5156 2484 AF BE 00 E1           lda   >$e100be
5157 2488 30 48                 bmi   @osBusy
5158 248A 09 00 80              ora   #$8000
5159 248D 8F BE 00 E1           sta   >$e100be
5160 2491
5161 2491 0B                    phd   
5162 2492 A9 00 BD              lda   #$bd00                   ;hard-coded GS/OS direct page location
5163 2495 5B                    tcd   
5164 2496 E2 30                 sep   #$30
5165 2498 AF 68 C0 E0           lda   >$e0c068
5166 249C 48                    pha   
5167 249D AF 8B C0 E0           lda   >$e0c08b
5168 24A1 AF 8B C0 E0           lda   >$e0c08b
5169 24A5 C2 30                 rep   #$30
5170 24A7
5171 24A7 AD 9B 2E              lda   DInfoDevNum
5172 24AA 85 04                 sta   <4                       ;driver number
5173 24AC 64 00                 stz   <0                       ;$BD00 = 0 (device #)
5174 24AE 64 02                 stz   <2
5175 24B0 E6 02                 inc   <2                       ;$BD02 = 1 (get_dib_ptr)
5176 24B2
5177 24B2 22 00 FC 01           jsl   $01fc00                  ;returns dib pointer at <$20
5178 24B6
5179 24B6 A0 34 00              ldy   #$0034                   ;offset of device_id in DIB
5180 24B9 B7 20                 lda   [$20],y                  ;$20 points to current DIB
5181 24BB 8D AF 2E              sta   DeviceID
5182 24BE
5183 24BE E2 30                 sep   #$30
5184 24C0 68                    pla   
5185 24C1 8F 68 C0 E0           sta   >$e0c068
5186 24C5 C2 30                 rep   #$30
5187 24C7 2B                    pld   
5188 24C8
5189 24C8 AF BE 00 E1           lda   >$e100be
5190 24CC              ;;;	and	#$7fff
5191 24CC 0A                    asl   a
5192 24CD 4A                    lsr   a                        ;cleared bit 15
5193 24CE 8F BE 00 E1           sta   >$e100be
5194 24D2
5195 24D2 60           @osBusy  rts   
5196 24D3
5197 24D3              **********************************************************************
5198 24D3              *
5199 24D3              * LookupDevStatus
5200 24D3              *
5201 24D3              * In: A = device number
5202 24D3              *
5203 24D3              * Out: SEC=device online, CLC=device offline
5204 24D3              *
5205 24D3              **********************************************************************
5206 24D3 20 FD 27     @LookupDevStatus jsr   @computeTableOffset
5207 24D6 3D 89 2E              and   DevStatTable,x
5208 24D9 C9 01 00              cmp   #1
5209 24DC 60                    rts   
5210 24DD
5211 24DD              **********************************************************************
5212 24DD              *
5213 24DD              * SetDevStatus
5214 24DD              *
5215 24DD              * A = device number, SEC=online, CLC=offline
5216 24DD              *
5217 24DD              **********************************************************************
5218 24DD              @SetDevStatus  
5219 24DD              *** added 20-May-91 DAL -- only update status table if application wants it
5220 24DD              *** NOTE THAT CARRY FLAG IS PRESERVED HERE!
5221 24DD AA                    tax   
5222 24DE A5 0E                 lda   <@flags
5223 24E0 29 00 A0              and   #fDoDeviceScan+fUpdateDevStatus
5224 24E3 D0 01                 bne   @continue
5225 24E5 60                    rts   
5226 24E6 8A           @continue txa   
5227 24E7              *** end of 20-May-91 DAL
5228 24E7 08                    php   
5229 24E8 20 FD 27              jsr   @computeTableOffset
5230 24EB 28                    plp   
5231 24EC 90 05                 bcc   @clearTheBit
5232 24EE 1D 89 2E              ora   DevStatTable,x
5233 24F1 80 06                 bra   @store
5234 24F3 49 FF FF     @clearTheBit eor   #$ffff
5235 24F6 3D 89 2E              and   DevStatTable,x
5236 24F9 9D 89 2E     @store   sta   DevStatTable,x
5237 24FC 60                    rts   
5238 24FD
5239 24FD              **********************************************************************
5240 24FD              *
5241 24FD              * ComputeTableOffset
5242 24FD              *
5243 24FD              * In: A = devnum
5244 24FD              * Out: X = offset, A = bit mask
5245 24FD              *
5246 24FD              **********************************************************************
5247 24FD A8           @computeTableOffset tay   
5248 24FE 29 07 00              and   #$0007
5249 2501 AA                    tax   
5250 2502 BD 10 28              lda   @bitmasks,x
5251 2505 29 FF 00              and   #$00ff
5252 2508 48                    pha   
5253 2509 98                    tya   
5254 250A 4A                    lsr   a
5255 250B 4A                    lsr   a
5256 250C 4A                    lsr   a
5257 250D AA                    tax   
5258 250E 68                    pla   
5259 250F 60                    rts   
5260 2510
5261 2510 01 02 04 08  @bitmasks DC B:$01,$02,$04,$08,$10,$20,$40,$80
5262 2518
5263 2518              **********************************************************************
5264 2518              *
5265 2518              * GetTickCount -- return A = low word of tick count
5266 2518              *
5267 2518              **********************************************************************
5268 2518 48           @GetTickCount pha   
5269 2519 48                    pha   
5270 251A A2 06 10 22           _TickCount 
5271 2521 68                    pla   
5272 2522 FA                    plx   
5273 2523 60                    rts   
5274 2524
5275 2524              **********************************************************************
5276 2524              *
5277 2524              * HandleAnInsertion
5278 2524              *
5279 2524              * resultDevNum and resultFlags are valid
5280 2524              *
5281 2524              * If there's no insert, we're done right away.
5282 2524              *
5283 2524              **********************************************************************
5284 2524 82 96 00     @goInsDone brl   @insDone
5285 2527
5286 2527 A5 10        @HandleAnInsertion lda   <@resultDevNum
5287 2529 F0 F9                 beq   @goInsDone
5288 252B A5 12                 lda   <@resultFlags
5289 252D 4A                    lsr   a
5290 252E              ;;;	bcs	@insDone	;14-Apr-91 (it's an Eject)
5291 252E              *** 31-Jan-92 DAL -- branch was too long
5292 252E 90 01                 bcc   @notInsDone
5293 2530 60                    rts   
5294 2531              @notInsDone  
5295 2531              *** 31-Jan-92 DAL
5296 2531
5297 2531              ; okay, we have a real insert -- do a DInfo and Volume call
5298 2531 A5 10                 lda   <@resultDevNum
5299 2533 8D 9B 2E              sta   DInfoDevNum
5300 2536              *** added 21-Nov-91 DAL -- set up large pcount
5301 2536 A9 08 00              lda   #8                       ;pcount
5302 2539 8D 99 2E              sta   DInfoParms
5303 253C              *** end 21-Nov-91
5304 253C F4 02 00 F4           pushlong #DInfoParms 
5305 2542 F4 2C 20              pea   $202c                    ;DInfoGS
5306 2545 22 B0 00 E1           jsl   $e100b0
5307 2549 B0 72                 bcs   @insDone
5308 254B
5309 254B              *** added 31-Jan-92 DAL -- Never handle a Tape Drive insertion
5310 254B AD AD 2E              lda   device_id
5311 254E C9 20 00              cmp   #$0020                   ;Apple tape drive
5312 2551 F0 6A                 beq   @insDone
5313 2553              *** end 31-Jan-92
5314 2553
5315 2553              *** added 9-Dec-91 DAL -- check hdiUnreadable bit, pretend we got I/O error
5316 2553 A5 0E                 lda   <@flags
5317 2555 29 00 01              and   #hdiUnreadable           ;simulate an I/O error
5318 2558 F0 05                 beq   @notUnreadable
5319 255A A9 27 00              lda   #$27
5320 255D 80 28                 bra   @volumeErr
5321 255F              @notUnreadable  
5322 255F              *** end 9-Dec-91
5323 255F
5324 255F              ; try making a volume call, see if we get an error
5325 255F F4 02 00 F4           pushlong #VolumeParms 
5326 2565 F4 08 20              pea   $2008                    ;VolumeGS
5327 2568 22 B0 00 E1           jsl   $e100b0
5328 256C B0 19                 bcs   @volumeErr
5329 256E
5330 256E              *** added 2-Dec-91 DAL -- after successful Volume call, try GetFileInfo
5331 256E F4 02 00 F4           pushlong #gfiParms 
5332 2574 F4 06 20              pea   $2006
5333 2577 22 B0 00 E1           jsl   $e100b0
5334 257B B0 0A                 bcs   @volumeErr
5335 257D              *** end 2-Dec-91
5336 257D
5337 257D A5 0E                 lda   <@flags
5338 257F 29 00 04              and   #fDuplicateVolume
5339 2582 F0 39                 beq   @insDone
5340 2584 A9 57 00              lda   #$57
5341 2587
5342 2587 C9 2F 00     @volumeErr cmp   #$2f                   ;offline?
5343 258A F0 31                 beq   @insDone
5344 258C
5345 258C C9 27 00              cmp   #$27
5346 258F F0 2D                 beq   @ioError
5347 2591
5348 2591 C9 52 00              cmp   #$52
5349 2594 D0 03                 bne   @not52
5350 2596 82 E7 00              brl   @badFileSystem
5351 2599              @not52    
5352 2599 C9 57 00              cmp   #$57                     ;duplicate volume
5353 259C D0 08                 bne   @notDupVol
5354 259E 20 34 2A              jsr   @RenameVolume
5355 25A1 90 1A                 bcc   @insDone                 ;24-Oct-91 DAL
5356 25A3 82 0D 01              brl   @handleDisposition       ;24-Oct-91 DAL (was bra @insDone)
5357 25A6              @notDupVol  
5358 25A6
5359 25A6              *** 28-Oct-92 DAL -- treat $51 (directory damaged) like $5A
5360 25A6 C9 51 00              cmp   #$0051
5361 25A9 F0 05                 beq   @is5a
5362 25AB              *** end 28-Oct-92
5363 25AB
5364 25AB              *** added 2-Dec-91 DAL -- treat $46 (file not found) like $5A (damaged disk)
5365 25AB C9 46 00              cmp   #$0046
5366 25AE D0 03                 bne   @not46
5367 25B0 A9 5A 00     @is5a    lda   #$005a
5368 25B3              @not46    
5369 25B3              *** end 2-Dec-91
5370 25B3
5371 25B3              *** 14-Nov-91 DAL
5372 25B3 C9 5A 00              cmp   #$5A                     ;disk damaged (especially from HFS)
5373 25B6 D0 03                 bne   @not5A
5374 25B8 82 83 00              brl   @diskDamaged
5375 25BB              @not5A    
5376 25BB              *** end 14-Nov-91
5377 25BB
5378 25BB              ; unknown error -- return it to the caller
5379 25BB 85 01                 sta   <@theError
5380 25BD 60           @insDone rts   
5381 25BE
5382 25BE              *
5383 25BE              * Handle I/O error
5384 25BE              *
5385 25BE F4 33 40     @ioError pea   $4033                    ;bad disk + defer
5386 25C1 A2 03 38 22           _SysBeep2 
5387 25C8
5388 25C8 A9 96 00              lda   #$0096
5389 25CB 20 DF 29              jsr   @CallAlertWindow
5390 25CE 3A                    dec   a
5391 25CF 30 47                 bmi   @EjectThatThang
5392 25D1
5393 25D1 A2 12 0A 22           _WaitCursor 
5394 25D8 F4 02 00 F4           pushlong #FormatParms 
5395 25DE F4 24 20              pea   $2024                    ;Format
5396 25E1 22 B0 00 E1           jsl   $e100b0
5397 25E5 B0 03                 bcs   @ioErr2
5398 25E7 82 EC 00              brl   @didFormat
5399 25EA A8           @ioErr2  tay   
5400 25EB F0 2B                 beq   @EjectThatThang          ;Cancel (error 0)
5401 25ED              *** added 10-Oct-91 DAL -- special-case error $21 for a 3.5" disk
5402 25ED C9 21 00     @handleFmtError cmp   #$0021
5403 25F0 D0 0E                 bne   @not21
5404 25F2 AE AD 2E              ldx   Device_id
5405 25F5 E0 17 00              cpx   #$0017                   ;MFM disk?
5406 25F8 F0 03                 beq   @is21
5407 25FA CA                    dex                            ;is it $0001 = 3.5"?
5408 25FB D0 03                 bne   @not21
5409 25FD A9 99 00     @is21    lda   #$0099                   ;special error for HandleDiskInsert (wrong media)
5410 2600              @not21    
5411 2600              *** end 10-Oct-91 DAL
5412 2600 80 00                 bra   @ErrorAndEject
5413 2602
5414 2602              *
5415 2602              * ErrorAndEject
5416 2602              *
5417 2602              * Input:  A = error code, <@resultDevNum = device number
5418 2602              *
5419 2602 48           @ErrorAndEject pha                      ;space for result
5420 2603 F4 20 00              pea   $0020                    ;substitution type + flags (button positions)
5421 2606 F4 00 00              pea   0
5422 2609 F4 00 00              pea   0                        ;substitution array
5423 260C 48                    pha                            ;error code
5424 260D 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
5425 2610 A2 0E 62 22           _ErrorWindow 
5426 2617 68                    pla                            ;button number (ignore)
5427 2618              *
5428 2618              * Eject device <@resultDevNum (and zero it out)
5429 2618              *
5430 2618 A5 10        @EjectThatThang lda   <@resultDevNum
5431 261A 8D 37 2F              sta   EjectDevNum
5432 261D 8D B3 2E              sta   DStatusDevNum
5433 2620 F4 02 00 F4           pushlong #EjectParms 
5434 2626 F4 2E 20              PushWord #$202E                ;_DControl
5435 2629 22 B0 00 E1           jsl   $e100b0
5436 262D
5437 262D A5 10                 lda   <@resultDevNum           ;18-Apr-91 DAL
5438 262F 20 AD 2D              jsr   NotifyEjecting           ;8-Jan-92
5439 2632 20 C1 26              jsr   @UpdateDeviceA           ;18-Apr-91 DAL
5440 2635
5441 2635 A5 10                 lda   <@resultDevNum
5442 2637 18                    clc   
5443 2638 20 DD 27              jsr   @SetDevStatus
5444 263B 64 10        @noMarkEject stz   <@resultDevNum
5445 263D
5446 263D 60                    rts   
5447 263E
5448 263E              *** added 14-Nov-91 DAL
5449 263E              *
5450 263E              * Handle a disk-damaged error (14-Nov-91 DAL)
5451 263E              *
5452 263E 20 2C 23     @diskDamaged jsr   doInitCursor
5453 2641 20 BD 2A              jsr   @futzWStrings
5454 2644 48                    pha                            ;space for button result
5455 2645 F4 A5 00              pea   $00A5                    ;22-Nov-91 DAL
5456 2648 F4 02 00 F4           pushlong #mySubstitutions 
5457 264E F4 FF 07 F4           pushlong #$07FF0E03            ;damaged-disk message in Sys.Res
5458 2654 A2 0E 59 22           _AlertWindow 
5459 265B 20 66 29              jsr   @unfutzWStrings
5460 265E 68                    pla   
5461 265F F0 03                 beq   @dmgZero
5462 2661 20 23 2A              jsr   @computeInitErase        ;option-init --> erase
5463 2664 80 4D        @dmgZero bra   @gotResponse
5464 2666
5465 2666
5466 2666 AD EF 2E     @unfutzWStrings lda   FormatDeviceName    ;make WStrings into PStrings
5467 2669 EB                    xba   
5468 266A 8D EF 2E              sta   FormatDeviceName
5469 266D AD 14 2F              lda   VolumeName+1
5470 2670 EB                    xba   
5471 2671 1A                    inc   a
5472 2672 8D 13 2F              sta   VolumeName
5473 2675 A9 3A 00              lda   #$3a
5474 2678 E2 20                 sep   #$20
5475 267A 8D 15 2F              sta   VolumeName+2
5476 267D C2 20                 rep   #$20
5477 267F 60                    rts   
5478 2680              *** end 14-Nov-91 DAL
5479 2680
5480 2680              *
5481 2680              * Handle unknown-file-system error
5482 2680              *
5483 2680 F4 33 40     @badFileSystem pea   $4033              ;bad disk + defer
5484 2683 A2 03 38 22           _SysBeep2 
5485 268A              ; try SendRequest(unknownDisk,devnum,result)
5486 268A F4 02 00              pea   $0002                    ;systemSaysUnknownDisk
5487 268D F4 00 80              pea   $8000                    ;how=$8000 (send to one)
5488 2690 F4 00 00              pea   0
5489 2693 F4 00 00              pea   0                        ;target=nil
5490 2696 F4 00 00              pea   0                        ;high word of dataIn
5491 2699 D4 10                 pei   <@resultDevNum
5492 269B F4 02 00 F4           pushlong #srqDataOut 
5493 26A1 A2 01 1C 22           _SendRequest 
5494 26A8 AD 4B 2F              lda   srqDataOut+4
5495 26AB 90 06                 bcc   @gotResponse
5496 26AD
5497 26AD A9 97 00              lda   #$0097
5498 26B0 20 DF 29              jsr   @CallAlertWindow
5499 26B3              @handleDisposition  
5500 26B3 A8           @gotResponse tay                        ;added 13-Apr-91 DAL:
5501 26B4 30 25                 bmi   @outtaHere               ;  ...negative from SRQ = leave online!
5502 26B6 3A                    dec   a
5503 26B7 30 23                 bmi   @EjectThatThang0
5504 26B9 F4 02 00 F4           pushlong #FormatParms 
5505 26BF 3A                    dec   a
5506 26C0 30 05                 bmi   @FormatIt
5507 26C2 F4 25 20     @EraseIt pea   $2025
5508 26C5 80 03                 bra   @together
5509 26C7 F4 24 20     @FormatIt pea   $2024
5510 26CA 22 B0 00 E1  @together jsl   $e100b0
5511 26CE 90 06                 bcc   @didFormat
5512 26D0 A8                    tay   
5513 26D1 F0 09                 beq   @EjectThatThang0
5514 26D3 82 17 FF              brl   @handleFmtError          ;24-Oct-91 DAL
5515 26D6 A9 02 00     @didFormat lda   #$0002                 ;bit 1 = they just formatted this
5516 26D9 04 12                 tsb   <@resultFlags
5517 26DB 60           @outtaHere rts   
5518 26DC
5519 26DC 82 39 FF     @EjectThatThang0 brl   @EjectThatThang
5520 26DF              *
5521 26DF              * CallAlertWindow
5522 26DF              *
5523 26DF              * Call AlertWindow & see what they want to do.
5524 26DF              *
5525 26DF              * Return in A: 0=Eject, 1=Initialize, 2=Erase, $ffff = leave online, no error
5526 26DF              *
5527 26DF 48           @CallAlertWindow pha                    ;save error number
5528 26E0 8D 32 2A              sta   @theErrorNumber          ;10-Dec-91 DAL
5529 26E3
5530 26E3 AD EF 2E              lda   FormatDeviceName
5531 26E6 EB                    xba   
5532 26E7 8D EF 2E              sta   FormatDeviceName
5533 26EA
5534 26EA FA                    plx                            ;get error number
5535 26EB
5536 26EB 48                    pha                            ;space for ErrorWindow result
5537 26EC F4 21 00              pea   $0021                    ;Pascal substitution string
5538 26EF F4 02 00 F4           pushlong #FormatDeviceName+1 
5539 26F5 DA                    phx   
5540 26F6 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
5541 26F9 A2 0E 62 22           _ErrorWindow 
5542 2700
5543 2700              *** added 10-Dec-91 DAL -- re-lock the rErrorString handle to make it stay around
5544 2700 48                    pha   
5545 2701 48                    pha                            ;space for LoadResource
5546 2702 F4 20 80              pea   $8020                    ;rErrorString
5547 2705 F4 FF 07              pea   $07FF
5548 2708 AD 32 2A              lda   @theErrorNumber
5549 270B 48                    pha   
5550 270C A2 1E 0E 22           _LoadResource 
5551 2713 68                    pla   
5552 2714 68                    pla                            ;ignore result (side effect locks handle)
5553 2715              *** end 10-Dec-91
5554 2715
5555 2715 AD EF 2E              lda   FormatDeviceName
5556 2718 EB                    xba   
5557 2719 8D EF 2E              sta   FormatDeviceName
5558 271C
5559 271C 68                    pla                            ;ErrorWindow result
5560 271D F0 03                 beq   @zero
5561 271F
5562 271F              ; if they held down the Option key, turn the Init request into an Erase request
5563 271F 20 23 2A              jsr   @computeInitErase
5564 2722
5565 2722 60           @zero    rts   
5566 2723
5567 2723 A2 01 00     @computeInitErase ldx   #1              ;anticipate Init
5568 2726 AF 25 C0 E0           lda   >$e0c025
5569 272A 29 40 00              and   #$0040
5570 272D F0 01                 beq   @notErase
5571 272F E8                    inx                            ;2=Erase
5572 2730 8A           @notErase txa   
5573 2731 60                    rts   
5574 2732
5575 2732 00 00        @theErrorNumber DC W:0                  ;10-Dec-91 DAL
5576 2734
5577 2734              **********************************************************************
5578 2734              *
5579 2734              * RenameVolume
5580 2734              *
5581 2734              * Prompt the user to rename or eject the duplicate volume in device
5582 2734              * @resultDevNum.
5583 2734              *
5584 2734              * The DInfoParms block is already set up from a DInfo call (pcount=8).
5585 2734              * The VolumeParms block is also set up from a Volume call.  The
5586 2734              * volume name is valid even if the call returned error $57.
5587 2734              *
5588 2734              * If carry is set on return:
5589 2734              *   A=0: eject, 1=Init, 2=Erase, $FFFF=leave online
5590 2734              *
5591 2734              **********************************************************************
5592 2734              @RenameVolume  
5593 2734
5594 2734              *** added 24-Oct-91 DAL -- see if we can possibly rename this volume
5595 2734 AD DB 2E              lda   volCharacteristics       ;from Volume call
5596 2737 AA                    tax   
5597 2738 29 40 00              and   #$0040                   ;can we ever write this device?
5598 273B F0 5D                 beq   @mustEject
5599 273D
5600 273D 8A                    txa   
5601 273E 4A                    lsr   a                        ;$0001=read-only FST
5602 273F B0 25                 bcs   @cantRename
5603 2741
5604 2741 A9 FF FF              lda   #$ffff
5605 2744 8D AB 2D              sta   gfiAccess                ;in case of strange error, assume full access
5606 2747 F4 02 00 F4           pushlong #getFileInfoParms 
5607 274D F4 06 20              pea   $2006                    ;GetFileInfo
5608 2750 22 B0 00 E1           jsl   $e100b0
5609 2754 AD AB 2D              lda   gfiAccess
5610 2757 29 40 00              and   #$0040                   ;Rename enabled?
5611 275A F0 0A                 beq   @cantRename
5612 275C              *** added 27-Oct-91 DAL
5613 275C              ;
5614 275C              ; check for AppleShare (special case--GetFileInfo can return duplicate-volume,
5615 275C              ; in which case the gfiAccess is not valid)
5616 275C              ;
5617 275C AD DD 2E              lda   volDeviceID
5618 275F C9 1E 00              cmp   #$001E                   ;Is it AppleShare?
5619 2762 F0 02                 beq   @cantRename
5620 2764              *** end 27-Oct-91
5621 2764
5622 2764 80 67                 bra   @RenameIsPossible
5623 2766
5624 2766              *** can't rename--either eject, or eject/initialize
5625 2766 AD DB 2E     @cantRename lda   volCharacteristics
5626 2769 29 08 00              and   #$0008                   ;can we format this device?
5627 276C F0 2C                 beq   @mustEject
5628 276E
5629 276E              *** it's a read-only FST -- give can't rename-->Eject or Initialize msg
5630 276E 20 BD 2A     @ejectOrInit jsr   @futzWStrings
5631 2771 48                    pha                            ;space
5632 2772 F4 A5 00              pea   $00A5                    ;22-Nov-91 DAL
5633 2775 F4 02 00 F4           pushlong #mySubstitutions 
5634 277B F4 FF 07 F4           pushlong #$07FF0E01 
5635 2781 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
5636 2784 A2 0E 59 22           _AlertWindow 
5637 278B 68                    pla   
5638 278C F0 2A                 beq   @ejectIt
5639 278E AD EF 2E              lda   FormatDeviceName         ;make PString back into WString
5640 2791 EB                    xba   
5641 2792 8D EF 2E              sta   FormatDeviceName
5642 2795 20 23 2A              jsr   @computeInitErase
5643 2798 38                    sec                            ;tell caller to Format!
5644 2799 60                    rts   
5645 279A
5646 279A              *** can't write to disk--tell them they have to eject (error $07FF0E02)
5647 279A 20 BD 2A     @mustEject jsr   @futzWStrings
5648 279D 48                    pha                            ;space
5649 279E F4 A5 00              pea   $00A5                    ;22-Nov-91 DAL
5650 27A1 F4 02 00 F4           pushlong #mySubstitutions 
5651 27A7 F4 FF 07 F4           pushlong #$07FF0E02 
5652 27AD 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
5653 27B0 A2 0E 59 22           _AlertWindow 
5654 27B7 68                    pla   
5655 27B8 38           @ejectIt sec   
5656 27B9 A9 00 00              lda   #0                       ;eject
5657 27BC 60                    rts   
5658 27BD
5659 27BD AD EF 2E     @futzWStrings lda   FormatDeviceName    ;make WStrings into PStrings
5660 27C0 EB                    xba   
5661 27C1 8D EF 2E              sta   FormatDeviceName
5662 27C4 AD 13 2F              lda   VolumeName
5663 27C7 EB                    xba   
5664 27C8 3A                    dec   a
5665 27C9 8D 14 2F              sta   VolumeName+1             ;remove leading colon and convert to pstring
5666 27CC 60                    rts   
5667 27CD              *** end 24-Oct-91 DAL
5668 27CD
5669 27CD              **********************************************************************
5670 27CD 48           @RenameIsPossible pha   
5671 27CE 48                    pha   
5672 27CF A2 10 35 22           _GetCtlParamPtr 
5673 27D6 F4 02 00 F4           pushlong #mySubstitutions 
5674 27DC A2 10 34 22           _SetCtlParamPtr 
5675 27E3 48                    pha   
5676 27E4 48                    pha   
5677 27E5 A2 04 8F 22           _GetCursorAdr 
5678 27EC 20 2C 23              jsr   doInitCursor             ;14-Nov-91 DAL
5679 27EF
5680 27EF              ; construct an initial value for the new name & run it through JudgeName
5681 27EF F4 02 00 F4           pushlong #VolumeName+3 
5682 27F5 F4 02 00 F4           pushlong #TheNewVolumeName+2 
5683 27FB F4 00 00 F4           pushlong #34-3 
5684 2801 A2 02 2B 22           _BlockMove 
5685 2808 AD 13 2F              lda   VolumeName
5686 280B 3A                    dec   a
5687 280C 8D 70 2D              sta   TheNewVolumeName         ;now we have no leading colon
5688 280F
5689 280F EE 70 2D              inc   TheNewVolumeName
5690 2812 AC 70 2D              ldy   TheNewVolumeName
5691 2815 A9 32 00              lda   #'2'
5692 2818 E2 20                 sep   #$20
5693 281A 99 71 2D              sta   TheNewVolumeName+1,y
5694 281D C2 20                 rep   #$20
5695 281F
5696 281F AD D7 2E              lda   volFileSys               ;this is valid for dup-vol if we ask for 8 parms!
5697 2822 8D 95 2D              sta   jnFileSystem
5698 2825
5699 2825 F4 02 00 F4           pushlong #JudgeNameParms 
5700 282B F4 07 20              pea   $2007                    ;JudgeNameGS
5701 282E 22 B0 00 E1           jsl   $e100b0
5702 2832 90 03                 bcc   @judged1
5703 2834 82 DE 01              brl   @abort
5704 2837              @judged1  
5705 2837
5706 2837 AD EF 2E              lda   FormatDeviceName         ;make WStrings into PStrings
5707 283A EB                    xba   
5708 283B 8D EF 2E              sta   FormatDeviceName
5709 283E AD 13 2F              lda   VolumeName
5710 2841 EB                    xba   
5711 2842 3A                    dec   a
5712 2843 8D 14 2F              sta   VolumeName+1             ;remove leading colon and convert to pstring
5713 2846
5714 2846 48                    pha   
5715 2847 48                    pha                            ;space for NewWindow2 result
5716 2848 A2 00 00              ldx   #0
5717 284B DA                    phx   
5718 284C DA                    phx                            ;override title
5719 284D DA                    phx   
5720 284E DA                    phx                            ;override refcon
5721 284F DA                    phx   
5722 2850 DA                    phx                            ;content draw routine
5723 2851 DA                    phx   
5724 2852 DA                    phx                            ;override defproc
5725 2853              ;;;	pea	2	;by resource
5726 2853              *** changed 10-Dec-91 DAL -- do this by pointer so we don't lose the resource
5727 2853 DA                    phx                            ;0 = by pointer (to NewWindow2)
5728 2854 48                    pha   
5729 2855 48                    pha                            ;space for LoadResource
5730 2856 F4 0E 80              pea   $800E                    ;rWindParam1
5731 2859 F4 FF 07              pea   $07ff
5732 285C              ;;;	pea	$0e01	;resource id for 640 window
5733 285C              *** added 21-Nov-91 DAL -- use $0E02 for 320 mode
5734 285C 48                    pha   
5735 285D A2 04 17 22           _GetMasterSCB 
5736 2864 68                    pla   
5737 2865 A0 01 0E              ldy   #$0E01
5738 2868 29 80 00              and   #$0080
5739 286B D0 01                 bne   @640
5740 286D C8                    iny   
5741 286E 5A           @640     phy   
5742 286F              *** end 21-Nov-91
5743 286F A2 1E 0E 22           _LoadResource 
5744 2876 0B                    phd   
5745 2877 3B                    tsc   
5746 2878 5B                    tcd   
5747 2879 A0 02 00              ldy   #2
5748 287C B7 03                 lda   [3],y
5749 287E AA                    tax   
5750 287F A7 03                 lda   [3]
5751 2881 85 03                 sta   3
5752 2883 86 05                 stx   5
5753 2885 2B                    pld   
5754 2886              *** end 10-Dec-91
5755 2886 F4 0E 80              pea   $800e                    ;resource type
5756 2889 A2 0E 61 22           _NewWindow2                    ;leave window pointer on stack
5757 2890
5758 2890 F4 52 40              pea   $4052                    ;Stop-icon sound
5759 2893 A2 03 38 22           _SysBeep2 
5760 289A
5761 289A              ; set the edit line maximum length from the JudgeName maximum-length value
5762 289A 48                    pha   
5763 289B 48                    pha                            ;space for GetCtlTitle
5764 289C 48                    pha   
5765 289D 48                    pha                            ;space for GetCtlHandleFromID
5766 289E 48                    pha   
5767 289F 48                    pha                            ;space for FrontWindow
5768 28A0 A2 0E 15 22           _FrontWindow 
5769 28A7 F4 00 00 F4           pushlong #3                    ;edit line control ID
5770 28AD A2 10 30 22           _GetCtlHandleFromID            ;got control handle
5771 28B4 A2 10 0D 22           _GetCtlTitle                   ;got Line Edit record handle
5772 28BB 0B                    phd   
5773 28BC 3B                    tsc   
5774 28BD 5B                    tcd   
5775 28BE A0 02 00              ldy   #2
5776 28C1 A7 03                 lda   [3]
5777 28C3 AA                    tax   
5778 28C4 B7 03                 lda   [3],y
5779 28C6 85 05                 sta   5
5780 28C8 86 03                 stx   3                        ;derefed line edit record
5781 28CA A0 06 00              ldy   #6
5782 28CD AD 9D 2D              lda   jnMaxLength
5783 28D0 C9 20 00              cmp   #32
5784 28D3 B0 02                 bcs   @whoops
5785 28D5 97 03                 sta   [3],y                    ;stuff in a new maximum length
5786 28D7 2B           @whoops  pld   
5787 28D8 68                    pla   
5788 28D9 68                    pla   
5789 28DA
5790 28DA AD 70 2D              lda   TheNewVolumeName
5791 28DD EB                    xba   
5792 28DE 8D 70 2D              sta   TheNewVolumeName         ;change to pstring
5793 28E1 48                    pha   
5794 28E2 48                    pha   
5795 28E3 A2 0E 15 22           _FrontWindow 
5796 28EA F4 00 00 F4           pushlong #3                    ;edit line control ID
5797 28F0 F4 02 00 F4           pushlong #TheNewVolumeName+1 
5798 28F6 A2 10 3A 22           _SetLETextByID 
5799 28FD AD 70 2D              lda   TheNewVolumeName
5800 2900 EB                    xba   
5801 2901 8D 70 2D              sta   TheNewVolumeName
5802 2904
5803 2904              *** @modalLoop -- come back here for another try at renaming the thing
5804 2904
5805 2904 48           @modalLoop pha   
5806 2905 48                    pha                            ;space for DoModalWindow result
5807 2906 F4 02 00 F4           pushlong #myEventRec 
5808 290C A2 00 00              ldx   #0
5809 290F DA                    phx   
5810 2910 DA                    phx                            ;update routine
5811 2911 F4 02 80 F4           pushlong #myEventFilter+$80000000   ;bit 31 of event hook = do Apple-period-->ESC
5812 2917 DA                    phx   
5813 2918 DA                    phx                            ;beep proc
5814 2919 F4 09 00              pea   $0009                    ;noScrapForLE, use I-Beam cursor
5815 291C A2 0E 64 22           _DoModalWindow 
5816 2923 68                    pla   
5817 2924 FA                    plx   
5818 2925 C9 04 00              cmp   #4                       ;Eject button?
5819 2928 D0 1F                 bne   @notEject
5820 292A
5821 292A              ; eject the device and update its status
5822 292A A5 10        @doEject lda   <@resultDevNum
5823 292C 8D 37 2F              sta   EjectDevNum
5824 292F F4 02 00 F4           pushlong #EjectParms 
5825 2935 F4 2E 20              pea   $202E                    ;_DControl
5826 2938 22 B0 00 E1           jsl   $e100b0
5827 293C
5828 293C A5 10                 lda   <@resultDevNum
5829 293E 20 AD 2D              jsr   NotifyEjecting           ;added 8-Jan-92 DAL
5830 2941 20 C1 26              jsr   @UpdateDeviceA
5831 2944
5832 2944 64 10                 stz   <@resultDevNum           ;don't tell the caller about it
5833 2946
5834 2946 82 C2 00              brl   @done
5835 2949
5836 2949 C9 05 00     @notEject cmp   #5                      ;Rename button?
5837 294C F0 58                 beq   @hitRename
5838 294E
5839 294E C9 03 00              cmp   #3                       ;Edit line control?
5840 2951 D0 B1                 bne   @modalLoop
5841 2953
5842 2953 48                    pha                            ;space for LEGetTextLen
5843 2954 48                    pha   
5844 2955 48                    pha                            ;space for GetCtlTitle
5845 2956 48                    pha   
5846 2957 48                    pha                            ;space for GetCtlHandleFromID
5847 2958 48                    pha   
5848 2959 48                    pha                            ;space for FrontWindow
5849 295A A2 0E 15 22           _FrontWindow 
5850 2961 F4 00 00              pea   0
5851 2964 F4 03 00              pea   3                        ;ctl ID (long)
5852 2967 A2 10 30 22           _GetCtlHandleFromID 
5853 296E A2 10 0D 22           _GetCtlTitle 
5854 2975 A2 14 23 22           _LEGetTextLen 
5855 297C AA                    tax                            ;X=0
5856 297D 68                    pla   
5857 297E D0 03                 bne   @hiliteX
5858 2980 A2 FF 00              ldx   #$00ff
5859 2983 DA           @hiliteX phx   
5860 2984 48                    pha   
5861 2985 48                    pha                            ;space for GetCtlHandleFromID
5862 2986 48                    pha   
5863 2987 48                    pha                            ;space for FrontWindow
5864 2988 A2 0E 15 22           _FrontWindow 
5865 298F F4 00 00 F4           pushlong #5                    ;Rename button control ID
5866 2995 A2 10 30 22           _GetCtlHandleFromID 
5867 299C A2 10 11 22           _HiliteControl 
5868 29A3
5869 29A3 82 5E FF              brl   @modalLoop
5870 29A6
5871 29A6 20 2C 23     @hitRename jsr   doInitCursor           ;14-Nov-91 DAL
5872 29A9 48                    pha   
5873 29AA 48                    pha   
5874 29AB A2 0E 15 22           _FrontWindow 
5875 29B2 F4 00 00 F4           pushlong #3                    ;Edit Line Control ID
5876 29B8 F4 02 00 F4           pushlong #TheNewVolumeName+2 
5877 29BE A2 10 3B 22           _GetLETextByID 
5878 29C5 AD 72 2D              lda   TheNewVolumeName+2
5879 29C8 29 FF 00              and   #$00ff
5880 29CB 1A                    inc   a
5881 29CC 8D 70 2D              sta   TheNewVolumeName
5882 29CF A9 3A 00              lda   #$3a
5883 29D2 E2 20                 sep   #$20
5884 29D4 8D 72 2D              sta   TheNewVolumeName+2       ;put a colon on the beginning
5885 29D7 C2 20                 rep   #$20
5886 29D9
5887 29D9 AD EF 2E              lda   FormatDeviceName
5888 29DC EB                    xba   
5889 29DD 8D EF 2E              sta   FormatDeviceName
5890 29E0
5891 29E0              ; @@@ should do a JudgeName here
5892 29E0
5893 29E0 F4 02 00 F4           pushlong #RenameParms 
5894 29E6 F4 04 20              pea   $2004                    ;ChangePathGS
5895 29E9 22 B0 00 E1           jsl   $e100b0
5896 29ED
5897 29ED AA                    tax   
5898 29EE AD EF 2E              lda   FormatDeviceName
5899 29F1 EB                    xba   
5900 29F2 8D EF 2E              sta   FormatDeviceName
5901 29F5 8A                    txa   
5902 29F6
5903 29F6 90 13                 bcc   @done
5904 29F8
5905 29F8 48                    pha                            ;space
5906 29F9 A2 00 00              ldx   #0
5907 29FC DA                    phx   
5908 29FD DA                    phx   
5909 29FE DA                    phx   
5910 29FF 48                    pha                            ;error number
5911 2A00 A2 0E 62 22           _ErrorWindow 
5912 2A07 68                    pla                            ;get rid of button number
5913 2A08 82 F9 FE              brl   @modalLoop               ;20-May-91 DAL
5914 2A0B
5915 2A0B A2 0E 0B 22  @done    _CloseWindow 
5916 2A12
5917 2A12 20 4D 2F              jsr   FlushKeyEvents           ;4-Oct-91 DAL
5918 2A15
5919 2A15 A2 04 8E 22  @abort   _SetCursor                     ;restore cursor
5920 2A1C A2 04 91 22           _ShowCursor                    ;because typing into the Edit Line obscured it!
5921 2A23 A2 10 34 22           _SetCtlParamPtr                ;restore old substitution array
5922 2A2A 18                    clc                            ;don't format
5923 2A2B 60                    rts   
5924 2A2C
5925 2A2C 15 2F 02 00  mySubstitutions DC L:VolumeName+2       ;volume name
5926 2A30 F0 2E 02 00           DC L:FormatDeviceName+1        ;disk name
5927 2A34
5928 2A34 00 00 00 00  myEventRec DS B:46
5929 2A62
5930 2A62 03 00        RenameParms DC W:3                      ;was 2 (5-Dec-91 DAL)
5931 2A64 EF 2E 02 00           DC L:FormatDeviceName
5932 2A68 70 2D 02 00           DC L:TheNewVolumeName
5933 2A6C 00 80                 DC W:$8000                     ;Trust me!  (5-Dec-91 DAL)
5934 2A6E
5935 2A6E 25 00        NewVolNameResultBuff DC W:37
5936 2A70 00 00 00 00  TheNewVolumeName DS B:35
5937 2A93
5938 2A93 06 00        JudgeNameParms DC W:6                   ;pcount
5939 2A95 00 00        jnFileSystem DC W:0                     ;file sys id
5940 2A97 01 00                 DC W:1                         ;name type = volume name
5941 2A99 00 00 00 00           DC L:0                         ;syntax string (result)
5942 2A9D 00 00        jnMaxLength DC W:0                      ;max name length
5943 2A9F 6E 2D 02 00           DC L:NewVolNameResultBuff
5944 2AA3 00 00                 DC W:0                         ;name flags (result)
5945 2AA5
5946 2AA5 02 00        getFileInfoParms DC W:2                 ;just get the access
5947 2AA7 EF 2E 02 00           DC L:FormatDeviceName
5948 2AAB 00 00        gfiAccess DC W:0
5949 2AAD
5950 2AAD              **********************************************************************
5951 2AAD              *
5952 2AAD              * NotifyEjecting -- send a SendRequest(systemSaysEjectingDev) so
5953 2AAD              *                   that EasyMount will not try to open a window
5954 2AAD              *                   for a duplicate volume.
5955 2AAD              *
5956 2AAD              * Input:  device number in A (preserved)
5957 2AAD              *
5958 2AAD              * systemSaysEjectingDev:  dataIn low word = devNum.  High word and
5959 2AAD              *                         dataOut are reserved.
5960 2AAD              *
5961 2AAD              * 8-Jan-92 DAL
5962 2AAD              *
5963 2AAD              **********************************************************************
5964 2AAD 48           NotifyEjecting pha                      ;preserve devnum
5965 2AAE
5966 2AAE A2 00 00              ldx   #0
5967 2AB1 F4 0E 00              pea   systemSaysEjectingDev
5968 2AB4 DA                    phx                            ;send to all
5969 2AB5 DA                    phx   
5970 2AB6 DA                    phx                            ;target=all
5971 2AB7 DA                    phx   
5972 2AB8 48                    pha                            ;dataIn = devnum
5973 2AB9 DA                    phx   
5974 2ABA DA                    phx                            ;dataOut = nil
5975 2ABB A2 01 1C 22           _SendRequest 
5976 2AC2
5977 2AC2 68                    pla                            ;restore devnum
5978 2AC3 60                    rts   
5979 2AC4
5980 2AC4              **********************************************************************
5981 2AC4              *
5982 2AC4              * DoModalWindow event filter for the Rename-volume dialog.
5983 2AC4              *
5984 2AC4              * Changes keypresses of ":" and up/down arrows into null events,
5985 2AC4              * Apple-e and Apple-E into escape (Eject).
5986 2AC4              *
5987 2AC4              * For an update event, draws the Disk icon in the top left.
5988 2AC4              *
5989 2AC4              **********************************************************************
5990 2AC4 0B           MyEventFilter phd   
5991 2AC5 3B                    tsc   
5992 2AC6 5B                    tcd   
5993 2AC7 A7 06                 lda   [6]
5994 2AC9 C9 03 00              cmp   #3
5995 2ACC F0 05                 beq   @key
5996 2ACE C9 05 00              cmp   #5
5997 2AD1 D0 3C                 bne   @notKey
5998 2AD3
5999 2AD3 A0 02 00     @key     ldy   #2                       ;message
6000 2AD6 B7 06                 lda   [6],y
6001 2AD8 29 FF 00              and   #$00ff
6002 2ADB C9 0A 00              cmp   #$000a
6003 2ADE F0 0A                 beq   @killKey
6004 2AE0 C9 0B 00              cmp   #$000b
6005 2AE3 F0 05                 beq   @killKey
6006 2AE5 C9 3A 00              cmp   #$003a                   ;Colon?
6007 2AE8 D0 07                 bne   @notColon
6008 2AEA A9 00 00     @killKey lda   #0
6009 2AED 87 06                 sta   [6]                      ;make it a null event
6010 2AEF 80 4F                 bra   @exit
6011 2AF1
6012 2AF1 A0 0E 00     @notColon ldy   #14                     ;modifiers
6013 2AF4 B7 06                 lda   [6],y
6014 2AF6 29 00 01              and   #$0100                   ;Apple key down?
6015 2AF9 F0 14                 beq   @notKey                  ;nope
6016 2AFB
6017 2AFB A0 02 00              ldy   #2                       ;check message field for character
6018 2AFE B7 06                 lda   [6],y
6019 2B00 29 DF 00              and   #$00df
6020 2B03 C9 45 00              cmp   #$0045                   ;'e' or 'E'
6021 2B06 D0 07                 bne   @notKey
6022 2B08 A9 1B 00              lda   #$001B                   ;Escape for Eject
6023 2B0B 97 06                 sta   [6],y
6024 2B0D              *** added 22-Nov-91 DAL -- handle updates
6025 2B0D 80 31                 bra   @exit
6026 2B0F
6027 2B0F C9 06 00     @notKey  cmp   #6                       ;Update event
6028 2B12 D0 2C                 bne   @notUpdate
6029 2B14
6030 2B14 48                    pha   
6031 2B15 48                    pha   
6032 2B16 A2 0E 15 22           _FrontWindow 
6033 2B1D 68                    pla   
6034 2B1E FA                    plx   
6035 2B1F A0 02 00              ldy   #2                       ;offset to Message field (window ptr)
6036 2B22 D7 06                 cmp   [6],y
6037 2B24 D0 1A                 bne   @notMyUpdate
6038 2B26 C8                    iny   
6039 2B27 C8                    iny   
6040 2B28 8A                    txa   
6041 2B29 D7 06                 cmp   [6],y
6042 2B2B D0 13                 bne   @notMyUpdate
6043 2B2D
6044 2B2D 20 4C 2E              jsr   pushIconPtr
6045 2B30 F4 00 00              pea   0                        ;mode 0
6046 2B33 F4 14 00              pea   20                       ;X=20
6047 2B36 F4 07 00              pea   7                        ;Y=7
6048 2B39 A2 12 0B 22           _DrawIcon 
6049 2B40              @notMyUpdate  
6050 2B40              @notUpdate  
6051 2B40              *** end 22-Nov-91
6052 2B40
6053 2B40 2B           @exit    pld   
6054 2B41 A3 02                 lda   2,s
6055 2B43 83 06                 sta   2+4,s
6056 2B45 A3 01                 lda   1,s
6057 2B47 83 05                 sta   1+4,s
6058 2B49 68                    pla   
6059 2B4A 68                    pla   
6060 2B4B 6B                    rtl   
6061 2B4C
6062 2B4C              *** added 22-Nov-91 DAL -- push ptr to 640 or 320 disk icon
6063 2B4C 48           pushIconPtr pha   
6064 2B4D 48                    pha   
6065 2B4E F4 01 80              pea   $8001                    ;rIcon
6066 2B51 F4 FF 07              pea   $07FF
6067 2B54 48                    pha   
6068 2B55 A2 04 17 22           _GetMasterSCB 
6069 2B5C 68                    pla   
6070 2B5D              ;;;	ldy	#$0005	;anticipate 640
6071 2B5D A0 03 00              ldy   #$0003                   ;640 note icon (19-Feb-93 DAL)
6072 2B60 29 80 00              and   #$0080
6073 2B63 D0 03                 bne   @640
6074 2B65              ;;;	ldy	#$0105
6075 2B65 A0 03 01              ldy   #$0103                   ;320 note icon (19-Feb-93 DAL)
6076 2B68 5A           @640     phy   
6077 2B69 A2 1E 0E 22           _LoadResource 
6078 2B70 0B                    phd   
6079 2B71 3B                    tsc   
6080 2B72 5B                    tcd   
6081 2B73 A0 02 00              ldy   #2
6082 2B76 B7 03                 lda   [3],y
6083 2B78 AA                    tax   
6084 2B79 A7 03                 lda   [3]
6085 2B7B 85 03                 sta   <3
6086 2B7D 86 05                 stx   <5
6087 2B7F 2B                    pld                            ;result is now on stack
6088 2B80
6089 2B80 7A                    ply   
6090 2B81 68                    pla                            ;AY=resul
6091 2B82 FA                    plx                            ;RTS address
6092 2B83 48                    pha   
6093 2B84 5A                    phy                            ;pushed result
6094 2B85 DA                    phx                            ;pushed RTS address
6095 2B86 60                    rts   
6096 2B87              *** end 22-Nov-91
6097 2B87
6098 2B87              **********************************************************************
6099 2B87
6100 2B87 00 00        PrevTime DC W:0
6101 2B89 00 00 00 00  DevStatTable DC W:0,0,0,0,0,0,0,0       ;128 status bits!
6102 2B99
6103 2B99 77 77        DInfoParms DC W:$7777                   ;caller must store 3 or 8 (21-Nov-91 DAL)
6104 2B9B 00 00        DInfoDevNum DC W:0                      ;device number
6105 2B9D ED 2E 02 00           DC L:FormatDeviceBuffer
6106 2BA1 00 00        DInfoChar DC W:0
6107 2BA3 00 00 00 00           DC L:0                         ;total blocks
6108 2BA7 00 00                 DC W:0                         ;slot num
6109 2BA9 00 00                 DC W:0                         ;unit num
6110 2BAB 00 00                 DC W:0                         ;version
6111 2BAD 00 00        device_id DC W:0
6112 2BAF
6113 2BAF
6114 2BAF 00 00        DeviceID DC W:0                         ;dev_id from skanky @GetDeviceID
6115 2BB1
6116 2BB1 05 00        DStatusParms DC W:5
6117 2BB3 00 00        DStatusDevNum DC W:0
6118 2BB5 00 00                 DC W:0                         ;status code 0
6119 2BB7 C3 2E 02 00           DC L:TheStatusWord
6120 2BBB 02 00 00 00           DC L:2                         ;request count
6121 2BBF 00 00 00 00           DC L:0                         ;transfer count
6122 2BC3
6123 2BC3 00 00        TheStatusWord DC W:0
6124 2BC5
6125 2BC5 08 00        VolumeParms DC W:8
6126 2BC7 EF 2E 02 00           DC L:FormatDeviceName
6127 2BCB 11 2F 02 00           DC L:VolumeNameBuffer
6128 2BCF 00 00 00 00           DC L:0                         ;blocks
6129 2BD3 00 00 00 00           DC L:0                         ;free blocks
6130 2BD7 00 00        volFileSys DC W:0                       ;file system (valid for dup-vol err if 8 parms!)
6131 2BD9 00 00                 DC W:0                         ;block size
6132 2BDB 00 00        volCharacteristics DC W:0               ;device/filesys characteristics
6133 2BDD 00 00        volDeviceID DC W:0                      ;device ID
6134 2BDF
6135 2BDF              *** added 2-Dec-91 DAL
6136 2BDF 02 00        gfiParms DC W:2                         ;2 parameters
6137 2BE1 13 2F 02 00           DC L:VolumeName
6138 2BE5 00 00                 DC W:0                         ;access
6139 2BE7              *** end 2-Dec-91
6140 2BE7
6141 2BE7 01 00        FormatParms DC W:1                      ;just one parameter
6142 2BE9 EF 2E 02 00           DC L:FormatDeviceName
6143 2BED
6144 2BED 24 00        FormatDeviceBuffer DC W:36
6145 2BEF 00 00 00 00  FormatDeviceName DS B:34
6146 2C11
6147 2C11 24 00        VolumeNameBuffer DC W:36
6148 2C13 00 00 00 00  VolumeName DS B:34
6149 2C35
6150 2C35 05 00        EjectParms DC W:5
6151 2C37 00 00        EjectDevNum DC W:0
6152 2C39 02 00                 DC W:2                         ;control code
6153 2C3B 00 00 00 00           DC L:0                         ;control list
6154 2C3F 00 00 00 00           DC L:0                         ;request count
6155 2C43 00 00 00 00           DC L:0                         ;transfer count
6156 2C47
6157 2C47 00 00 00 00  srqDataOut DC W:0,0,0                   ;recvCount, reserved, disposition
6158 2C4D
6159 2C4D              **********************************************************************
6160 2C4D
6161 2C4D                       EndP 
6162 2C4D
6163 2C4D              **********************************************************************
6164 2C4D              *
6165 2C4D              * FlushKeyEvents -- kill all pending keyDown and autoKey events (DAL)
6166 2C4D              *
6167 2C4D              **********************************************************************
6168 2C4D              FlushKeyEvents proc export 
6169 2C4D 48                    pha                            ;space for result
6170 2C4E F4 28 00              pea   $0028                    ;keyDown and autoKey events
6171 2C51 F4 00 00              pea   $0000                    ;don't stop, kill 'em all
6172 2C54 A2 06 15 22           _FlushEvents 
6173 2C5B 68                    pla                            ;discard result flag
6174 2C5C 60                    rts   
6175 2C5D
6176 2C5D                       EndP 
6177 2C5D
6178 2C5D              ****************************************************************
6179 2C5D              *
6180 2C5D              * UpdateWindow $6C0E -- new call 6-Mar-92 DAL for 6.0.1
6181 2C5D              *
6182 2C5D              * Input:
6183 2C5D              *   push flags (word)
6184 2C5D              *   push window pointer (long)
6185 2C5D              *
6186 2C5D              * Flags:
6187 2C5D              *   bit 15 = window's expected environment may not be set up ("background update")
6188 2C5D              *            (requires wContDraw bit 31, saying that the wContDraw routine can take
6189 2C5D              *             care of itself)
6190 2C5D              *   bit 14 = GS/OS is *not* available or not safe to call
6191 2C5D              *            (requires wContDraw bit 30, saying that the wContDraw doesn't need to
6192 2C5D              *             call GS/OS)
6193 2C5D              *   bits 13-0 = reserved, use 0
6194 2C5D              *
6195 2C5D              ****************************************************************
6196 2C5D              UpdateWindow proc export 
6197 2C5D                       import longCall 
6198 2C5D
6199 2C5D 0B                    phd   
6200 2C5E 48                    pha   
6201 2C5F 48                    pha                            ;space for drawPtr
6202 2C60 3B                    tsc   
6203 2C61 5B                    tcd   
6204 2C62
6205 2C62              @drawPtr equ   1
6206 2C62              @oldD    equ   @drawPtr+4
6207 2C62              @rtls    equ   @oldD+2
6208 2C62              @window  equ   @rtls+6
6209 2C62              @flags   equ   @window+4
6210 2C62
6211 2C62              *** added 23-Mar-93 DAL -- never background-update a System window (that should only
6212 2C62              ***    happen from a System window's code, called from inside SystemEvent, so the
6213 2C62              ***    background-update flag will not be set).
6214 2C62 A5 11                 lda   <@flags
6215 2C64 10 14                 bpl   @notBackground
6216 2C66
6217 2C66 48                    pha   
6218 2C67 D4 0F                 pei   <@window+2
6219 2C69 D4 0D                 pei   <@window
6220 2C6B A2 0E 4C 22           _GetSysWFlag 
6221 2C72 68                    pla   
6222 2C73 10 05                 bpl   @notSysWind
6223 2C75
6224 2C75 A2 05 0E              ldx   #cantUpdateErr
6225 2C78 80 6A                 bra   @errorExit
6226 2C7A              @notSysWind  
6227 2C7A              @notBackground  
6228 2C7A              *** end 23-Mar-93 DAL
6229 2C7A
6230 2C7A 48                    pha   
6231 2C7B 48                    pha                            ;space for GetContentDraw
6232 2C7C D4 0F                 pei   <@window+2
6233 2C7E D4 0D                 pei   <@window
6234 2C80 A2 0E 48 22           _GetContentDraw 
6235 2C87 68                    pla   
6236 2C88 85 01                 sta   <@drawPtr
6237 2C8A 68                    pla   
6238 2C8B 85 03                 sta   <@drawPtr+2
6239 2C8D A2 05 0E              ldx   #cantUpdateErr
6240 2C90 A5 02                 lda   <@drawPtr+1
6241 2C92 F0 50                 beq   @errorExit
6242 2C94
6243 2C94              *** If GS/OS is busy, force flag bit 14
6244 2C94 AF BE 00 E1           lda   >$e100be
6245 2C98 10 05                 bpl   @notBusy
6246 2C9A A9 00 40              lda   #$4000
6247 2C9D 04 11                 tsb   <@flags
6248 2C9F              @notBusy  
6249 2C9F
6250 2C9F              *** Any bits in <flags require bits in wContDraw to be set, or we can't update.
6251 2C9F A5 03                 lda   <@drawPtr+2
6252 2CA1 49 FF FF              eor   #$ffff
6253 2CA4 25 11                 and   <@flags
6254 2CA6 A2 05 0E              ldx   #cantUpdateErr
6255 2CA9 29 00 FF              and   #$ff00
6256 2CAC D0 36                 bne   @errorExit
6257 2CAE
6258 2CAE A5 0F                 lda   <@window+2
6259 2CB0 A6 0D                 ldx   <@window
6260 2CB2 48                    pha   
6261 2CB3 DA                    phx                            ;for EndUpdate
6262 2CB4 48                    pha   
6263 2CB5 DA                    phx                            ;for StartDrawing
6264 2CB6 48                    pha   
6265 2CB7 DA                    phx                            ;for BeginUpdate
6266 2CB8 A2 0E 1E 22           _BeginUpdate 
6267 2CBF A2 0E 4D 22           _StartDrawing 
6268 2CC6
6269 2CC6 A6 02                 ldx   <@drawPtr+1
6270 2CC8 A5 01                 lda   <@drawPtr
6271 2CCA 22 EC 0D 02           jsl   longCall
6272 2CCE
6273 2CCE A9 00 00              lda   #0
6274 2CD1 48                    pha   
6275 2CD2 48                    pha   
6276 2CD3 A2 04 23 22           _SetOrigin 
6277 2CDA A2 0E 1F 22           _EndUpdate 
6278 2CE1
6279 2CE1 A2 00 00     @noError ldx   #0                       ;no error
6280 2CE4 68           @errorExit pla   
6281 2CE5 68                    pla   
6282 2CE6 2B                    pld   
6283 2CE7 A0 06 00              ldy   #6                       ;strip 6 bytes
6284 2CEA 5C 84 01 E1           jml   $e10184                  ;ToStrip
6285 2CEE
6286 2CEE                       EndP 
6287 2CEE
6288 2CEE                       END   
